/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.PoolableConnectionMXBean;
import org.apache.commons.pool2.ObjectPool;

public class PoolableConnection
extends DelegatingConnection<Connection>
implements PoolableConnectionMXBean {
    private static MBeanServer MBEAN_SERVER = null;
    private ObjectPool<PoolableConnection> _pool = null;
    private final ObjectName _jmxName;
    private PreparedStatement validationPreparedStatement = null;
    private String lastValidationSql = null;

    public PoolableConnection(Connection conn, ObjectPool<PoolableConnection> pool, ObjectName jmxName) {
        super(conn);
        this._pool = pool;
        this._jmxName = jmxName;
        if (jmxName != null) {
            try {
                MBEAN_SERVER.registerMBean(this, jmxName);
            }
            catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
                // empty catch block
            }
        }
    }

    @Override
    protected void passivate() throws SQLException {
        super.passivate();
        this.setClosedInternal(true);
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.isClosedInternal()) {
            return true;
        }
        if (this.getDelegateInternal().isClosed()) {
            this.close();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close() throws SQLException {
        boolean isUnderlyingConectionClosed;
        if (this.isClosedInternal()) {
            return;
        }
        try {
            isUnderlyingConectionClosed = this.getDelegateInternal().isClosed();
        }
        catch (SQLException e) {
            try {
                this._pool.invalidateObject(this);
            }
            catch (IllegalStateException ise) {
                this.passivate();
                this.getInnermostDelegate().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SQLException("Cannot close connection (isClosed check failed)", e);
        }
        if (isUnderlyingConectionClosed) {
            try {
                this._pool.invalidateObject(this);
            }
            catch (IllegalStateException e) {
                this.passivate();
                this.getInnermostDelegate().close();
            }
            catch (Exception e) {
                throw new SQLException("Cannot close connection (invalidating pooled object failed)", e);
            }
        } else {
            try {
                this._pool.returnObject(this);
            }
            catch (IllegalStateException e) {
                this.passivate();
                this.getInnermostDelegate().close();
            }
            catch (SQLException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Cannot close connection (return to pool failed)", e);
            }
        }
    }

    @Override
    public void reallyClose() throws SQLException {
        if (this._jmxName != null) {
            try {
                MBEAN_SERVER.unregisterMBean(this._jmxName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException e) {
                // empty catch block
            }
        }
        if (this.validationPreparedStatement != null) {
            try {
                this.validationPreparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.closeInternal();
    }

    @Override
    public String getToString() {
        return this.toString();
    }

    public void validate(String sql, int timeout) throws SQLException {
        if (sql == null || sql.length() == 0) {
            if (timeout < 0) {
                timeout = 0;
            }
            if (!this.isValid(timeout)) {
                throw new SQLException("isValid() returned false");
            }
            return;
        }
        if (!sql.equals(this.lastValidationSql)) {
            this.lastValidationSql = sql;
            this.validationPreparedStatement = this.getInnermostDelegateInternal().prepareStatement(sql);
        }
        if (timeout > 0) {
            this.validationPreparedStatement.setQueryTimeout(timeout);
        }
        try (ResultSet rs = this.validationPreparedStatement.executeQuery();){
            if (!rs.next()) {
                throw new SQLException("validationQuery didn't return a row");
            }
        }
    }

    static {
        try {
            MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

