/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.io.druid.java.util.common.guava.LazySequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.query.AbstractPrioritizedCallable;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryContexts;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryWatcher;

public class AsyncQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;
    private final ListeningExecutorService executor;
    private final QueryWatcher queryWatcher;

    public AsyncQueryRunner(QueryRunner<T> baseRunner, ExecutorService executor, QueryWatcher queryWatcher) {
        this.baseRunner = baseRunner;
        this.executor = MoreExecutors.listeningDecorator(executor);
        this.queryWatcher = queryWatcher;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, final Map<String, Object> responseContext) {
        final Query<T> query = queryPlus.getQuery();
        int priority = QueryContexts.getPriority(query);
        final QueryPlus<T> threadSafeQueryPlus = queryPlus.withoutThreadUnsafeState();
        Future future = this.executor.submit((Callable)new AbstractPrioritizedCallable<Sequence<T>>(priority){

            @Override
            public Sequence<T> call() throws Exception {
                return AsyncQueryRunner.this.baseRunner.run(threadSafeQueryPlus, responseContext);
            }
        });
        this.queryWatcher.registerQuery(query, (ListenableFuture)future);
        return new LazySequence(new Supplier<Sequence<T>>((ListenableFuture)future){
            final /* synthetic */ ListenableFuture val$future;
            {
                this.val$future = listenableFuture;
            }

            @Override
            public Sequence<T> get() {
                try {
                    if (QueryContexts.hasTimeout(query)) {
                        return (Sequence)this.val$future.get(QueryContexts.getTimeout(query), TimeUnit.MILLISECONDS);
                    }
                    return (Sequence)this.val$future.get();
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    throw Throwables.propagate(ex);
                }
            }
        });
    }
}

