/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.Transaction;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlObjectBuilder;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;
import org.skife.jdbi.v2.sqlobject.mixins.CloseMe;
import org.skife.jdbi.v2.sqlobject.mixins.GetHandle;
import org.skife.jdbi.v2.sqlobject.mixins.Transactional;
import org.skife.jdbi.v2.sqlobject.mixins.Transmogrifier;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class TestMixinInterfaces {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(String.format("jdbc:h2:mem:%s;MVCC=TRUE", UUID.randomUUID()));
        this.dbi = new DBI((DataSource)ds);
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testGetHandle() throws Exception {
        WithGetHandle g = (WithGetHandle)SqlObjectBuilder.attach((Handle)this.handle, WithGetHandle.class);
        Handle h = g.getHandle();
        Assert.assertSame((Object)this.handle, (Object)h);
    }

    @Test
    public void testWithHandle() throws Exception {
        WithGetHandle g = (WithGetHandle)SqlObjectBuilder.attach((Handle)this.handle, WithGetHandle.class);
        String name = (String)g.withHandle((HandleCallback)new HandleCallback<String>(){

            public String withHandle(Handle handle) throws Exception {
                handle.execute("insert into something (id, name) values (8, 'Mike')", new Object[0]);
                return (String)handle.createQuery("select name from something where id = 8").map((ResultSetMapper)StringMapper.FIRST).first();
            }
        });
        Assert.assertEquals((Object)"Mike", (Object)name);
    }

    @Test
    public void testBeginAndCommitTransaction() throws Exception {
        TransactionStuff txl = (TransactionStuff)SqlObjectBuilder.attach((Handle)this.handle, TransactionStuff.class);
        txl.insert(8L, "Mike");
        txl.begin();
        txl.updateName(8L, "Miker");
        Assert.assertEquals((Object)"Miker", (Object)txl.byId(8L).getName());
        txl.rollback();
        Assert.assertEquals((Object)"Mike", (Object)txl.byId(8L).getName());
    }

    @Test
    public void testInTransaction() throws Exception {
        TransactionStuff txl = (TransactionStuff)SqlObjectBuilder.attach((Handle)this.handle, TransactionStuff.class);
        txl.insert(7L, "Keith");
        Something s = (Something)txl.inTransaction((Transaction)new Transaction<Something, TransactionStuff>(){

            public Something inTransaction(TransactionStuff conn, TransactionStatus status) throws Exception {
                return conn.byId(7L);
            }
        });
        Assert.assertEquals((Object)"Keith", (Object)s.getName());
    }

    @Test
    public void testInTransactionWithLevel() throws Exception {
        TransactionStuff txl = (TransactionStuff)SqlObjectBuilder.attach((Handle)this.handle, TransactionStuff.class);
        txl.insert(7L, "Keith");
        Something s = (Something)txl.inTransaction(TransactionIsolationLevel.SERIALIZABLE, (Transaction)new Transaction<Something, TransactionStuff>(){

            public Something inTransaction(TransactionStuff conn, TransactionStatus status) throws Exception {
                Assert.assertEquals((Object)TransactionIsolationLevel.SERIALIZABLE, (Object)conn.getHandle().getTransactionIsolationLevel());
                return conn.byId(7L);
            }
        });
        Assert.assertEquals((Object)"Keith", (Object)s.getName());
    }

    @Test
    public void testTransactionIsolationActuallyHappens() throws Exception {
        TransactionStuff txl = (TransactionStuff)SqlObjectBuilder.attach((Handle)this.handle, TransactionStuff.class);
        TransactionStuff tx2 = (TransactionStuff)SqlObjectBuilder.open((IDBI)this.dbi, TransactionStuff.class);
        txl.insert(8L, "Mike");
        txl.begin();
        txl.updateName(8L, "Miker");
        Assert.assertEquals((Object)"Miker", (Object)txl.byId(8L).getName());
        Assert.assertEquals((Object)"Mike", (Object)tx2.byId(8L).getName());
        txl.commit();
        Assert.assertEquals((Object)"Miker", (Object)tx2.byId(8L).getName());
        tx2.close();
    }

    @Test
    public void testJustJdbiTransactions() throws Exception {
        Handle h1 = this.dbi.open();
        Handle h2 = this.dbi.open();
        h1.execute("insert into something (id, name) values (8, 'Mike')", new Object[0]);
        h1.begin();
        h1.execute("update something set name = 'Miker' where id = 8", new Object[0]);
        Assert.assertEquals((Object)"Mike", (Object)h2.createQuery("select name from something where id = 8").map((ResultSetMapper)StringMapper.FIRST).first());
        h1.commit();
        h1.close();
        h2.close();
    }

    @Test
    public void testTransmogrifiable() throws Exception {
        Hobbsian h = (Hobbsian)this.handle.attach(Hobbsian.class);
        h.insert(2, "Cora");
        Something s = ((TransactionStuff)h.become(TransactionStuff.class)).byId(2L);
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.equalTo((Object)new Something(2, "Cora")));
    }

    public static interface TransactionStuff
    extends CloseMe,
    Transactional<TransactionStuff>,
    GetHandle {
        @SqlQuery(value="select id, name from something where id = :id")
        @Mapper(value=SomethingMapper.class)
        public Something byId(@Bind(value="id") long var1);

        @SqlUpdate(value="update something set name = :name where id = :id")
        public void updateName(@Bind(value="id") long var1, @Bind(value="name") String var3);

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }

    public static interface Hobbsian
    extends Transmogrifier {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);
    }

    public static interface WithGetHandle
    extends CloseMe,
    GetHandle {
    }
}

