/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.h2.jdbcx.JdbcDataSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindMap;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TestMapBinder
extends TestCase {
    private DBI dbi;
    private Handle handle;

    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:test");
        this.dbi = new DBI((DataSource)ds);
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100), a varchar(100), b int, c varchar(100))", new Object[0]);
    }

    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    public void testInsert() throws Exception {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        s.insert(this.allMap(5, "woo", 3, "too"));
        Result elem = s.load(5);
        TestMapBinder.assertEquals((String)"too", (String)elem.c);
        TestMapBinder.assertEquals((int)3, (int)elem.b);
    }

    public void testUpdate() throws Exception {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        s.insert(this.allMap(4, "woo", 1, "too"));
        HashMap<String, Object> update = new HashMap<String, Object>();
        update.put("a", "goo");
        update.put("b", 2);
        update.put("c", null);
        TestMapBinder.assertEquals((int)1, (int)s.update(4, update));
        Result elem = s.load(4);
        TestMapBinder.assertEquals((String)"goo", (String)elem.a);
        TestMapBinder.assertEquals((int)2, (int)elem.b);
        TestMapBinder.assertEquals((String)"too", (String)elem.c);
    }

    public void testUpdatePrefix() throws Exception {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        s.insert(this.allMap(4, "woo", 1, "too"));
        HashMap<Object, Object> update = new HashMap<Object, Object>();
        update.put("b", 2);
        update.put(new A(), "goo");
        TestMapBinder.assertEquals((int)1, (int)s.updatePrefix(4, update));
        Result elem = s.load(4);
        TestMapBinder.assertEquals((String)"goo", (String)elem.a);
        TestMapBinder.assertEquals((int)1, (int)elem.b);
        TestMapBinder.assertEquals((String)"too", (String)elem.c);
    }

    private Map<String, Object> allMap(int id, Object a, int b, Object c) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("a", a);
        map.put("b", b);
        map.put("c", c);
        return map;
    }

    static class A {
        A() {
        }

        public String toString() {
            return "a";
        }
    }

    static class Result {
        String a;
        String c;
        int id;
        int b;

        Result() {
        }
    }

    static class ResultMapper
    implements ResultSetMapper<Result> {
        ResultMapper() {
        }

        public Result map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            Result ret = new Result();
            ret.id = r.getInt("id");
            ret.a = r.getString("a");
            ret.b = r.getInt("b");
            ret.c = r.getString("c");
            return ret;
        }
    }

    static interface Spiffy {
        @SqlUpdate(value="insert into something (id, a, b, c) values (:id, :a, :b, :c)")
        public int insert(@BindMap Map<String, Object> var1);

        @SqlUpdate(value="update something set a=coalesce(:a, a), b=coalesce(:b, b), c=coalesce(:c, c) where id=:id")
        public int update(@Bind(value="id") int var1, @BindMap Map<String, Object> var2);

        @SqlUpdate(value="update something set a=coalesce(:asdf.a, a), c=coalesce(:asdf.c, c) where id=:id")
        public int updatePrefix(@Bind(value="id") int var1, @BindMap(prefix="asdf", value={"a", "c"}, implicitKeyStringConversion=true) Map<Object, Object> var2);

        @SqlQuery(value="select * from something where id = :id")
        @Mapper(value=ResultMapper.class)
        public Result load(@Bind(value="id") int var1);
    }
}

