/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.skife.jdbi.v2.exceptions.TransactionException;
import org.skife.jdbi.v2.exceptions.TransactionFailedException;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.IntegerMapper;

public class TestTransactions
extends DBITestCase {
    @Test
    public void testCallback() throws Exception {
        BasicHandle h = this.openHandle();
        String woot = (String)h.inTransaction((TransactionCallback)new TransactionCallback<String>(){

            public String inTransaction(Handle handle, TransactionStatus status) throws Exception {
                return "Woot!";
            }
        });
        Assert.assertEquals((Object)"Woot!", (Object)woot);
    }

    @Test
    public void testRollbackOutsideTx() throws Exception {
        BasicHandle h = this.openHandle();
        h.insert("insert into something (id, name) values (?, ?)", new Object[]{7, "Tom"});
        h.rollback();
    }

    @Test
    public void testDoubleOpen() throws Exception {
        BasicHandle h = this.openHandle();
        Assert.assertTrue((boolean)h.getConnection().getAutoCommit());
        h.begin();
        h.begin();
        Assert.assertFalse((boolean)h.getConnection().getAutoCommit());
        h.commit();
        Assert.assertTrue((boolean)h.getConnection().getAutoCommit());
    }

    @Test
    public void testExceptionAbortsTransaction() throws Exception {
        BasicHandle h = this.openHandle();
        try {
            h.inTransaction((TransactionCallback)new TransactionCallback<Object>(){

                public Object inTransaction(Handle handle, TransactionStatus status) throws Exception {
                    handle.insert("insert into something (id, name) values (:id, :name)", new Object[]{0, "Keith"});
                    throw new IOException();
                }
            });
            Assert.fail((String)"Should have thrown exception");
        }
        catch (TransactionFailedException e) {
            Assert.assertTrue((boolean)true);
        }
        List r = h.createQuery("select * from something").map(Something.class).list();
        Assert.assertEquals((long)0L, (long)r.size());
    }

    @Test
    public void testRollbackOnlyAbortsTransaction() throws Exception {
        BasicHandle h = this.openHandle();
        try {
            h.inTransaction((TransactionCallback)new TransactionCallback<Object>(){

                public Object inTransaction(Handle handle, TransactionStatus status) throws Exception {
                    handle.insert("insert into something (id, name) values (:id, :name)", new Object[]{0, "Keith"});
                    status.setRollbackOnly();
                    return "Hi";
                }
            });
            Assert.fail((String)"Should have thrown exception");
        }
        catch (TransactionFailedException e) {
            Assert.assertTrue((boolean)true);
        }
        List r = h.createQuery("select * from something").map(Something.class).list();
        Assert.assertEquals((long)0L, (long)r.size());
    }

    @Test
    public void testCheckpoint() throws Exception {
        BasicHandle h = this.openHandle();
        h.begin();
        h.insert("insert into something (id, name) values (:id, :name)", new Object[]{1, "Tom"});
        h.checkpoint("first");
        h.insert("insert into something (id, name) values (:id, :name)", new Object[]{1, "Martin"});
        Assert.assertEquals((Object)2, (Object)h.createQuery("select count(*) from something").map((ResultSetMapper)new IntegerMapper()).first());
        h.rollback("first");
        Assert.assertEquals((Object)1, (Object)h.createQuery("select count(*) from something").map((ResultSetMapper)new IntegerMapper()).first());
        h.commit();
        Assert.assertEquals((Object)1, (Object)h.createQuery("select count(*) from something").map((ResultSetMapper)new IntegerMapper()).first());
    }

    @Test
    public void testReleaseCheckpoint() throws Exception {
        BasicHandle h = this.openHandle();
        h.begin();
        h.checkpoint("first");
        h.insert("insert into something (id, name) values (:id, :name)", new Object[]{1, "Martin"});
        h.release("first");
        try {
            h.rollback("first");
            Assert.fail((String)"Should have thrown an exception of some kind");
        }
        catch (TransactionException e) {
            h.rollback();
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testThrowingRuntimeExceptionPercolatesOriginal() throws Exception {
        BasicHandle h = this.openHandle();
        try {
            h.inTransaction((TransactionCallback)new TransactionCallback<Object>(){

                public Object inTransaction(Handle handle, TransactionStatus status) throws Exception {
                    throw new IllegalArgumentException();
                }
            });
        }
        catch (DBIException e) {
            Assert.fail((String)"Should have thrown a straight RuntimeException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"Go here", (long)2L, (long)2L);
        }
        catch (Exception e) {
            Assert.fail((String)"Should have been caught at IllegalArgumentException");
        }
    }
}

