/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.Update;

public class TestNamedParams
extends DBITestCase {
    @Test
    public void testInsert() throws Exception {
        BasicHandle h = this.openHandle();
        Update insert = h.createStatement("insert into something (id, name) values (:id, :name)");
        insert.bind("id", 1);
        insert.bind("name", "Brian");
        int count = insert.execute();
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testDemo() throws Exception {
        Handle h = DBI.open((DataSource)DERBY_HELPER.getDataSource());
        ((Update)((Update)h.createStatement("insert into something (id, name) values (:id, :name)").bind("id", 1)).bind("name", "Brian")).execute();
        h.insert("insert into something (id, name) values (?, ?)", new Object[]{2, "Eric"});
        h.insert("insert into something (id, name) values (?, ?)", new Object[]{3, "Erin"});
        List r = ((Query)h.createQuery("select id, name from something where name like :name order by id").bind("name", "Eri%")).map(Something.class).list();
        Assert.assertEquals((long)2L, (long)r.size());
        Assert.assertEquals((long)2L, (long)((Something)r.get(0)).getId());
        Assert.assertEquals((long)3L, (long)((Something)r.get(1)).getId());
        h.close();
    }

    @Test
    public void testBeanPropertyBinding() throws Exception {
        BasicHandle h = this.openHandle();
        Update s = h.createStatement("insert into something (id, name) values (:id, :name)");
        s.bindFromProperties((Object)new Something(0, "Keith"));
        int insert_count = s.execute();
        Assert.assertEquals((long)1L, (long)insert_count);
    }

    @Test
    public void testMapKeyBinding() throws Exception {
        BasicHandle h = this.openHandle();
        Update s = h.createStatement("insert into something (id, name) values (:id, :name)");
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("id", 0);
        args.put("name", "Keith");
        s.bindFromMap(args);
        int insert_count = s.execute();
        Assert.assertEquals((long)1L, (long)insert_count);
    }

    @Test
    public void testCascadedLazyArgs() throws Exception {
        BasicHandle h = this.openHandle();
        Update s = h.createStatement("insert into something (id, name) values (:id, :name)");
        HashMap<String, Integer> args = new HashMap<String, Integer>();
        args.put("id", 0);
        s.bindFromMap(args);
        s.bindFromProperties(new Object(){

            public String getName() {
                return "Keith";
            }
        });
        int insert_count = s.execute();
        Assert.assertEquals((long)1L, (long)insert_count);
        Something something = (Something)h.createQuery("select id, name from something").map(Something.class).first();
        Assert.assertEquals((Object)"Keith", (Object)something.getName());
        Assert.assertEquals((long)0L, (long)something.getId());
    }
}

