/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.ColonPrefixNamedParamStatementRewriter;

public class TestEscapedCharacters {
    private final ColonPrefixNamedParamStatementRewriter rewriter = new ColonPrefixNamedParamStatementRewriter();

    private String parseString(String src) {
        return this.rewriter.parseString(src, new ColonPrefixNamedParamStatementRewriter.ParsedStatement());
    }

    @Test
    public void testSimpleString() {
        Assert.assertEquals((Object)"hello, world", (Object)this.parseString("hello, world"));
    }

    @Test
    public void testSimpleSql() {
        Assert.assertEquals((Object)"insert into foo (xyz) values (?)", (Object)this.parseString("insert into foo (xyz) values (:bar)"));
    }

    @Test
    public void testEscapedSql() {
        Assert.assertEquals((Object)"insert into foo (xyz) values (?::some_strange_type)", (Object)this.parseString("insert into foo (xyz) values (:bar\\:\\:some_strange_type)"));
    }
}

