/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.SQLException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.DBITestCase;

public class TestEnums
extends DBITestCase {
    @Test
    public void testMapEnumValues() throws Exception {
        BasicHandle h = this.openHandle();
        h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        List results = h.createQuery("select * from something order by id").map(SomethingElse.class).list();
        Assert.assertEquals((Object)((Object)SomethingElse.Name.eric), (Object)((Object)((SomethingElse)results.get(0)).name));
        Assert.assertEquals((Object)((Object)SomethingElse.Name.brian), (Object)((Object)((SomethingElse)results.get(1)).name));
    }

    @Test
    public void testMapInvalidEnumValue() throws SQLException {
        BasicHandle h = this.openHandle();
        h.createStatement("insert into something (id, name) values (1, 'joe')").execute();
        try {
            h.createQuery("select * from something order by id").map(SomethingElse.class).first();
            Assert.fail((String)"Expected IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)"flow control goes here", (long)4L, (long)4L);
        }
    }

    public static class SomethingElse {
        private int id;
        private Name name;

        public Name getName() {
            return this.name;
        }

        public void setName(Name name) {
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public static enum Name {
            eric,
            brian;

        }
    }
}

