/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.cglib.transform.AbstractClassLoader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.ClasspathStatementLocator;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.StatementException;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.sqlobject.stringtemplate.TestingStatementContext;

public class TestClasspathStatementLocator
extends DBITestCase {
    @Test
    public void testLocateNamedWithoutSuffix() throws Exception {
        BasicHandle h = this.openHandle();
        h.createStatement("insert-keith").execute();
        Assert.assertEquals((long)1L, (long)h.select("select name from something", new Object[0]).size());
    }

    @Test
    public void testLocateNamedWithSuffix() throws Exception {
        BasicHandle h = this.openHandle();
        h.insert("insert-keith.sql", new Object[0]);
        Assert.assertEquals((long)1L, (long)h.select("select name from something", new Object[0]).size());
    }

    @Test
    public void testCommentsInExternalSql() throws Exception {
        BasicHandle h = this.openHandle();
        h.insert("insert-eric-with-comments", new Object[0]);
        Assert.assertEquals((long)1L, (long)h.select("select name from something", new Object[0]).size());
    }

    @Test
    public void testNamedPositionalNamedParamsInPrepared() throws Exception {
        BasicHandle h = this.openHandle();
        h.insert("insert-id-name", new Object[]{3, "Tip"});
        Assert.assertEquals((long)1L, (long)h.select("select name from something", new Object[0]).size());
    }

    @Test
    public void testNamedParamsInExternal() throws Exception {
        BasicHandle h = this.openHandle();
        ((Update)((Update)h.createStatement("insert-id-name").bind("id", 1)).bind("name", "Tip")).execute();
        Assert.assertEquals((long)1L, (long)h.select("select name from something", new Object[0]).size());
    }

    @Test
    public void testUsefulExceptionForBackTracing() throws Exception {
        BasicHandle h = this.openHandle();
        try {
            ((Update)h.createStatement("insert-id-name").bind("id", 1)).execute();
            Assert.fail((String)"should have raised an exception");
        }
        catch (StatementException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("insert into something(id, name) values (:id, :name)"));
            Assert.assertTrue((boolean)e.getMessage().contains("insert into something(id, name) values (?, ?)"));
            Assert.assertTrue((boolean)e.getMessage().contains("insert-id-name"));
        }
    }

    @Test
    public void testTriesToParseNameIfNothingFound() throws Exception {
        BasicHandle h = this.openHandle();
        try {
            h.insert("this-does-not-exist.sql", new Object[0]);
            Assert.fail((String)"Should have raised an exception");
        }
        catch (UnableToCreateStatementException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testCachesResultAfterFirstLookup() throws Exception {
        ClassLoader ctx_loader = Thread.currentThread().getContextClassLoader();
        final AtomicInteger load_count = new AtomicInteger(0);
        Thread.currentThread().setContextClassLoader((ClassLoader)new AbstractClassLoader(ctx_loader, ctx_loader, null){

            public InputStream getResourceAsStream(String s) {
                InputStream in = super.getResourceAsStream(s);
                load_count.incrementAndGet();
                return in;
            }
        });
        BasicHandle h = this.openHandle();
        h.execute("caches-result-after-first-lookup", new Object[]{1, "Brian"});
        Assert.assertThat((Object)load_count.get(), (Matcher)CoreMatchers.equalTo((Object)2));
        h.execute("caches-result-after-first-lookup", new Object[]{2, "Sean"});
        Assert.assertThat((Object)load_count.get(), (Matcher)CoreMatchers.equalTo((Object)2));
        Thread.currentThread().setContextClassLoader(ctx_loader);
    }

    @Test
    public void testCachesOriginalQueryWhenNotFound() throws Exception {
        ClasspathStatementLocator statementLocator = new ClasspathStatementLocator();
        TestingStatementContext statementContext = new TestingStatementContext(new HashMap()){

            @Override
            public Class<?> getSqlObjectType() {
                return TestClasspathStatementLocator.class;
            }
        };
        String input = "missing query";
        String located = statementLocator.locate(input, (StatementContext)statementContext);
        Assert.assertEquals((Object)input, (Object)located);
        located = statementLocator.locate(input, (StatementContext)statementContext);
        Assert.assertEquals((Object)input, (Object)located);
    }
}

