/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.skife.jdbi.derby.DerbyHelper;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.CachingStatementBuilder;
import org.skife.jdbi.v2.ClasspathStatementLocator;
import org.skife.jdbi.v2.ColonPrefixNamedParamStatementRewriter;
import org.skife.jdbi.v2.ContainerFactoryRegistry;
import org.skife.jdbi.v2.DefaultStatementBuilder;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.MappingRegistry;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.logging.NoOpLog;
import org.skife.jdbi.v2.tweak.SQLLog;
import org.skife.jdbi.v2.tweak.StatementBuilder;
import org.skife.jdbi.v2.tweak.StatementLocator;
import org.skife.jdbi.v2.tweak.StatementRewriter;
import org.skife.jdbi.v2.tweak.TransactionHandler;
import org.skife.jdbi.v2.tweak.transactions.LocalTransactionHandler;

public abstract class DBITestCase {
    protected static final List<BasicHandle> HANDLES = new ArrayList<BasicHandle>();
    private ExecutorService executor;
    protected static final DerbyHelper DERBY_HELPER = new DerbyHelper();

    @BeforeClass
    public static void setUpClass() throws Exception {
        DERBY_HELPER.start();
    }

    @Before
    public final void setUp() throws Exception {
        DERBY_HELPER.dropAndCreateSomething();
        this.doSetUp();
    }

    protected void doSetUp() throws Exception {
    }

    @After
    public final void tearDown() throws Exception {
        this.doTearDown();
    }

    protected void doTearDown() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        for (BasicHandle handle : HANDLES) {
            handle.close();
        }
        DERBY_HELPER.stop();
    }

    protected StatementLocator getStatementLocator() {
        return new ClasspathStatementLocator();
    }

    protected BasicHandle openHandle() throws SQLException {
        return this.openHandle(DERBY_HELPER.getConnection());
    }

    protected BasicHandle openHandle(Connection connection) throws SQLException {
        BasicHandle h = new BasicHandle(this.getTransactionHandler(), this.getStatementLocator(), (StatementBuilder)new CachingStatementBuilder((StatementBuilder)new DefaultStatementBuilder()), (StatementRewriter)new ColonPrefixNamedParamStatementRewriter(), connection, new HashMap(), (SQLLog)new NoOpLog(), TimingCollector.NOP_TIMING_COLLECTOR, new MappingRegistry(), new Foreman(), new ContainerFactoryRegistry());
        HANDLES.add(h);
        return h;
    }

    protected TransactionHandler getTransactionHandler() {
        return new LocalTransactionHandler();
    }

    protected <T> Future<T> run(Callable<T> it) {
        if (this.executor == null) {
            this.executor = Executors.newCachedThreadPool();
        }
        return this.executor.submit(it);
    }
}

