/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.proxy;

import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.test.EchoHandler;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.proxy.ConnectHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class HttpsProxyTest
extends AbstractBasicTest {
    private Server server2;

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new ConnectHandler();
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        ServerConnector connector = TestUtils.addHttpConnector(this.server);
        this.server.setHandler((Handler)this.configureHandler());
        this.server.start();
        this.port1 = connector.getLocalPort();
        this.server2 = new Server();
        ServerConnector connector2 = TestUtils.addHttpsConnector(this.server2);
        this.server2.setHandler((Handler)new EchoHandler());
        this.server2.start();
        this.port2 = connector2.getLocalPort();
        this.logger.info("Local HTTP server started successfully");
    }

    @Override
    @AfterClass(alwaysRun=true)
    public void tearDownGlobal() throws Exception {
        this.server.stop();
        this.server2.stop();
    }

    @Test(groups={"standalone"})
    public void testRequestProxy() throws Exception {
        try (AsyncHttpClient asyncHttpClient = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true).setAcceptAnyCertificate(true));){
            RequestBuilder rb = (RequestBuilder)Dsl.get((String)this.getTargetUrl2()).setProxyServer(Dsl.proxyServer((String)"localhost", (int)this.port1));
            Response r = (Response)asyncHttpClient.executeRequest(rb.build()).get();
            Assert.assertEquals((int)r.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone"})
    public void testConfigProxy() throws Exception {
        DefaultAsyncHttpClientConfig config = Dsl.config().setFollowRedirect(true).setProxyServer(Dsl.proxyServer((String)"localhost", (int)this.port1).build()).setAcceptAnyCertificate(true).build();
        try (AsyncHttpClient asyncHttpClient = Dsl.asyncHttpClient((AsyncHttpClientConfig)config);){
            Response r = (Response)asyncHttpClient.executeRequest(Dsl.get((String)this.getTargetUrl2())).get();
            Assert.assertEquals((int)r.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone"})
    public void testPooledConnectionsWithProxy() throws Exception {
        try (AsyncHttpClient asyncHttpClient = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setFollowRedirect(true).setAcceptAnyCertificate(true).setKeepAlive(true));){
            RequestBuilder rb = (RequestBuilder)Dsl.get((String)this.getTargetUrl2()).setProxyServer(Dsl.proxyServer((String)"localhost", (int)this.port1));
            Response r1 = (Response)asyncHttpClient.executeRequest(rb.build()).get();
            Assert.assertEquals((int)r1.getStatusCode(), (int)200);
            Response r2 = (Response)asyncHttpClient.executeRequest(rb.build()).get();
            Assert.assertEquals((int)r2.getStatusCode(), (int)200);
        }
    }
}

