/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.test.TestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class IdleStateHandlerTest
extends AbstractBasicTest {
    @Override
    @BeforeClass(alwaysRun=true)
    public void setUpGlobal() throws Exception {
        this.server = new Server();
        ServerConnector connector = TestUtils.addHttpConnector(this.server);
        this.server.setHandler((Handler)new IdleStateHandler());
        this.server.start();
        this.port1 = connector.getLocalPort();
        this.logger.info("Local HTTP server started successfully");
    }

    @Test(groups={"standalone"})
    public void idleStateTest() throws Exception {
        try (AsyncHttpClient c = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)Dsl.config().setPooledConnectionIdleTimeout(10000));){
            c.prepareGet(this.getTargetUrl()).execute().get();
        }
        catch (ExecutionException e) {
            Assert.fail((String)"Should allow to finish processing request.", (Throwable)e);
        }
    }

    private class IdleStateHandler
    extends AbstractHandler {
        private IdleStateHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            httpResponse.setStatus(200);
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

