/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.advise.SqlAdvisor;
import org.apache.hive.druid.org.apache.calcite.sql.advise.SqlAdvisorValidator;
import org.apache.hive.druid.org.apache.calcite.sql.advise.SqlSimpleParser;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.hive.druid.org.apache.calcite.sql.test.DefaultSqlTestFactory;
import org.apache.hive.druid.org.apache.calcite.sql.test.DelegatingSqlTestFactory;
import org.apache.hive.druid.org.apache.calcite.sql.test.SqlTestFactory;
import org.apache.hive.druid.org.apache.calcite.sql.test.SqlTester;
import org.apache.hive.druid.org.apache.calcite.sql.test.SqlTesterImpl;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlConformance;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorWithHints;
import org.apache.hive.druid.org.apache.calcite.test.MockCatalogReader;
import org.apache.hive.druid.org.apache.calcite.test.SqlValidatorTestCase;
import org.junit.Assert;
import org.junit.Test;

public class SqlAdvisorTest
extends SqlValidatorTestCase {
    private static final List<String> STAR_KEYWORD = Arrays.asList("KEYWORD(*)");
    protected static final List<String> FROM_KEYWORDS = Arrays.asList("KEYWORD(()", "KEYWORD(LATERAL)", "KEYWORD(TABLE)", "KEYWORD(UNNEST)");
    protected static final List<String> SALES_TABLES = Arrays.asList("SCHEMA(CATALOG.SALES)", "SCHEMA(CATALOG.SALES.NEST)", "TABLE(CATALOG.SALES.EMP)", "TABLE(CATALOG.SALES.EMPDEFAULTS)", "TABLE(CATALOG.SALES.EMPNULLABLES)", "TABLE(CATALOG.SALES.EMP_B)", "TABLE(CATALOG.SALES.EMP_20)", "TABLE(CATALOG.SALES.EMPNULLABLES_20)", "TABLE(CATALOG.SALES.EMP_ADDRESS)", "TABLE(CATALOG.SALES.DEPT)", "TABLE(CATALOG.SALES.DEPT_NESTED)", "TABLE(CATALOG.SALES.BONUS)", "TABLE(CATALOG.SALES.ORDERS)", "TABLE(CATALOG.SALES.SALGRADE)", "TABLE(CATALOG.SALES.SHIPMENTS)", "TABLE(CATALOG.SALES.PRODUCTS)", "TABLE(CATALOG.SALES.SUPPLIERS)", "TABLE(CATALOG.SALES.EMP_R)", "TABLE(CATALOG.SALES.DEPT_R)");
    private static final List<String> SCHEMAS = Arrays.asList("CATALOG(CATALOG)", "SCHEMA(CATALOG.DYNAMIC)", "SCHEMA(CATALOG.SALES)", "SCHEMA(CATALOG.STRUCT)", "SCHEMA(CATALOG.CUSTOMER)", "SCHEMA(CATALOG.SALES.NEST)");
    private static final List<String> AB_TABLES = Arrays.asList("TABLE(A)", "TABLE(B)");
    private static final List<String> EMP_TABLE = Arrays.asList("TABLE(EMP)");
    protected static final List<String> FETCH_OFFSET = Arrays.asList("KEYWORD(FETCH)", "KEYWORD(LIMIT)", "KEYWORD(OFFSET)");
    protected static final List<String> EXPR_KEYWORDS = Arrays.asList("KEYWORD(()", "KEYWORD(+)", "KEYWORD(-)", "KEYWORD(?)", "KEYWORD(ABS)", "KEYWORD(ARRAY)", "KEYWORD(AVG)", "KEYWORD(CARDINALITY)", "KEYWORD(CASE)", "KEYWORD(CAST)", "KEYWORD(CEIL)", "KEYWORD(CEILING)", "KEYWORD(CHARACTER_LENGTH)", "KEYWORD(CHAR_LENGTH)", "KEYWORD(CLASSIFIER)", "KEYWORD(COALESCE)", "KEYWORD(COLLECT)", "KEYWORD(CONVERT)", "KEYWORD(COUNT)", "KEYWORD(COVAR_POP)", "KEYWORD(COVAR_SAMP)", "KEYWORD(CUME_DIST)", "KEYWORD(CURRENT)", "KEYWORD(CURRENT_CATALOG)", "KEYWORD(CURRENT_DATE)", "KEYWORD(CURRENT_DEFAULT_TRANSFORM_GROUP)", "KEYWORD(CURRENT_PATH)", "KEYWORD(CURRENT_ROLE)", "KEYWORD(CURRENT_SCHEMA)", "KEYWORD(CURRENT_TIME)", "KEYWORD(CURRENT_TIMESTAMP)", "KEYWORD(CURRENT_USER)", "KEYWORD(CURSOR)", "KEYWORD(DATE)", "KEYWORD(DENSE_RANK)", "KEYWORD(ELEMENT)", "KEYWORD(EXISTS)", "KEYWORD(EXP)", "KEYWORD(EXTRACT)", "KEYWORD(FALSE)", "KEYWORD(FIRST_VALUE)", "KEYWORD(FLOOR)", "KEYWORD(FUSION)", "KEYWORD(GROUPING)", "KEYWORD(HOUR)", "KEYWORD(INTERVAL)", "KEYWORD(LAG)", "KEYWORD(LAST_VALUE)", "KEYWORD(LEAD)", "KEYWORD(LN)", "KEYWORD(LOCALTIME)", "KEYWORD(LOCALTIMESTAMP)", "KEYWORD(LOWER)", "KEYWORD(MATCH_NUMBER)", "KEYWORD(MAX)", "KEYWORD(MIN)", "KEYWORD(MINUTE)", "KEYWORD(MOD)", "KEYWORD(MONTH)", "KEYWORD(MULTISET)", "KEYWORD(NEW)", "KEYWORD(NEXT)", "KEYWORD(NOT)", "KEYWORD(NTILE)", "KEYWORD(NULL)", "KEYWORD(NULLIF)", "KEYWORD(OCTET_LENGTH)", "KEYWORD(OVERLAY)", "KEYWORD(PERCENT_RANK)", "KEYWORD(PERIOD)", "KEYWORD(POSITION)", "KEYWORD(POWER)", "KEYWORD(PREV)", "KEYWORD(RANK)", "KEYWORD(REGR_SXX)", "KEYWORD(REGR_SYY)", "KEYWORD(ROW)", "KEYWORD(ROW_NUMBER)", "KEYWORD(RUNNING)", "KEYWORD(SECOND)", "KEYWORD(SESSION_USER)", "KEYWORD(SPECIFIC)", "KEYWORD(SQRT)", "KEYWORD(SUBSTRING)", "KEYWORD(STDDEV_POP)", "KEYWORD(STDDEV_SAMP)", "KEYWORD(SUM)", "KEYWORD(SYSTEM_USER)", "KEYWORD(TIME)", "KEYWORD(TIMESTAMP)", "KEYWORD(TRANSLATE)", "KEYWORD(TRIM)", "KEYWORD(TRUE)", "KEYWORD(TRUNCATE)", "KEYWORD(UNKNOWN)", "KEYWORD(UPPER)", "KEYWORD(USER)", "KEYWORD(VAR_POP)", "KEYWORD(VAR_SAMP)", "KEYWORD(YEAR)");
    protected static final List<String> QUANTIFIERS = Arrays.asList("KEYWORD(ALL)", "KEYWORD(ANY)", "KEYWORD(SOME)");
    protected static final List<String> SELECT_KEYWORDS = Arrays.asList("KEYWORD(ALL)", "KEYWORD(DISTINCT)", "KEYWORD(STREAM)", "KEYWORD(*)");
    private static final List<String> ORDER_KEYWORDS = Arrays.asList("KEYWORD(,)", "KEYWORD(ASC)", "KEYWORD(DESC)", "KEYWORD(NULLS)");
    private static final List<String> EMP_COLUMNS = Arrays.asList("COLUMN(EMPNO)", "COLUMN(ENAME)", "COLUMN(JOB)", "COLUMN(MGR)", "COLUMN(HIREDATE)", "COLUMN(SAL)", "COLUMN(COMM)", "COLUMN(DEPTNO)", "COLUMN(SLACKER)");
    private static final List<String> DEPT_COLUMNS = Arrays.asList("COLUMN(DEPTNO)", "COLUMN(NAME)");
    protected static final List<String> PREDICATE_KEYWORDS = Arrays.asList("KEYWORD(()", "KEYWORD(*)", "KEYWORD(+)", "KEYWORD(-)", "KEYWORD(.)", "KEYWORD(/)", "KEYWORD(%)", "KEYWORD(<)", "KEYWORD(<=)", "KEYWORD(<>)", "KEYWORD(!=)", "KEYWORD(=)", "KEYWORD(>)", "KEYWORD(>=)", "KEYWORD(AND)", "KEYWORD(BETWEEN)", "KEYWORD(CONTAINS)", "KEYWORD(EQUALS)", "KEYWORD(IMMEDIATELY)", "KEYWORD(IN)", "KEYWORD(IS)", "KEYWORD(LIKE)", "KEYWORD(MEMBER)", "KEYWORD(MULTISET)", "KEYWORD(NOT)", "KEYWORD(OR)", "KEYWORD(OVERLAPS)", "KEYWORD(PRECEDES)", "KEYWORD(SIMILAR)", "KEYWORD(SUBMULTISET)", "KEYWORD(SUCCEEDS)", "KEYWORD([)", "KEYWORD(||)");
    private static final List<String> WHERE_KEYWORDS = Arrays.asList("KEYWORD(EXCEPT)", "KEYWORD(MINUS)", "KEYWORD(FETCH)", "KEYWORD(OFFSET)", "KEYWORD(LIMIT)", "KEYWORD(GROUP)", "KEYWORD(HAVING)", "KEYWORD(INTERSECT)", "KEYWORD(ORDER)", "KEYWORD(UNION)", "KEYWORD(WINDOW)");
    private static final List<String> A_TABLE = Arrays.asList("TABLE(A)");
    protected static final List<String> JOIN_KEYWORDS = Arrays.asList("KEYWORD(FETCH)", "KEYWORD(OFFSET)", "KEYWORD(LIMIT)", "KEYWORD(UNION)", "KEYWORD(FULL)", "KEYWORD(ORDER)", "KEYWORD(()", "KEYWORD(EXTEND)", "KEYWORD(AS)", "KEYWORD(USING)", "KEYWORD(OUTER)", "KEYWORD(RIGHT)", "KEYWORD(GROUP)", "KEYWORD(CROSS)", "KEYWORD(,)", "KEYWORD(NATURAL)", "KEYWORD(INNER)", "KEYWORD(HAVING)", "KEYWORD(LEFT)", "KEYWORD(EXCEPT)", "KEYWORD(MATCH_RECOGNIZE)", "KEYWORD(MINUS)", "KEYWORD(JOIN)", "KEYWORD(WINDOW)", "KEYWORD(.)", "KEYWORD(TABLESAMPLE)", "KEYWORD(ON)", "KEYWORD(INTERSECT)", "KEYWORD(WHERE)");
    private static final List<String> SETOPS = Arrays.asList("KEYWORD(EXCEPT)", "KEYWORD(MINUS)", "KEYWORD(INTERSECT)", "KEYWORD(ORDER)", "KEYWORD(UNION)");
    private static final String EMPNO_EMP = "COLUMN(EMPNO)\nTABLE(EMP)\n";

    protected List<String> getFromKeywords() {
        return FROM_KEYWORDS;
    }

    protected List<String> getSelectKeywords() {
        return SELECT_KEYWORDS;
    }

    protected List<String> getSalesTables() {
        return SALES_TABLES;
    }

    protected List<String> getJoinKeywords() {
        return JOIN_KEYWORDS;
    }

    private void assertTokenizesTo(String sql, String expected) {
        SqlSimpleParser.Token token;
        SqlSimpleParser.Tokenizer tokenizer = new SqlSimpleParser.Tokenizer(sql, "xxxxx");
        StringBuilder buf = new StringBuilder();
        while ((token = tokenizer.nextToken()) != null) {
            buf.append(token).append("\n");
        }
        Assert.assertEquals((Object)expected, (Object)buf.toString());
    }

    protected void assertHint(String sql, List<String> ... expectedLists) throws Exception {
        List<String> expectedList = SqlAdvisorTest.plus(expectedLists);
        String expected = SqlAdvisorTest.toString(new TreeSet<String>(expectedList));
        this.assertHint(sql, expected);
    }

    protected void assertHint(String sql, String expectedResults) throws Exception {
        SqlValidatorWithHints validator = (SqlValidatorWithHints)this.tester.getValidator();
        SqlAdvisor advisor = this.tester.getFactory().createAdvisor(validator);
        SqlParserUtil.StringAndPos sap = SqlParserUtil.findPos((String)sql);
        List results = advisor.getCompletionHints(sap.sql, sap.pos);
        Assert.assertEquals((Object)expectedResults, (Object)this.convertCompletionHints(results));
    }

    protected void assertSimplify(String sql, String expected) {
        SqlValidatorWithHints validator = (SqlValidatorWithHints)this.tester.getValidator();
        SqlAdvisor advisor = this.tester.getFactory().createAdvisor(validator);
        SqlParserUtil.StringAndPos sap = SqlParserUtil.findPos((String)sql);
        String actual = advisor.simplifySql(sap.sql, sap.cursor);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    protected void assertComplete(String sql, List<String> ... expectedResults) {
        List<String> expectedList = SqlAdvisorTest.plus(expectedResults);
        String expected = SqlAdvisorTest.toString(new TreeSet<String>(expectedList));
        this.assertComplete(sql, expected, null);
    }

    protected void assertComplete(String sql, String expectedResults, String expectedWord) {
        SqlValidatorWithHints validator = (SqlValidatorWithHints)this.tester.getValidator();
        SqlAdvisor advisor = this.tester.getFactory().createAdvisor(validator);
        SqlParserUtil.StringAndPos sap = SqlParserUtil.findPos((String)sql);
        String[] replaced = new String[]{null};
        List results = advisor.getCompletionHints(sap.sql, sap.cursor, replaced);
        Assert.assertNotNull((Object)replaced[0]);
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((Object)expectedResults, (Object)this.convertCompletionHints(results));
        if (expectedWord != null) {
            Assert.assertEquals((Object)expectedWord, (Object)replaced[0]);
        }
    }

    protected void assertEquals(String[] actualResults, List<String> ... expectedResults) throws Exception {
        List<String> expectedList = SqlAdvisorTest.plus(expectedResults);
        HashMap<String, String> uniqueResults = new HashMap<String, String>();
        for (String actualResult : actualResults) {
            uniqueResults.put(actualResult, actualResult);
        }
        if (!expectedList.containsAll(uniqueResults.values()) || expectedList.size() != uniqueResults.values().size()) {
            Assert.fail((String)("SqlAdvisorTest: completion hints results not as salesTables:\n" + uniqueResults.values() + "\nExpected:\n" + expectedList));
        }
    }

    private String convertCompletionHints(List<SqlMoniker> hints) {
        ArrayList<String> list = new ArrayList<String>();
        for (SqlMoniker hint : hints) {
            if (hint.getType() == SqlMonikerType.FUNCTION) continue;
            list.add(hint.id());
        }
        Collections.sort(list);
        return SqlAdvisorTest.toString(list);
    }

    private static <T> String toString(Collection<T> list) {
        StringBuilder buf = new StringBuilder();
        for (T t : list) {
            buf.append(t).append("\n");
        }
        return buf.toString();
    }

    @Override
    public SqlTester getTester() {
        return new SqlTesterImpl(new AdvisorTesterFactory());
    }

    protected static <T> List<T> plus(List<T> ... lists) {
        ArrayList<T> result = new ArrayList<T>();
        for (List<T> list : lists) {
            result.addAll(list);
        }
        return result;
    }

    @Test
    public void testFrom() throws Exception {
        String sql = "select a.empno, b.deptno from ^dummy a, sales.dummy b";
        this.assertHint(sql, SCHEMAS, this.getSalesTables(), this.getFromKeywords());
        sql = "select a.empno, b.deptno from ^";
        this.assertComplete(sql, SCHEMAS, this.getSalesTables(), this.getFromKeywords());
        sql = "select a.empno, b.deptno from ^, sales.dummy b";
        this.assertComplete(sql, SCHEMAS, this.getSalesTables(), this.getFromKeywords());
        sql = "select a.empno, b.deptno from ^a";
        this.assertComplete(sql, SCHEMAS, this.getSalesTables(), this.getFromKeywords());
        sql = "select a.empno, b.deptno from dummy a, ^sales.dummy b";
        this.assertHint(sql, SCHEMAS, this.getSalesTables(), this.getFromKeywords());
    }

    @Test
    public void testFromComplete() {
        String sql = "select a.empno, b.deptno from dummy a, sales.^";
        this.assertComplete(sql, this.getSalesTables());
    }

    @Test
    public void testGroup() {
        String sql = "select a.empno, b.deptno from emp group ^";
        this.assertComplete(sql, Arrays.asList("KEYWORD(BY)"));
    }

    @Test
    public void testJoin() throws Exception {
        String sql = "select a.empno, b.deptno from ^dummy a join sales.dummy b on a.deptno=b.deptno where empno=1";
        this.assertHint(sql, this.getFromKeywords(), SCHEMAS, this.getSalesTables());
        sql = "select a.empno, b.deptno from ^ a join sales.dummy b";
        this.assertComplete(sql, this.getFromKeywords(), SCHEMAS, this.getSalesTables());
        sql = "select a.empno, b.deptno from dummy a join ^sales.dummy b on a.deptno=b.deptno where empno=1";
        this.assertHint(sql, this.getFromKeywords(), SCHEMAS, this.getSalesTables());
        sql = "select a.empno, b.deptno from dummy a join sales.^";
        this.assertComplete(sql, this.getSalesTables());
        sql = "select a.empno, b.deptno from dummy a join sales.^ on";
        this.assertComplete(sql, this.getSalesTables());
        sql = "select a.empno, b.deptno from dummy a join sales.^ on a.deptno=";
        this.assertComplete(sql, QUANTIFIERS, EXPR_KEYWORDS);
    }

    @Test
    public void testJoinKeywords() {
        List<String> list = this.getJoinKeywords();
        String sql = "select * from dummy join sales.emp ^";
        this.assertSimplify(sql, "SELECT * FROM dummy JOIN sales.emp _suggest_");
        this.assertComplete(sql, list);
    }

    @Test
    public void testOnCondition() throws Exception {
        String sql = "select a.empno, b.deptno from sales.emp a join sales.dept b on ^a.deptno=b.dummy where empno=1";
        this.assertHint(sql, AB_TABLES, EXPR_KEYWORDS);
        sql = "select a.empno, b.deptno from sales.emp a join sales.dept b on a.^";
        this.assertComplete(sql, EMP_COLUMNS);
        sql = "select a.empno, b.deptno from sales.emp a join sales.dept b on a.deptno=^b.dummy where empno=1";
        this.assertHint(sql, EXPR_KEYWORDS, QUANTIFIERS, AB_TABLES);
        sql = "select a.empno, b.deptno from sales.emp a join sales.dept b on a.deptno=b.^ where empno=1";
        this.assertComplete(sql, DEPT_COLUMNS);
        sql = "select a.empno, b.deptno from sales.emp a join sales.dept b on a.deptno=b.^";
        this.assertComplete(sql, DEPT_COLUMNS);
    }

    @Test
    public void testFromWhere() throws Exception {
        String sql = "select a.empno, b.deptno from sales.emp a, sales.dept b where b.deptno=^a.dummy";
        this.assertHint(sql, AB_TABLES, EXPR_KEYWORDS, QUANTIFIERS);
        sql = "select a.empno, b.deptno from sales.emp a, sales.dept b where b.deptno=a.^";
        this.assertComplete(sql, EMP_COLUMNS);
        sql = "select a.empno, b.deptno from sales.emp a, sales.dept b where ^dummy=1";
        this.assertHint(sql, AB_TABLES, EXPR_KEYWORDS);
        sql = "select a.empno, b.deptno from sales.emp a, sales.dept b where ^";
        this.assertComplete(sql, AB_TABLES, EXPR_KEYWORDS);
        this.assertComplete("select a.empno, a.deptno from sales.emp a where ^", A_TABLE, EMP_COLUMNS, EXPR_KEYWORDS);
    }

    @Test
    public void testWhereList() throws Exception {
        String sql = "select a.empno, b.deptno from sales.emp a join sales.dept b on a.deptno=b.deptno where ^dummy=1";
        this.assertHint(sql, EXPR_KEYWORDS, AB_TABLES);
        sql = "select a.empno, b.deptno from sales.emp a join sales.dept b on a.deptno=b.deptno where ^";
        this.assertComplete(sql, EXPR_KEYWORDS, AB_TABLES);
        sql = "select a.empno, b.deptno from sales.emp a join sales.dept b on a.deptno=b.deptno where ^a.dummy=1";
        this.assertHint(sql, EXPR_KEYWORDS, AB_TABLES);
        sql = "select a.empno, b.deptno from sales.emp a join sales.dept b on a.deptno=b.deptno where a.^";
        this.assertComplete(sql, EMP_COLUMNS);
        sql = "select a.empno, b.deptno from sales.emp a join sales.dept b on a.deptno=b.deptno where a.empno ^ ";
        this.assertComplete(sql, PREDICATE_KEYWORDS, WHERE_KEYWORDS);
    }

    @Test
    public void testSelectList() throws Exception {
        String sql = "select ^dummy, b.dummy from sales.emp a join sales.dept b on a.deptno=b.deptno where empno=1";
        this.assertHint(sql, this.getSelectKeywords(), EXPR_KEYWORDS, AB_TABLES, SETOPS, FETCH_OFFSET);
        sql = "select ^ from (values (1))";
        this.assertComplete(sql, this.getSelectKeywords(), EXPR_KEYWORDS, SETOPS, FETCH_OFFSET, Arrays.asList("TABLE(EXPR$0)", "COLUMN(EXPR$0)"));
        sql = "select ^ from (values (1)) as t(c)";
        this.assertComplete(sql, this.getSelectKeywords(), EXPR_KEYWORDS, SETOPS, FETCH_OFFSET, Arrays.asList("TABLE(T)", "COLUMN(C)"));
        sql = "select ^, b.dummy from sales.emp a join sales.dept b ";
        this.assertComplete(sql, this.getSelectKeywords(), EXPR_KEYWORDS, SETOPS, AB_TABLES, FETCH_OFFSET);
        sql = "select dummy, ^b.dummy from sales.emp a join sales.dept b on a.deptno=b.deptno where empno=1";
        this.assertHint(sql, EXPR_KEYWORDS, STAR_KEYWORD, AB_TABLES);
        sql = "select dummy, b.^ from sales.emp a join sales.dept b on true";
        this.assertComplete(sql, STAR_KEYWORD, DEPT_COLUMNS);
        sql = "select dummy, b.^ from sales.emp a";
        this.assertComplete(sql, STAR_KEYWORD);
        sql = "select ^emp.dummy from sales.emp";
        this.assertHint(sql, this.getSelectKeywords(), EXPR_KEYWORDS, EMP_COLUMNS, SETOPS, FETCH_OFFSET, Arrays.asList("TABLE(EMP)"));
        sql = "select emp.^ from sales.emp";
        this.assertComplete(sql, EMP_COLUMNS, STAR_KEYWORD);
    }

    @Test
    public void testOrderByList() throws Exception {
        String sql = "select emp.empno from sales.emp where empno=1 order by ^dummy";
        this.assertHint(sql, EXPR_KEYWORDS, EMP_COLUMNS, EMP_TABLE);
        sql = "select emp.empno from sales.emp where empno=1 order by ^";
        this.assertComplete(sql, EXPR_KEYWORDS, EMP_COLUMNS, EMP_TABLE);
        sql = "select emp.empno\nfrom sales.emp as e(\n  mpno,name,ob,gr,iredate,al,omm,eptno,lacker)\nwhere e.mpno=1 order by ^";
        this.assertComplete(sql, EXPR_KEYWORDS, Arrays.asList("COLUMN(MPNO)", "COLUMN(NAME)", "COLUMN(OB)", "COLUMN(GR)", "COLUMN(IREDATE)", "COLUMN(AL)", "COLUMN(OMM)", "COLUMN(EPTNO)", "COLUMN(LACKER)"), Arrays.asList("TABLE(E)"));
        sql = "select emp.empno from sales.emp where empno=1 order by empno ^, deptno";
        this.assertComplete(sql, PREDICATE_KEYWORDS, ORDER_KEYWORDS, FETCH_OFFSET);
    }

    @Test
    public void testSubQuery() throws Exception {
        List<String> xyColumns = Arrays.asList("COLUMN(X)", "COLUMN(Y)");
        List<String> tTable = Arrays.asList("TABLE(T)");
        String sql = "select ^t.dummy from (select 1 as x, 2 as y from sales.emp) as t where t.dummy=1";
        this.assertHint(sql, EXPR_KEYWORDS, this.getSelectKeywords(), xyColumns, tTable, SETOPS, FETCH_OFFSET);
        sql = "select t.^ from (select 1 as x, 2 as y from sales.emp) as t";
        this.assertComplete(sql, xyColumns, STAR_KEYWORD);
        sql = "select t.x from (select 1 as x, 2 as y from sales.emp) as t where ^t.dummy=1";
        this.assertHint(sql, EXPR_KEYWORDS, tTable, xyColumns);
        sql = "select t.x from (select 1 as x, 2 as y from sales.emp) as t where t.^";
        this.assertComplete(sql, xyColumns);
        sql = "select t.x from (select 1 as x, 2 as y from sales.emp) as t where ^";
        this.assertComplete(sql, EXPR_KEYWORDS, tTable, xyColumns);
        sql = "select a.x from (select 1 as x, 2 as y from sales.emp) as a, dept as b where ^";
        this.assertComplete(sql, EXPR_KEYWORDS, AB_TABLES);
        sql = "select t. from (select 1 as x, 2 as y from (select x from sales.emp)) as t where ^";
        String simplified = "SELECT * FROM ( SELECT 0 AS x , 0 AS y FROM ( SELECT 0 AS x FROM sales.emp ) ) as t WHERE _suggest_";
        this.assertSimplify(sql, simplified);
        this.assertComplete(sql, EXPR_KEYWORDS, tTable, xyColumns);
        sql = "select t.x from (select 1 as x, 2 as y from sales.^) as t";
        this.assertComplete(sql, this.getSalesTables());
    }

    @Test
    public void testSubQueryInWhere() {
        String sql = "select * from sales.emp a where deptno in (select * from sales.dept b where ^)";
        String simplifiedSql = "SELECT * FROM sales.emp a WHERE deptno in ( SELECT * FROM sales.dept b WHERE _suggest_ )";
        this.assertSimplify(sql, simplifiedSql);
        this.assertComplete(sql, AB_TABLES, DEPT_COLUMNS, EXPR_KEYWORDS);
    }

    @Test
    public void testSimpleParserTokenizer() {
        String sql = "select 12 * 1.23e45 (\"an id\", \"an id with \"\"quotes' inside\", /* a comment, with 'quotes', over\nmultiple lines\nand select keyword */\n ( a different // comment\n\r//and a comment /* containing comment */ and then some more\r) from t))/* a comment after close paren */ ('quoted' 'string with ''single and \"double\"\" quote')";
        String expected = "SELECT\nID(12)\nID(*)\nID(1.23e45)\nLPAREN\nDQID(\"an id\")\nCOMMA\nDQID(\"an id with \"\"quotes' inside\")\nCOMMA\nCOMMENT\nLPAREN\nID(a)\nID(different)\nCOMMENT\nCOMMENT\nRPAREN\nFROM\nID(t)\nRPAREN\nRPAREN\nCOMMENT\nLPAREN\nSQID('quoted')\nSQID('string with ''single and \"double\"\" quote')\nRPAREN\n";
        this.assertTokenizesTo(sql, expected);
        this.assertTokenizesTo("select /* unfinished comment", "SELECT\nCOMMENT\n");
        this.assertTokenizesTo("select // unfinished comment", "SELECT\nCOMMENT\n");
        this.assertTokenizesTo("'starts with string'", "SQID('starts with string')\n");
        this.assertTokenizesTo("'unfinished string", "SQID('unfinished string)\n");
        this.assertTokenizesTo("\"unfinished double-quoted id", "DQID(\"unfinished double-quoted id)\n");
        this.assertTokenizesTo("123", "ID(123)\n");
    }

    @Test
    public void testSimpleParser() {
        String sql = "select * from ^where";
        String expected = "SELECT * FROM _suggest_";
        this.assertSimplify(sql, expected);
        sql = "select a.empno, b.deptno from ^";
        expected = "SELECT * FROM _suggest_";
        this.assertSimplify(sql, expected);
        sql = "select ^ from (values (1))";
        expected = "SELECT _suggest_ FROM ( values ( 1 ) )";
        this.assertSimplify(sql, expected);
        sql = "select emp.^ from sales.emp";
        expected = "SELECT emp. _suggest_ FROM sales.emp";
        this.assertSimplify(sql, expected);
        sql = "select ^from sales.emp";
        expected = "SELECT _suggest_ FROM sales.emp";
        this.assertSimplify(sql, expected);
        sql = "select a.empno ,^  from sales.emp a , sales.dept b";
        expected = "SELECT _suggest_ FROM sales.emp a , sales.dept b";
        this.assertSimplify(sql, expected);
        sql = "select ^, a.empno from sales.emp a , sales.dept b";
        expected = "SELECT _suggest_ FROM sales.emp a , sales.dept b";
        this.assertSimplify(sql, expected);
        sql = "select dummy, b.^ from sales.emp a , sales.dept b";
        expected = "SELECT b. _suggest_ FROM sales.emp a , sales.dept b";
        this.assertSimplify(sql, expected);
        sql = "select a.empno, b.deptno from dummy a join ^on where empno=1";
        expected = "SELECT * FROM dummy a JOIN _suggest_ ON TRUE";
        this.assertSimplify(sql, expected);
        sql = "select a.empno, b.deptno from dummy a join sales.^ where empno=1";
        expected = "SELECT * FROM dummy a JOIN sales. _suggest_";
        this.assertSimplify(sql, expected);
        sql = "select a.empno, b.deptno from sales.emp a join sales.dept b on a.deptno=^";
        expected = "SELECT * FROM sales.emp a JOIN sales.dept b ON a.deptno= _suggest_";
        this.assertSimplify(sql, expected);
        sql = "select a.empno, b.deptno from sales.emp a, sales.dept b where ^";
        expected = "SELECT * FROM sales.emp a , sales.dept b WHERE _suggest_";
        this.assertSimplify(sql, expected);
        sql = "select emp.empno from sales.emp where empno=1 order by ^";
        expected = "SELECT emp.empno FROM sales.emp ORDER BY _suggest_";
        this.assertSimplify(sql, expected);
        sql = "select t.^ from (select 1 as x, 2 as y from sales.emp) as t where t.dummy=1";
        expected = "SELECT t. _suggest_ FROM ( SELECT 0 AS x , 0 AS y FROM sales.emp ) as t";
        this.assertSimplify(sql, expected);
        sql = "select t. from (select 1 as x, 2 as y from (select x from sales.emp)) as t where ^";
        expected = "SELECT * FROM ( SELECT 0 AS x , 0 AS y FROM ( SELECT 0 AS x FROM sales.emp ) ) as t WHERE _suggest_";
        this.assertSimplify(sql, expected);
        sql = "select ^from (select 1 as x, 2 as y from sales.emp), (select 2 as y from (select m from n where)) as t where t.dummy=1";
        expected = "SELECT _suggest_ FROM ( SELECT 0 AS x , 0 AS y FROM sales.emp ) , ( SELECT 0 AS y FROM ( SELECT 0 AS m FROM n ) ) as t";
        this.assertSimplify(sql, expected);
        sql = "select t.x from ( select 1 as x, 2 as y from sales.^";
        expected = "SELECT * FROM ( SELECT * FROM sales. _suggest_ )";
        this.assertSimplify(sql, expected);
        sql = "select t.^ from (select 1 as x, 2 as y from sales)";
        expected = "SELECT t. _suggest_ FROM ( SELECT 0 AS x , 0 AS y FROM sales )";
        this.assertSimplify(sql, expected);
        sql = "select x + y + 32 from (select 1 as x, 2 as y from sales group by invalid stuff) as t where x in (select deptno from emp where foo + t.^ < 10)";
        expected = "SELECT * FROM ( SELECT 0 AS x , 0 AS y FROM sales ) as t WHERE x in ( SELECT * FROM emp WHERE foo + t. _suggest_ < 10 )";
        this.assertSimplify(sql, expected);
        sql = "select a.empno, b.deptno from dummy a, sales.^";
        expected = "SELECT * FROM sales. _suggest_";
        this.assertSimplify(sql, expected);
        sql = "select count(1) from sales.emp a where ^";
        expected = "SELECT * FROM sales.emp a WHERE _suggest_";
        this.assertSimplify(sql, expected);
        sql = "select count(1) from sales.emp a where substring(a.^ FROM 3 for 6) = '1234'";
        expected = "SELECT * FROM sales.emp a WHERE substring ( a. _suggest_ FROM 3 for 6 ) = '1234'";
        this.assertSimplify(sql, expected);
        sql = "select * from sales.emp a where deptno in (select * from sales.dept b where ^";
        expected = "SELECT * FROM sales.emp a WHERE deptno in ( SELECT * FROM sales.dept b WHERE _suggest_ )";
        this.assertSimplify(sql, expected);
        sql = "select 'a cat from a king' as foobar, 1 / 2 \"where\" from t group by t.^ order by 123";
        expected = "SELECT * FROM t GROUP BY t. _suggest_";
        this.assertSimplify(sql, expected);
        sql = "select /* here is from */ 'cat' as foobar, 1 as x from t group by t.^ order by 123";
        expected = "SELECT * FROM t GROUP BY t. _suggest_";
        this.assertSimplify(sql, expected);
        sql = "select // here is from clause\n 'cat' as foobar, 1 as x from t group by t.^ order by 123";
        expected = "SELECT * FROM t GROUP BY t. _suggest_";
        this.assertSimplify(sql, expected);
    }

    @Test
    public void testSimpleParserQuotedId() {
        String sql = "select * from t where \"^";
        String expected = "SELECT * FROM t WHERE _suggest_";
        this.assertSimplify(sql, expected);
        sql = "select * from t where \"^\" and x = y";
        expected = "SELECT * FROM t WHERE _suggest_ and x = y";
        this.assertSimplify(sql, expected);
        sql = "select * from t where \"^foo\" and x = y";
        expected = "SELECT * FROM t WHERE _suggest_ and x = y";
        this.assertSimplify(sql, expected);
    }

    @Test
    public void testPartialIdentifier() {
        String sql = "select * from emp where e^ and emp.deptno = 10";
        String expected = "COLUMN(EMPNO)\nCOLUMN(ENAME)\nKEYWORD(ELEMENT)\nKEYWORD(EXISTS)\nKEYWORD(EXP)\nKEYWORD(EXTRACT)\nTABLE(EMP)\n";
        this.assertComplete(sql, "COLUMN(EMPNO)\nCOLUMN(ENAME)\nKEYWORD(ELEMENT)\nKEYWORD(EXISTS)\nKEYWORD(EXP)\nKEYWORD(EXTRACT)\nTABLE(EMP)\n", "e");
        sql = "select * from emp where e^";
        this.assertComplete(sql, "COLUMN(EMPNO)\nCOLUMN(ENAME)\nKEYWORD(ELEMENT)\nKEYWORD(EXISTS)\nKEYWORD(EXP)\nKEYWORD(EXTRACT)\nTABLE(EMP)\n", null);
        sql = "select * from emp where em^";
        this.assertComplete(sql, EMPNO_EMP, null);
        sql = "select deptno,em^ from emp where 1+2<3+4";
        this.assertComplete(sql, EMPNO_EMP, null);
        sql = "select deptno,\"EM^ from emp where 1+2<3+4";
        this.assertComplete(sql, EMPNO_EMP, "\"EM");
        sql = "select deptno,\"em^ from emp where 1+2<3+4";
        this.assertComplete(sql, "", "\"em");
        sql = "select deptno,\"EM^ps\" from emp where 1+2<3+4";
        this.assertComplete(sql, EMPNO_EMP, "\"EM");
        sql = "select * from emp where 5 = \"EM^xxx\"";
        this.assertComplete(sql, EMPNO_EMP, "\"EM");
        sql = "select emp.^name from emp";
        this.assertComplete(sql, EMP_COLUMNS, STAR_KEYWORD);
    }

    @Test
    public void testInsert() throws Exception {
        String sql = "insert into emp(empno, mgr) select ^ from dept a";
        this.assertComplete(sql, this.getSelectKeywords(), EXPR_KEYWORDS, A_TABLE, DEPT_COLUMNS, SETOPS, FETCH_OFFSET);
        sql = "insert into emp(empno, mgr) values (123, 3 + ^)";
        this.assertComplete(sql, EXPR_KEYWORDS);
        sql = "insert into emp(empno, mgr) ^";
        this.assertComplete(sql, "", null);
    }

    @Test
    public void testUnion() throws Exception {
        String sql = "select 1 from emp union select 2 from dept a where ^ and deptno < 5";
        String simplified = "SELECT * FROM dept a WHERE _suggest_ and deptno < 5";
        this.assertSimplify(sql, simplified);
        this.assertComplete(sql, EXPR_KEYWORDS, A_TABLE, DEPT_COLUMNS);
        sql = "select 1 from emp union all select 2 from dept a where ^ and deptno < 5";
        this.assertSimplify(sql, simplified);
        sql = "select 1 from emp group by ^ except select 2 from dept a";
        simplified = "SELECT * FROM emp GROUP BY _suggest_";
        this.assertSimplify(sql, simplified);
    }

    private static class AdvisorTesterFactory
    extends DelegatingSqlTestFactory {
        AdvisorTesterFactory() {
            super(DefaultSqlTestFactory.INSTANCE);
        }

        @Override
        public SqlValidator getValidator(SqlTestFactory factory) {
            SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
            SqlConformance conformance = (SqlConformance)this.get("conformance");
            boolean caseSensitive = (Boolean)factory.get("caseSensitive");
            return new SqlAdvisorValidator((SqlOperatorTable)SqlStdOperatorTable.instance(), (SqlValidatorCatalogReader)new MockCatalogReader((RelDataTypeFactory)typeFactory, caseSensitive).init(), (RelDataTypeFactory)typeFactory, conformance);
        }

        @Override
        public SqlAdvisor createAdvisor(SqlValidatorWithHints validator) {
            return new SqlAdvisor(validator);
        }
    }
}

