/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.plan;

import org.apache.hive.druid.org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptCluster;
import org.apache.hive.druid.org.apache.calcite.plan.RelTraitSet;
import org.apache.hive.druid.org.apache.calcite.rel.AbstractRelNode;
import org.apache.hive.druid.org.apache.calcite.rel.externalize.RelJson;
import org.apache.hive.druid.org.apache.calcite.rel.logical.LogicalProject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RelOptPlanReaderTest {
    @Test
    public void testTypeToClass() {
        Class clazz;
        RelJson relJson = new RelJson(null);
        Assert.assertThat((Object)relJson.classToTypeName(LogicalProject.class), (Matcher)CoreMatchers.is((Object)"LogicalProject"));
        Assert.assertThat((Object)relJson.typeNameToClass("LogicalProject"), (Matcher)CoreMatchers.sameInstance(LogicalProject.class));
        Assert.assertThat((Object)relJson.classToTypeName(JdbcRules.JdbcProject.class), (Matcher)CoreMatchers.is((Object)"JdbcProject"));
        Assert.assertThat((Object)relJson.typeNameToClass("JdbcProject"), (Matcher)CoreMatchers.equalTo(JdbcRules.JdbcProject.class));
        try {
            clazz = relJson.typeNameToClass("NonExistentRel");
            Assert.fail((String)("expected exception, got " + clazz));
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"unknown type NonExistentRel"));
        }
        try {
            clazz = relJson.typeNameToClass("org.apache.hive.druid.org.apache.calcite.rel.NonExistentRel");
            Assert.fail((String)("expected exception, got " + clazz));
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"unknown type org.apache.calcite.rel.NonExistentRel"));
        }
        Assert.assertThat((Object)relJson.classToTypeName(MyRel.class), (Matcher)CoreMatchers.is((Object)"org.apache.hive.druid.org.apache.calcite.plan.RelOptPlanReaderTest$MyRel"));
        Assert.assertThat((Object)relJson.typeNameToClass(MyRel.class.getName()), (Matcher)CoreMatchers.equalTo(MyRel.class));
        try {
            clazz = relJson.typeNameToClass(MyRel.class.getCanonicalName());
            Assert.fail((String)("expected exception, got " + clazz));
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"unknown type org.apache.calcite.plan.RelOptPlanReaderTest.MyRel"));
        }
    }

    public static class MyRel
    extends AbstractRelNode {
        public MyRel(RelOptCluster cluster, RelTraitSet traitSet) {
            super(cluster, traitSet);
        }
    }
}

