/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.test.udt.bench.xfer;

import com.barchart.udt.SocketUDT;
import com.barchart.udt.StatusUDT;
import com.barchart.udt.TypeUDT;
import com.google.caliper.Param;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hive.druid.io.netty.test.udt.bench.BenchXfer;
import org.apache.hive.druid.io.netty.test.udt.util.CaliperRunner;
import org.apache.hive.druid.io.netty.test.udt.util.TrafficControl;
import org.apache.hive.druid.io.netty.test.udt.util.UnitHelp;

public class UdtNative
extends BenchXfer {
    @Param
    private volatile int latency;
    @Param
    private volatile int message;
    @Param
    private volatile int duration;
    private volatile SocketUDT peer1;
    private volatile SocketUDT peer2;

    protected static List<String> latencyValues() {
        return BenchXfer.latencyList();
    }

    protected static List<String> messageValues() {
        return BenchXfer.messageList();
    }

    protected static List<String> durationValues() {
        return BenchXfer.durationList();
    }

    @Override
    protected void setUp() throws Exception {
        this.log.info("init");
        TrafficControl.delay(this.latency);
        InetSocketAddress addr1 = UnitHelp.localSocketAddress();
        InetSocketAddress addr2 = UnitHelp.localSocketAddress();
        this.peer1 = new SocketUDT(TypeUDT.DATAGRAM);
        this.peer2 = new SocketUDT(TypeUDT.DATAGRAM);
        this.peer1.setBlocking(false);
        this.peer2.setBlocking(false);
        this.peer1.setRendezvous(true);
        this.peer2.setRendezvous(true);
        this.peer1.bind(addr1);
        this.peer2.bind(addr2);
        UnitHelp.socketAwait(this.peer1, StatusUDT.OPENED);
        UnitHelp.socketAwait(this.peer2, StatusUDT.OPENED);
        this.peer1.connect(addr2);
        this.peer2.connect(addr1);
        UnitHelp.socketAwait(this.peer1, StatusUDT.CONNECTED);
        UnitHelp.socketAwait(this.peer2, StatusUDT.CONNECTED);
        this.peer1.setBlocking(true);
        this.peer2.setBlocking(true);
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.peer1.setBlocking(false);
        this.peer2.setBlocking(false);
        this.peer1.close();
        this.peer2.close();
        UnitHelp.socketAwait(this.peer1, StatusUDT.CLOSED, StatusUDT.BROKEN);
        UnitHelp.socketAwait(this.peer2, StatusUDT.CLOSED, StatusUDT.BROKEN);
        TrafficControl.delay(0);
        this.log.info("done");
    }

    public void timeMain(int reps) throws Exception {
        int threadCount = 4;
        final CountDownLatch completion = new CountDownLatch(4);
        final AtomicBoolean isOn = new AtomicBoolean(true);
        Runnable sendPeer1 = new Runnable(){
            final ByteBuffer buffer;
            long sequence;
            {
                this.buffer = ByteBuffer.allocateDirect(UdtNative.this.message);
            }

            @Override
            public void run() {
                try {
                    while (isOn.get()) {
                        this.runCore();
                    }
                }
                catch (Exception e) {
                    UdtNative.this.log.error("", (Throwable)e);
                }
                finally {
                    completion.countDown();
                }
            }

            void runCore() throws Exception {
                this.buffer.rewind();
                this.buffer.putLong(0, this.sequence++);
                int count = UdtNative.this.peer1.send(this.buffer);
                if (count != UdtNative.this.message) {
                    throw new Exception("count");
                }
                UdtNative.this.measure().rate().mark((long)count);
            }
        };
        Runnable sendPeer2 = new Runnable(){
            final ByteBuffer buffer;
            long sequence;
            {
                this.buffer = ByteBuffer.allocateDirect(UdtNative.this.message);
            }

            @Override
            public void run() {
                try {
                    while (isOn.get()) {
                        this.runCore();
                    }
                }
                catch (Exception e) {
                    UdtNative.this.log.error("", (Throwable)e);
                }
                finally {
                    completion.countDown();
                }
            }

            void runCore() throws Exception {
                this.buffer.rewind();
                this.buffer.putLong(0, this.sequence++);
                int count = UdtNative.this.peer2.send(this.buffer);
                if (count != UdtNative.this.message) {
                    throw new Exception("count");
                }
            }
        };
        Runnable recvPeer1 = new Runnable(){
            final ByteBuffer buffer;
            long sequence;
            {
                this.buffer = ByteBuffer.allocateDirect(UdtNative.this.message);
            }

            @Override
            public void run() {
                try {
                    while (isOn.get()) {
                        this.runCore();
                    }
                }
                catch (Exception e) {
                    UdtNative.this.log.error("", (Throwable)e);
                }
                finally {
                    completion.countDown();
                }
            }

            void runCore() throws Exception {
                this.buffer.rewind();
                int count = UdtNative.this.peer1.receive(this.buffer);
                if (count != UdtNative.this.message) {
                    throw new Exception("count");
                }
                if (this.sequence++ != this.buffer.getLong(0)) {
                    throw new Exception("sequence");
                }
            }
        };
        Runnable recvPeer2 = new Runnable(){
            final ByteBuffer buffer;
            long sequence;
            {
                this.buffer = ByteBuffer.allocateDirect(UdtNative.this.message);
            }

            @Override
            public void run() {
                try {
                    while (isOn.get()) {
                        this.runCore();
                    }
                }
                catch (Exception e) {
                    UdtNative.this.log.error("", (Throwable)e);
                }
                finally {
                    completion.countDown();
                }
            }

            void runCore() throws Exception {
                this.buffer.rewind();
                int count = UdtNative.this.peer2.receive(this.buffer);
                if (count != UdtNative.this.message) {
                    throw new Exception("count");
                }
                if (this.sequence++ != this.buffer.getLong(0)) {
                    throw new Exception("sequence");
                }
            }
        };
        ExecutorService executor = Executors.newFixedThreadPool(4);
        executor.submit(recvPeer1);
        executor.submit(recvPeer2);
        executor.submit(sendPeer1);
        executor.submit(sendPeer2);
        this.markWait(this.duration);
        isOn.set(false);
        completion.await();
        executor.shutdownNow();
    }

    public static void main(String[] args) throws Exception {
        CaliperRunner.execute(UdtNative.class);
    }
}

