/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.memcache.binary;

import java.nio.charset.Charset;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheRequest;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultFullBinaryMemcacheRequestTest {
    private DefaultFullBinaryMemcacheRequest request;

    @BeforeEach
    public void setUp() {
        this.request = new DefaultFullBinaryMemcacheRequest(Unpooled.copiedBuffer((CharSequence)"key", (Charset)CharsetUtil.UTF_8), Unpooled.wrappedBuffer((byte[])new byte[]{1, 3, 4, 9}), Unpooled.copiedBuffer((CharSequence)"some value", (Charset)CharsetUtil.UTF_8));
        this.request.setReserved((short)534);
        this.request.setMagic((byte)3);
        this.request.setOpcode((byte)2);
        this.request.setKeyLength((short)32);
        this.request.setExtrasLength((byte)34);
        this.request.setDataType((byte)43);
        this.request.setTotalBodyLength(345);
        this.request.setOpaque(3);
        this.request.setCas(345345L);
    }

    @Test
    public void fullCopy() {
        FullBinaryMemcacheRequest newInstance = this.request.copy();
        try {
            this.assertCopy((FullBinaryMemcacheRequest)this.request, this.request.content(), newInstance);
        }
        finally {
            this.request.release();
            newInstance.release();
        }
    }

    @Test
    public void fullDuplicate() {
        FullBinaryMemcacheRequest newInstance = this.request.duplicate();
        try {
            this.assertCopy((FullBinaryMemcacheRequest)this.request, this.request.content(), newInstance);
        }
        finally {
            this.request.release();
        }
    }

    @Test
    public void fullReplace() {
        ByteBuf newContent = Unpooled.copiedBuffer((CharSequence)"new value", (Charset)CharsetUtil.UTF_8);
        FullBinaryMemcacheRequest newInstance = this.request.replace(newContent);
        try {
            this.assertCopy((FullBinaryMemcacheRequest)this.request, newContent, newInstance);
        }
        finally {
            this.request.release();
            newInstance.release();
        }
    }

    private void assertCopy(FullBinaryMemcacheRequest expected, ByteBuf expectedContent, FullBinaryMemcacheRequest actual) {
        Assertions.assertNotSame((Object)expected, (Object)actual);
        Assertions.assertEquals((Object)expected.key(), (Object)actual.key());
        Assertions.assertEquals((Object)expected.extras(), (Object)actual.extras());
        Assertions.assertEquals((Object)expectedContent, (Object)actual.content());
        Assertions.assertEquals((short)expected.reserved(), (short)actual.reserved());
        Assertions.assertEquals((byte)expected.magic(), (byte)actual.magic());
        Assertions.assertEquals((byte)expected.opcode(), (byte)actual.opcode());
        Assertions.assertEquals((short)expected.keyLength(), (short)actual.keyLength());
        Assertions.assertEquals((byte)expected.extrasLength(), (byte)actual.extrasLength());
        Assertions.assertEquals((byte)expected.dataType(), (byte)actual.dataType());
        Assertions.assertEquals((int)expected.totalBodyLength(), (int)actual.totalBodyLength());
        Assertions.assertEquals((int)expected.opaque(), (int)actual.opaque());
        Assertions.assertEquals((long)expected.cas(), (long)actual.cas());
    }
}

