/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.memcache.binary;

import java.nio.charset.Charset;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.EncoderException;
import org.apache.hive.druid.io.netty.handler.codec.memcache.DefaultLastMemcacheContent;
import org.apache.hive.druid.io.netty.handler.codec.memcache.DefaultMemcacheContent;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.BinaryMemcacheRequestEncoder;
import org.apache.hive.druid.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class BinaryMemcacheEncoderTest {
    public static final int DEFAULT_HEADER_SIZE = 24;
    private EmbeddedChannel channel;

    @BeforeEach
    public void setup() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new BinaryMemcacheRequestEncoder()});
    }

    @AfterEach
    public void teardown() {
        this.channel.finishAndReleaseAll();
    }

    @Test
    public void shouldEncodeDefaultHeader() {
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest();
        boolean result = this.channel.writeOutbound(new Object[]{request});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = (ByteBuf)this.channel.readOutbound();
        MatcherAssert.assertThat((Object)written.readableBytes(), (Matcher)CoreMatchers.is((Object)24));
        MatcherAssert.assertThat((Object)written.readByte(), (Matcher)CoreMatchers.is((Object)-128));
        MatcherAssert.assertThat((Object)written.readByte(), (Matcher)CoreMatchers.is((Object)0));
        written.release();
    }

    @Test
    public void shouldEncodeCustomHeader() {
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest();
        request.setMagic((byte)-86);
        request.setOpcode((byte)0);
        boolean result = this.channel.writeOutbound(new Object[]{request});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = (ByteBuf)this.channel.readOutbound();
        MatcherAssert.assertThat((Object)written.readableBytes(), (Matcher)CoreMatchers.is((Object)24));
        MatcherAssert.assertThat((Object)written.readByte(), (Matcher)CoreMatchers.is((Object)-86));
        MatcherAssert.assertThat((Object)written.readByte(), (Matcher)CoreMatchers.is((Object)0));
        written.release();
    }

    @Test
    public void shouldEncodeExtras() {
        String extrasContent = "netty<3memcache";
        ByteBuf extras = Unpooled.copiedBuffer((CharSequence)extrasContent, (Charset)CharsetUtil.UTF_8);
        int extrasLength = extras.readableBytes();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(Unpooled.EMPTY_BUFFER, extras);
        boolean result = this.channel.writeOutbound(new Object[]{request});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = (ByteBuf)this.channel.readOutbound();
        MatcherAssert.assertThat((Object)written.readableBytes(), (Matcher)CoreMatchers.is((Object)(24 + extrasLength)));
        written.skipBytes(24);
        MatcherAssert.assertThat((Object)written.readSlice(extrasLength).toString(CharsetUtil.UTF_8), (Matcher)IsEqual.equalTo((Object)extrasContent));
        written.release();
    }

    @Test
    public void shouldEncodeKey() {
        ByteBuf key = Unpooled.copiedBuffer((CharSequence)"netty", (Charset)CharsetUtil.UTF_8);
        int keyLength = key.readableBytes();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key);
        boolean result = this.channel.writeOutbound(new Object[]{request});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = (ByteBuf)this.channel.readOutbound();
        MatcherAssert.assertThat((Object)written.readableBytes(), (Matcher)CoreMatchers.is((Object)(24 + keyLength)));
        written.skipBytes(24);
        MatcherAssert.assertThat((Object)written.readSlice(keyLength).toString(CharsetUtil.UTF_8), (Matcher)IsEqual.equalTo((Object)"netty"));
        written.release();
    }

    @Test
    public void shouldEncodeContent() {
        DefaultMemcacheContent content1 = new DefaultMemcacheContent(Unpooled.copiedBuffer((CharSequence)"Netty", (Charset)CharsetUtil.UTF_8));
        DefaultLastMemcacheContent content2 = new DefaultLastMemcacheContent(Unpooled.copiedBuffer((CharSequence)" Rocks!", (Charset)CharsetUtil.UTF_8));
        int totalBodyLength = content1.content().readableBytes() + content2.content().readableBytes();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest();
        request.setTotalBodyLength(totalBodyLength);
        boolean result = this.channel.writeOutbound(new Object[]{request});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        result = this.channel.writeOutbound(new Object[]{content1});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        result = this.channel.writeOutbound(new Object[]{content2});
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)true));
        ByteBuf written = (ByteBuf)this.channel.readOutbound();
        MatcherAssert.assertThat((Object)written.readableBytes(), (Matcher)CoreMatchers.is((Object)24));
        written.release();
        written = (ByteBuf)this.channel.readOutbound();
        MatcherAssert.assertThat((Object)written.readableBytes(), (Matcher)CoreMatchers.is((Object)content1.content().readableBytes()));
        MatcherAssert.assertThat((Object)written.readSlice(content1.content().readableBytes()).toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)"Netty"));
        written.release();
        written = (ByteBuf)this.channel.readOutbound();
        MatcherAssert.assertThat((Object)written.readableBytes(), (Matcher)CoreMatchers.is((Object)content2.content().readableBytes()));
        MatcherAssert.assertThat((Object)written.readSlice(content2.content().readableBytes()).toString(CharsetUtil.UTF_8), (Matcher)CoreMatchers.is((Object)" Rocks!"));
        written.release();
    }

    @Test
    public void shouldFailWithoutLastContent() {
        this.channel.writeOutbound(new Object[]{new DefaultMemcacheContent(Unpooled.EMPTY_BUFFER)});
        Assertions.assertThrows(EncoderException.class, (Executable)new Executable(){

            public void execute() {
                BinaryMemcacheEncoderTest.this.channel.writeOutbound(new Object[]{new DefaultBinaryMemcacheRequest()});
            }
        });
    }
}

