/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.epoll;

import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.hive.druid.io.netty.channel.unix.NativeInetAddress;
import org.apache.hive.druid.io.netty.util.NetUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NativeTest {
    @Test
    public void testAddressIpv4() throws Exception {
        InetSocketAddress inetAddress = new InetSocketAddress(NetUtil.LOCALHOST4, 9999);
        byte[] bytes = new byte[8];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.put(inetAddress.getAddress().getAddress());
        buffer.putInt(inetAddress.getPort());
        Assertions.assertEquals((Object)inetAddress, (Object)NativeInetAddress.address((byte[])buffer.array(), (int)0, (int)bytes.length));
    }

    @Test
    public void testAddressIpv6() throws Exception {
        Inet6Address address = NetUtil.LOCALHOST6;
        InetSocketAddress inetAddress = new InetSocketAddress(address, 9999);
        byte[] bytes = new byte[24];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.put(address.getAddress());
        buffer.putInt(address.getScopeId());
        buffer.putInt(inetAddress.getPort());
        Assertions.assertEquals((Object)inetAddress, (Object)NativeInetAddress.address((byte[])buffer.array(), (int)0, (int)bytes.length));
    }
}

