/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.epoll;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import org.apache.hive.druid.io.netty.bootstrap.Bootstrap;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hive.druid.io.netty.channel.ChannelOption;
import org.apache.hive.druid.io.netty.channel.ConnectTimeoutException;
import org.apache.hive.druid.io.netty.channel.EventLoopGroup;
import org.apache.hive.druid.io.netty.channel.epoll.EpollChannelOption;
import org.apache.hive.druid.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.hive.druid.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.hive.druid.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.hive.druid.io.netty.util.CharsetUtil;
import org.apache.hive.druid.io.netty.util.NetUtil;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class EpollSocketTcpMd5Test {
    private static final byte[] SERVER_KEY = "abc".getBytes(CharsetUtil.US_ASCII);
    private static final byte[] BAD_KEY = "def".getBytes(CharsetUtil.US_ASCII);
    private static EventLoopGroup GROUP;
    private EpollServerSocketChannel server;

    @BeforeAll
    public static void beforeClass() {
        GROUP = new EpollEventLoopGroup(1);
    }

    @AfterAll
    public static void afterClass() {
        GROUP.shutdownGracefully();
    }

    @BeforeEach
    public void setup() {
        Bootstrap bootstrap = new Bootstrap();
        this.server = (EpollServerSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(GROUP)).channel(EpollServerSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST4, 0)).syncUninterruptibly().channel();
    }

    @AfterEach
    public void teardown() {
        this.server.close().syncUninterruptibly();
    }

    @Test
    public void testServerSocketChannelOption() throws Exception {
        this.server.config().setOption(EpollChannelOption.TCP_MD5SIG, Collections.singletonMap(NetUtil.LOCALHOST4, SERVER_KEY));
        this.server.config().setOption(EpollChannelOption.TCP_MD5SIG, Collections.emptyMap());
    }

    @Test
    public void testServerOption() throws Exception {
        Bootstrap bootstrap = new Bootstrap();
        EpollServerSocketChannel ch = (EpollServerSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(GROUP)).channel(EpollServerSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
        ch.config().setOption(EpollChannelOption.TCP_MD5SIG, Collections.singletonMap(NetUtil.LOCALHOST4, SERVER_KEY));
        ch.config().setOption(EpollChannelOption.TCP_MD5SIG, Collections.emptyMap());
        ch.close().syncUninterruptibly();
    }

    @Test
    public void testKeyMismatch() throws Exception {
        this.server.config().setOption(EpollChannelOption.TCP_MD5SIG, Collections.singletonMap(NetUtil.LOCALHOST4, SERVER_KEY));
        Assertions.assertThrows(ConnectTimeoutException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                EpollSocketChannel client = (EpollSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(GROUP)).channel(EpollSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).option(EpollChannelOption.TCP_MD5SIG, Collections.singletonMap(NetUtil.LOCALHOST4, BAD_KEY))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)1000)).connect((SocketAddress)EpollSocketTcpMd5Test.this.server.localAddress()).syncUninterruptibly().channel();
                client.close().syncUninterruptibly();
            }
        });
    }

    @Test
    public void testKeyMatch() throws Exception {
        this.server.config().setOption(EpollChannelOption.TCP_MD5SIG, Collections.singletonMap(NetUtil.LOCALHOST4, SERVER_KEY));
        EpollSocketChannel client = (EpollSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(GROUP)).channel(EpollSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).option(EpollChannelOption.TCP_MD5SIG, Collections.singletonMap(NetUtil.LOCALHOST4, SERVER_KEY))).connect((SocketAddress)this.server.localAddress()).syncUninterruptibly().channel();
        client.close().syncUninterruptibly();
    }
}

