/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.epoll;

import java.nio.ByteBuffer;
import org.apache.hive.druid.io.netty.channel.ChannelException;
import org.apache.hive.druid.io.netty.channel.ChannelOption;
import org.apache.hive.druid.io.netty.channel.epoll.Epoll;
import org.apache.hive.druid.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.hive.druid.io.netty.channel.unix.Buffer;
import org.apache.hive.druid.io.netty.channel.unix.IntegerUnixChannelOption;
import org.apache.hive.druid.io.netty.channel.unix.RawUnixChannelOption;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EpollChannelConfigTest {
    @Test
    public void testOptionGetThrowsChannelException() throws Exception {
        Epoll.ensureAvailability();
        EpollSocketChannel channel = new EpollSocketChannel();
        channel.config().getSoLinger();
        channel.fd().close();
        try {
            channel.config().getSoLinger();
            Assertions.fail();
        }
        catch (ChannelException channelException) {
            // empty catch block
        }
    }

    @Test
    public void testOptionSetThrowsChannelException() throws Exception {
        Epoll.ensureAvailability();
        EpollSocketChannel channel = new EpollSocketChannel();
        channel.config().setKeepAlive(true);
        channel.fd().close();
        try {
            channel.config().setKeepAlive(true);
            Assertions.fail();
        }
        catch (ChannelException channelException) {
            // empty catch block
        }
    }

    @Test
    public void testIntegerOption() throws Exception {
        Epoll.ensureAvailability();
        EpollSocketChannel channel = new EpollSocketChannel();
        IntegerUnixChannelOption opt = new IntegerUnixChannelOption("INT_OPT", 1, 2);
        Integer zero = 0;
        Assertions.assertEquals((Integer)zero, (Integer)((Integer)channel.config().getOption((ChannelOption)opt)));
        channel.config().setOption((ChannelOption)opt, (Object)1);
        Assertions.assertNotEquals((Integer)zero, (Integer)((Integer)channel.config().getOption((ChannelOption)opt)));
        channel.fd().close();
    }

    @Test
    public void testRawOption() throws Exception {
        Epoll.ensureAvailability();
        EpollSocketChannel channel = new EpollSocketChannel();
        RawUnixChannelOption opt = new RawUnixChannelOption("RAW_OPT", 1, 2, 4);
        ByteBuffer disabled = Buffer.allocateDirectWithNativeOrder((int)4);
        disabled.putInt(0).flip();
        Assertions.assertEquals((Object)disabled, (Object)channel.config().getOption((ChannelOption)opt));
        ByteBuffer enabled = Buffer.allocateDirectWithNativeOrder((int)4);
        enabled.putInt(1).flip();
        channel.config().setOption((ChannelOption)opt, (Object)enabled);
        Assertions.assertNotEquals((Object)disabled, (Object)channel.config().getOption((ChannelOption)opt));
        channel.fd().close();
    }
}

