/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.client.InventoryView;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.server.coordination.ServerType;
import org.apache.hive.druid.io.druid.server.http.IntervalsResource;
import org.apache.hive.druid.io.druid.server.security.AuthConfig;
import org.apache.hive.druid.io.druid.server.security.AuthTestUtils;
import org.apache.hive.druid.io.druid.server.security.AuthenticationResult;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IntervalsResourceTest {
    private InventoryView inventoryView;
    private DruidServer server;
    private List<DataSegment> dataSegmentList;
    private HttpServletRequest request;

    @Before
    public void setUp() {
        this.inventoryView = (InventoryView)EasyMock.createStrictMock(InventoryView.class);
        this.server = (DruidServer)EasyMock.createStrictMock(DruidServer.class);
        this.request = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        this.dataSegmentList = new ArrayList<DataSegment>();
        this.dataSegmentList.add(new DataSegment("datasource1", Intervals.of((String)"2010-01-01T00:00:00.000Z/P1D"), null, null, null, null, null, Integer.valueOf(9), 20L));
        this.dataSegmentList.add(new DataSegment("datasource1", Intervals.of((String)"2010-01-22T00:00:00.000Z/P1D"), null, null, null, null, null, Integer.valueOf(9), 10L));
        this.dataSegmentList.add(new DataSegment("datasource2", Intervals.of((String)"2010-01-01T00:00:00.000Z/P1D"), null, null, null, null, null, Integer.valueOf(9), 5L));
        this.server = new DruidServer("who", "host", null, 1234L, ServerType.HISTORICAL, "tier1", 0);
        this.server.addDataSegment(this.dataSegmentList.get(0));
        this.server.addDataSegment(this.dataSegmentList.get(1));
        this.server.addDataSegment(this.dataSegmentList.get(2));
    }

    @Test
    public void testGetIntervals() {
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null)).once();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.request});
        ArrayList<Interval> expectedIntervals = new ArrayList<Interval>();
        expectedIntervals.add(Intervals.of((String)"2010-01-01T00:00:00.000Z/2010-01-02T00:00:00.000Z"));
        expectedIntervals.add(Intervals.of((String)"2010-01-22T00:00:00.000Z/2010-01-23T00:00:00.000Z"));
        IntervalsResource intervalsResource = new IntervalsResource(this.inventoryView, new AuthConfig(), AuthTestUtils.TEST_AUTHORIZER_MAPPER);
        Response response = intervalsResource.getIntervals(this.request);
        TreeMap actualIntervals = (TreeMap)response.getEntity();
        Assert.assertEquals((long)2L, (long)actualIntervals.size());
        Assert.assertEquals(expectedIntervals.get(1), actualIntervals.firstKey());
        Assert.assertEquals((Object)10L, ((Map)((Map)actualIntervals.get(expectedIntervals.get(1))).get("datasource1")).get("size"));
        Assert.assertEquals((Object)1, ((Map)((Map)actualIntervals.get(expectedIntervals.get(1))).get("datasource1")).get("count"));
        Assert.assertEquals(expectedIntervals.get(0), actualIntervals.lastKey());
        Assert.assertEquals((Object)20L, ((Map)((Map)actualIntervals.get(expectedIntervals.get(0))).get("datasource1")).get("size"));
        Assert.assertEquals((Object)1, ((Map)((Map)actualIntervals.get(expectedIntervals.get(0))).get("datasource1")).get("count"));
        Assert.assertEquals((Object)5L, ((Map)((Map)actualIntervals.get(expectedIntervals.get(0))).get("datasource2")).get("size"));
        Assert.assertEquals((Object)1, ((Map)((Map)actualIntervals.get(expectedIntervals.get(0))).get("datasource2")).get("count"));
    }

    @Test
    public void testSimpleGetSpecificIntervals() {
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null)).once();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.request});
        ArrayList<Interval> expectedIntervals = new ArrayList<Interval>();
        expectedIntervals.add(Intervals.of((String)"2010-01-01T00:00:00.000Z/2010-01-02T00:00:00.000Z"));
        IntervalsResource intervalsResource = new IntervalsResource(this.inventoryView, new AuthConfig(), AuthTestUtils.TEST_AUTHORIZER_MAPPER);
        Response response = intervalsResource.getSpecificIntervals("2010-01-01T00:00:00.000Z/P1D", "simple", null, this.request);
        Map actualIntervals = (Map)response.getEntity();
        Assert.assertEquals((long)1L, (long)actualIntervals.size());
        Assert.assertTrue((boolean)actualIntervals.containsKey(expectedIntervals.get(0)));
        Assert.assertEquals((Object)25L, ((Map)actualIntervals.get(expectedIntervals.get(0))).get("size"));
        Assert.assertEquals((Object)2, ((Map)actualIntervals.get(expectedIntervals.get(0))).get("count"));
    }

    @Test
    public void testFullGetSpecificIntervals() {
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null)).once();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.request});
        ArrayList<Interval> expectedIntervals = new ArrayList<Interval>();
        expectedIntervals.add(Intervals.of((String)"2010-01-01T00:00:00.000Z/2010-01-02T00:00:00.000Z"));
        IntervalsResource intervalsResource = new IntervalsResource(this.inventoryView, new AuthConfig(), AuthTestUtils.TEST_AUTHORIZER_MAPPER);
        Response response = intervalsResource.getSpecificIntervals("2010-01-01T00:00:00.000Z/P1D", null, "full", this.request);
        TreeMap actualIntervals = (TreeMap)response.getEntity();
        Assert.assertEquals((long)1L, (long)actualIntervals.size());
        Assert.assertEquals(expectedIntervals.get(0), actualIntervals.firstKey());
        Assert.assertEquals((Object)20L, ((Map)((Map)actualIntervals.get(expectedIntervals.get(0))).get("datasource1")).get("size"));
        Assert.assertEquals((Object)1, ((Map)((Map)actualIntervals.get(expectedIntervals.get(0))).get("datasource1")).get("count"));
        Assert.assertEquals((Object)5L, ((Map)((Map)actualIntervals.get(expectedIntervals.get(0))).get("datasource2")).get("size"));
        Assert.assertEquals((Object)1, ((Map)((Map)actualIntervals.get(expectedIntervals.get(0))).get("datasource2")).get("count"));
    }

    @Test
    public void testGetSpecificIntervals() {
        EasyMock.expect((Object)this.inventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.server)).atLeastOnce();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authorization-Checked")).andReturn(null).once();
        EasyMock.expect((Object)this.request.getAttribute("Druid-Authentication-Result")).andReturn((Object)new AuthenticationResult("druid", "druid", null)).once();
        this.request.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.inventoryView, this.request});
        IntervalsResource intervalsResource = new IntervalsResource(this.inventoryView, new AuthConfig(), AuthTestUtils.TEST_AUTHORIZER_MAPPER);
        Response response = intervalsResource.getSpecificIntervals("2010-01-01T00:00:00.000Z/P1D", null, null, this.request);
        Map actualIntervals = (Map)response.getEntity();
        Assert.assertEquals((long)2L, (long)actualIntervals.size());
        Assert.assertEquals((Object)25L, actualIntervals.get("size"));
        Assert.assertEquals((Object)2, actualIntervals.get("count"));
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.inventoryView});
    }
}

