/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.server.coordinator.rules.ForeverBroadcastDistributionRule;
import org.apache.hive.druid.io.druid.server.coordinator.rules.IntervalBroadcastDistributionRule;
import org.apache.hive.druid.io.druid.server.coordinator.rules.PeriodBroadcastDistributionRule;
import org.apache.hive.druid.io.druid.server.coordinator.rules.Rule;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BroadcastDistributionRuleSerdeTest {
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();
    private final Rule testRule;

    @Parameterized.Parameters
    public static List<Object[]> constructorFeeder() {
        ArrayList params = Lists.newArrayList((Object[])new Object[][]{{new ForeverBroadcastDistributionRule((List)ImmutableList.of((Object)"large_source1", (Object)"large_source2"))}, {new ForeverBroadcastDistributionRule((List)ImmutableList.of())}, {new ForeverBroadcastDistributionRule(null)}, {new IntervalBroadcastDistributionRule(Intervals.of((String)"0/1000"), (List)ImmutableList.of((Object)"large_source"))}, {new IntervalBroadcastDistributionRule(Intervals.of((String)"0/1000"), (List)ImmutableList.of())}, {new IntervalBroadcastDistributionRule(Intervals.of((String)"0/1000"), null)}, {new PeriodBroadcastDistributionRule(new Period(1000L), (List)ImmutableList.of((Object)"large_source"))}, {new PeriodBroadcastDistributionRule(new Period(1000L), (List)ImmutableList.of())}, {new PeriodBroadcastDistributionRule(new Period(1000L), null)}});
        return params;
    }

    public BroadcastDistributionRuleSerdeTest(Rule testRule) {
        this.testRule = testRule;
    }

    @Test
    public void testSerde() throws IOException {
        ArrayList rules = Lists.newArrayList((Object[])new Rule[]{this.testRule});
        String json = MAPPER.writeValueAsString((Object)rules);
        List fromJson = (List)MAPPER.readValue(json, (TypeReference)new TypeReference<List<Rule>>(){});
        Assert.assertEquals((Object)rules, (Object)fromJson);
    }
}

