/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.io.druid.discovery.DiscoveryDruidNode;
import org.apache.hive.druid.io.druid.discovery.DruidNodeDiscovery;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.RE;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.io.druid.java.util.http.client.HttpClient;
import org.apache.hive.druid.io.druid.java.util.http.client.Request;
import org.apache.hive.druid.io.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.io.druid.server.ServerTestHelper;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.hive.druid.io.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.hive.druid.io.druid.server.coordinator.HttpLoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.LoadPeonCallback;
import org.apache.hive.druid.io.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponse;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpVersion;
import org.joda.time.Duration;
import org.junit.Test;

public class HttpLoadQueuePeonTest {
    @Test(timeout=10000L)
    public void testSimple() throws Exception {
        DataSegment segment1 = new DataSegment("test1", Intervals.of((String)"2014/2015"), "v1", null, null, null, null, Integer.valueOf(0), 0L);
        DataSegment segment2 = new DataSegment("test2", Intervals.of((String)"2014/2015"), "v1", null, null, null, null, Integer.valueOf(0), 0L);
        DataSegment segment3 = new DataSegment("test3", Intervals.of((String)"2014/2015"), "v1", null, null, null, null, Integer.valueOf(0), 0L);
        DataSegment segment4 = new DataSegment("test4", Intervals.of((String)"2014/2015"), "v1", null, null, null, null, Integer.valueOf(0), 0L);
        HttpLoadQueuePeon httpLoadQueuePeon = new HttpLoadQueuePeon("http://dummy:4000", ServerTestHelper.MAPPER, (HttpClient)new TestHttpClient(), (DruidCoordinatorConfig)new TestDruidCoordinatorConfig(null, null, null, null, null, null, 10, null, false, false, Duration.ZERO){

            public int getHttpLoadQueuePeonBatchSize() {
                return 2;
            }
        }, Executors.newScheduledThreadPool(2, Execs.makeThreadFactory((String)"HttpLoadQueuePeonTest-%s")), Execs.singleThreaded((String)"HttpLoadQueuePeonTest"));
        httpLoadQueuePeon.start();
        ImmutableMap latches = ImmutableMap.of((Object)segment1.getIdentifier(), (Object)new CountDownLatch(1), (Object)segment2.getIdentifier(), (Object)new CountDownLatch(1), (Object)segment3.getIdentifier(), (Object)new CountDownLatch(1), (Object)segment4.getIdentifier(), (Object)new CountDownLatch(1));
        httpLoadQueuePeon.dropSegment(segment1, new LoadPeonCallback((Map)latches, segment1){
            final /* synthetic */ Map val$latches;
            final /* synthetic */ DataSegment val$segment1;
            {
                this.val$latches = map;
                this.val$segment1 = dataSegment;
            }

            public void execute() {
                ((CountDownLatch)this.val$latches.get(this.val$segment1.getIdentifier())).countDown();
            }
        });
        httpLoadQueuePeon.loadSegment(segment2, new LoadPeonCallback((Map)latches, segment2){
            final /* synthetic */ Map val$latches;
            final /* synthetic */ DataSegment val$segment2;
            {
                this.val$latches = map;
                this.val$segment2 = dataSegment;
            }

            public void execute() {
                ((CountDownLatch)this.val$latches.get(this.val$segment2.getIdentifier())).countDown();
            }
        });
        httpLoadQueuePeon.dropSegment(segment3, new LoadPeonCallback((Map)latches, segment3){
            final /* synthetic */ Map val$latches;
            final /* synthetic */ DataSegment val$segment3;
            {
                this.val$latches = map;
                this.val$segment3 = dataSegment;
            }

            public void execute() {
                ((CountDownLatch)this.val$latches.get(this.val$segment3.getIdentifier())).countDown();
            }
        });
        httpLoadQueuePeon.loadSegment(segment4, new LoadPeonCallback((Map)latches, segment4){
            final /* synthetic */ Map val$latches;
            final /* synthetic */ DataSegment val$segment4;
            {
                this.val$latches = map;
                this.val$segment4 = dataSegment;
            }

            public void execute() {
                ((CountDownLatch)this.val$latches.get(this.val$segment4.getIdentifier())).countDown();
            }
        });
        ((CountDownLatch)latches.get(segment1.getIdentifier())).await();
        ((CountDownLatch)latches.get(segment2.getIdentifier())).await();
        ((CountDownLatch)latches.get(segment3.getIdentifier())).await();
        ((CountDownLatch)latches.get(segment4.getIdentifier())).await();
        httpLoadQueuePeon.stop();
    }

    private static class TestHttpClient
    implements HttpClient {
        AtomicInteger requestNum = new AtomicInteger(0);

        private TestHttpClient() {
        }

        public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> httpResponseHandler) {
            throw new UnsupportedOperationException("Not Implemented.");
        }

        public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> httpResponseHandler, Duration duration) {
            DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            httpResponse.setContent(ChannelBuffers.buffer((int)0));
            httpResponseHandler.handleResponse((HttpResponse)httpResponse);
            try {
                List changeRequests = (List)ServerTestHelper.MAPPER.readValue(request.getContent().array(), (TypeReference)new TypeReference<List<DataSegmentChangeRequest>>(){});
                ArrayList<SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus> statuses = new ArrayList<SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus>(changeRequests.size());
                for (DataSegmentChangeRequest cr : changeRequests) {
                    statuses.add(new SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus(cr, SegmentLoadDropHandler.Status.SUCCESS));
                }
                return Futures.immediateFuture((Object)new ByteArrayInputStream(ServerTestHelper.MAPPER.writerWithType(HttpLoadQueuePeon.RESPONSE_ENTITY_TYPE_REF).writeValueAsBytes(statuses)));
            }
            catch (Exception ex) {
                throw new RE((Throwable)ex, "Unexpected exception.", new Object[0]);
            }
        }
    }

    private static class TestDruidNodeDiscovery
    implements DruidNodeDiscovery {
        DruidNodeDiscovery.Listener listener;

        private TestDruidNodeDiscovery() {
        }

        public Collection<DiscoveryDruidNode> getAllNodes() {
            throw new UnsupportedOperationException("Not Implemented.");
        }

        public void registerListener(DruidNodeDiscovery.Listener listener) {
            listener.nodesAdded((List)ImmutableList.of());
            this.listener = listener;
        }
    }
}

