/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.appenderator;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorTester;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentIdentifier;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.UsedSegmentChecker;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;

public class TestUsedSegmentChecker
implements UsedSegmentChecker {
    private final AppenderatorTester appenderatorTester;

    public TestUsedSegmentChecker(AppenderatorTester appenderatorTester) {
        this.appenderatorTester = appenderatorTester;
    }

    public Set<DataSegment> findUsedSegments(Set<SegmentIdentifier> identifiers) throws IOException {
        VersionedIntervalTimeline timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
        for (DataSegment dataSegment : this.appenderatorTester.getPushedSegments()) {
            timeline.add(dataSegment.getInterval(), (Object)dataSegment.getVersion(), dataSegment.getShardSpec().createChunk((Object)dataSegment));
        }
        HashSet retVal = Sets.newHashSet();
        for (SegmentIdentifier identifier : identifiers) {
            for (TimelineObjectHolder holder : timeline.lookup(identifier.getInterval())) {
                for (PartitionChunk chunk : holder.getObject()) {
                    if (!identifiers.contains(SegmentIdentifier.fromDataSegment((DataSegment)((DataSegment)chunk.getObject())))) continue;
                    retVal.add(chunk.getObject());
                }
            }
        }
        return retVal;
    }
}

