/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.appenderator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.data.input.Committer;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.apache.hive.druid.io.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.io.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.Appenderator;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorImpl;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.AppenderatorTester;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentIdentifier;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.Committers;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.LinearShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class AppenderatorTest {
    private static final List<SegmentIdentifier> IDENTIFIERS = ImmutableList.of((Object)AppenderatorTest.SI("2000/2001", "A", 0), (Object)AppenderatorTest.SI("2000/2001", "A", 1), (Object)AppenderatorTest.SI("2001/2002", "A", 0));

    @Test
    public void testSimpleIngestion() throws Exception {
        try (AppenderatorTester tester = new AppenderatorTester(2, true);){
            Appenderator appenderator = tester.getAppenderator();
            ConcurrentHashMap<String, String> commitMetadata = new ConcurrentHashMap<String, String>();
            Supplier<Committer> committerSupplier = AppenderatorTest.committerSupplierFromConcurrentMap(commitMetadata);
            Assert.assertEquals(null, (Object)appenderator.startJob());
            Assert.assertEquals((Object)"foo", (Object)appenderator.getDataSource());
            commitMetadata.put("x", "1");
            Assert.assertEquals((long)1L, (long)appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "foo", 1L), committerSupplier).getNumRowsInSegment());
            commitMetadata.put("x", "2");
            Assert.assertEquals((long)2L, (long)appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "bar", 2L), committerSupplier).getNumRowsInSegment());
            commitMetadata.put("x", "3");
            Assert.assertEquals((long)1L, (long)appenderator.add(IDENTIFIERS.get(1), AppenderatorTest.IR("2000", "qux", 4L), committerSupplier).getNumRowsInSegment());
            Assert.assertEquals(IDENTIFIERS.subList(0, 2), AppenderatorTest.sorted(appenderator.getSegments()));
            Assert.assertEquals((long)2L, (long)appenderator.getRowCount(IDENTIFIERS.get(0)));
            Assert.assertEquals((long)1L, (long)appenderator.getRowCount(IDENTIFIERS.get(1)));
            boolean thrown = false;
            try {
                appenderator.getRowCount(IDENTIFIERS.get(2));
            }
            catch (IllegalStateException e) {
                thrown = true;
            }
            Assert.assertTrue((boolean)thrown);
            SegmentsAndMetadata segmentsAndMetadata = (SegmentsAndMetadata)appenderator.push((Collection)appenderator.getSegments(), (Committer)committerSupplier.get()).get();
            Assert.assertEquals((Object)ImmutableMap.of((Object)"x", (Object)"3"), (Object)((Map)segmentsAndMetadata.getCommitMetadata()));
            Assert.assertEquals(IDENTIFIERS.subList(0, 2), AppenderatorTest.sorted(Lists.transform((List)segmentsAndMetadata.getSegments(), (Function)new Function<DataSegment, SegmentIdentifier>(){

                public SegmentIdentifier apply(DataSegment input) {
                    return SegmentIdentifier.fromDataSegment((DataSegment)input);
                }
            })));
            Assert.assertEquals(AppenderatorTest.sorted(tester.getPushedSegments()), AppenderatorTest.sorted(segmentsAndMetadata.getSegments()));
            appenderator.clear();
            Assert.assertTrue((boolean)appenderator.getSegments().isEmpty());
        }
    }

    @Test
    public void testMaxRowsInMemory() throws Exception {
        try (AppenderatorTester tester = new AppenderatorTester(3, true);){
            Appenderator appenderator = tester.getAppenderator();
            final AtomicInteger eventCount = new AtomicInteger(0);
            Supplier<Committer> committerSupplier = new Supplier<Committer>(){

                public Committer get() {
                    final ImmutableMap metadata = ImmutableMap.of((Object)"eventCount", (Object)eventCount.get());
                    return new Committer(){

                        public Object getMetadata() {
                            return metadata;
                        }

                        public void run() {
                        }
                    };
                }
            };
            Assert.assertEquals((long)0L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.startJob();
            Assert.assertEquals((long)0L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "foo", 1L), (Supplier)committerSupplier);
            Assert.assertEquals((long)1L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.add(IDENTIFIERS.get(1), AppenderatorTest.IR("2000", "bar", 1L), (Supplier)committerSupplier);
            Assert.assertEquals((long)2L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.add(IDENTIFIERS.get(1), AppenderatorTest.IR("2000", "bar", 1L), (Supplier)committerSupplier);
            Assert.assertEquals((long)2L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "baz", 1L), (Supplier)committerSupplier);
            Assert.assertEquals((long)0L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.add(IDENTIFIERS.get(1), AppenderatorTest.IR("2000", "qux", 1L), (Supplier)committerSupplier);
            Assert.assertEquals((long)1L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "bob", 1L), (Supplier)committerSupplier);
            Assert.assertEquals((long)2L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.persist((Collection)ImmutableList.of((Object)IDENTIFIERS.get(1)), (Committer)committerSupplier.get());
            Assert.assertEquals((long)1L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.close();
            Assert.assertEquals((long)0L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
        }
    }

    @Test
    public void testMaxRowsInMemoryDisallowIncrementalPersists() throws Exception {
        try (AppenderatorTester tester = new AppenderatorTester(3, false);){
            Appenderator appenderator = tester.getAppenderator();
            AtomicInteger eventCount = new AtomicInteger(0);
            Supplier committerSupplier = () -> {
                final ImmutableMap metadata = ImmutableMap.of((Object)"eventCount", (Object)eventCount.get());
                return new Committer(){

                    public Object getMetadata() {
                        return metadata;
                    }

                    public void run() {
                    }
                };
            };
            Assert.assertEquals((long)0L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.startJob();
            Assert.assertEquals((long)0L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "foo", 1L), committerSupplier, false);
            Assert.assertEquals((long)1L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.add(IDENTIFIERS.get(1), AppenderatorTest.IR("2000", "bar", 1L), committerSupplier, false);
            Assert.assertEquals((long)2L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.add(IDENTIFIERS.get(1), AppenderatorTest.IR("2000", "bar", 1L), committerSupplier, false);
            Assert.assertEquals((long)2L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "baz", 1L), committerSupplier, false);
            Assert.assertEquals((long)3L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.add(IDENTIFIERS.get(1), AppenderatorTest.IR("2000", "qux", 1L), committerSupplier, false);
            Assert.assertEquals((long)4L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "bob", 1L), committerSupplier, false);
            Assert.assertEquals((long)5L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.persist((Collection)ImmutableList.of((Object)IDENTIFIERS.get(1)), (Committer)committerSupplier.get());
            Assert.assertEquals((long)3L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
            appenderator.close();
            Assert.assertEquals((long)0L, (long)((AppenderatorImpl)appenderator).getRowsInMemory());
        }
    }

    @Test
    public void testRestoreFromDisk() throws Exception {
        try (AppenderatorTester tester = new AppenderatorTester(2, true);){
            Appenderator appenderator = tester.getAppenderator();
            RealtimeTuningConfig tuningConfig = tester.getTuningConfig();
            final AtomicInteger eventCount = new AtomicInteger(0);
            Supplier<Committer> committerSupplier = new Supplier<Committer>(){

                public Committer get() {
                    final ImmutableMap metadata = ImmutableMap.of((Object)"eventCount", (Object)eventCount.get());
                    return new Committer(){

                        public Object getMetadata() {
                            return metadata;
                        }

                        public void run() {
                        }
                    };
                }
            };
            appenderator.startJob();
            eventCount.incrementAndGet();
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "foo", 1L), (Supplier)committerSupplier);
            eventCount.incrementAndGet();
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "bar", 2L), (Supplier)committerSupplier);
            eventCount.incrementAndGet();
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "baz", 3L), (Supplier)committerSupplier);
            eventCount.incrementAndGet();
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "qux", 4L), (Supplier)committerSupplier);
            eventCount.incrementAndGet();
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "bob", 5L), (Supplier)committerSupplier);
            appenderator.close();
            try (AppenderatorTester tester2 = new AppenderatorTester(2, tuningConfig.getBasePersistDirectory(), true);){
                Appenderator appenderator2 = tester2.getAppenderator();
                Assert.assertEquals((Object)ImmutableMap.of((Object)"eventCount", (Object)4), (Object)appenderator2.startJob());
                Assert.assertEquals((Object)ImmutableList.of((Object)IDENTIFIERS.get(0)), (Object)appenderator2.getSegments());
                Assert.assertEquals((long)4L, (long)appenderator2.getRowCount(IDENTIFIERS.get(0)));
            }
        }
    }

    @Test(timeout=10000L)
    public void testTotalRowCount() throws Exception {
        try (AppenderatorTester tester = new AppenderatorTester(3, true);){
            Appenderator appenderator = tester.getAppenderator();
            ConcurrentHashMap<String, String> commitMetadata = new ConcurrentHashMap<String, String>();
            Supplier<Committer> committerSupplier = AppenderatorTest.committerSupplierFromConcurrentMap(commitMetadata);
            Assert.assertEquals((long)0L, (long)appenderator.getTotalRowCount());
            appenderator.startJob();
            Assert.assertEquals((long)0L, (long)appenderator.getTotalRowCount());
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "foo", 1L), committerSupplier);
            Assert.assertEquals((long)1L, (long)appenderator.getTotalRowCount());
            appenderator.add(IDENTIFIERS.get(1), AppenderatorTest.IR("2000", "bar", 1L), committerSupplier);
            Assert.assertEquals((long)2L, (long)appenderator.getTotalRowCount());
            appenderator.persistAll((Committer)committerSupplier.get()).get();
            Assert.assertEquals((long)2L, (long)appenderator.getTotalRowCount());
            appenderator.drop(IDENTIFIERS.get(0)).get();
            Assert.assertEquals((long)1L, (long)appenderator.getTotalRowCount());
            appenderator.drop(IDENTIFIERS.get(1)).get();
            Assert.assertEquals((long)0L, (long)appenderator.getTotalRowCount());
            appenderator.add(IDENTIFIERS.get(2), AppenderatorTest.IR("2001", "bar", 1L), committerSupplier);
            Assert.assertEquals((long)1L, (long)appenderator.getTotalRowCount());
            appenderator.add(IDENTIFIERS.get(2), AppenderatorTest.IR("2001", "baz", 1L), committerSupplier);
            Assert.assertEquals((long)2L, (long)appenderator.getTotalRowCount());
            appenderator.add(IDENTIFIERS.get(2), AppenderatorTest.IR("2001", "qux", 1L), committerSupplier);
            Assert.assertEquals((long)3L, (long)appenderator.getTotalRowCount());
            appenderator.add(IDENTIFIERS.get(2), AppenderatorTest.IR("2001", "bob", 1L), committerSupplier);
            Assert.assertEquals((long)4L, (long)appenderator.getTotalRowCount());
            appenderator.persistAll((Committer)committerSupplier.get()).get();
            Assert.assertEquals((long)4L, (long)appenderator.getTotalRowCount());
            appenderator.drop(IDENTIFIERS.get(2)).get();
            Assert.assertEquals((long)0L, (long)appenderator.getTotalRowCount());
            appenderator.close();
            Assert.assertEquals((long)0L, (long)appenderator.getTotalRowCount());
        }
    }

    @Test
    public void testQueryByIntervals() throws Exception {
        try (AppenderatorTester tester = new AppenderatorTester(2, true);){
            Appenderator appenderator = tester.getAppenderator();
            appenderator.startJob();
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "foo", 1L), Suppliers.ofInstance((Object)Committers.nil()));
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "foo", 2L), Suppliers.ofInstance((Object)Committers.nil()));
            appenderator.add(IDENTIFIERS.get(1), AppenderatorTest.IR("2000", "foo", 4L), Suppliers.ofInstance((Object)Committers.nil()));
            appenderator.add(IDENTIFIERS.get(2), AppenderatorTest.IR("2001", "foo", 8L), Suppliers.ofInstance((Object)Committers.nil()));
            appenderator.add(IDENTIFIERS.get(2), AppenderatorTest.IR("2001T01", "foo", 16L), Suppliers.ofInstance((Object)Committers.nil()));
            appenderator.add(IDENTIFIERS.get(2), AppenderatorTest.IR("2001T02", "foo", 32L), Suppliers.ofInstance((Object)Committers.nil()));
            appenderator.add(IDENTIFIERS.get(2), AppenderatorTest.IR("2001T03", "foo", 64L), Suppliers.ofInstance((Object)Committers.nil()));
            TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals((List)ImmutableList.of((Object)Intervals.of((String)"2000/2001"))).aggregators(Arrays.asList(new LongSumAggregatorFactory("count", "count"), new LongSumAggregatorFactory("met", "met"))).granularity(Granularities.DAY).build();
            ArrayList results1 = Lists.newArrayList();
            Sequences.toList((Sequence)QueryPlus.wrap((Query)query1).run((QuerySegmentWalker)appenderator, (Map)ImmutableMap.of()), (List)results1);
            Assert.assertEquals((String)"query1", (Object)ImmutableList.of((Object)new Result(DateTimes.of((String)"2000"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)3L, (Object)"met", (Object)7L)))), (Object)results1);
            TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals((List)ImmutableList.of((Object)Intervals.of((String)"2000/2002"))).aggregators(Arrays.asList(new LongSumAggregatorFactory("count", "count"), new LongSumAggregatorFactory("met", "met"))).granularity(Granularities.DAY).build();
            ArrayList results2 = Lists.newArrayList();
            Sequences.toList((Sequence)QueryPlus.wrap((Query)query2).run((QuerySegmentWalker)appenderator, (Map)ImmutableMap.of()), (List)results2);
            Assert.assertEquals((String)"query2", (Object)ImmutableList.of((Object)new Result(DateTimes.of((String)"2000"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)3L, (Object)"met", (Object)7L))), (Object)new Result(DateTimes.of((String)"2001"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)4L, (Object)"met", (Object)120L)))), (Object)results2);
            TimeseriesQuery query3 = Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals((List)ImmutableList.of((Object)Intervals.of((String)"2000/2001T01"))).aggregators(Arrays.asList(new LongSumAggregatorFactory("count", "count"), new LongSumAggregatorFactory("met", "met"))).granularity(Granularities.DAY).build();
            ArrayList results3 = Lists.newArrayList();
            Sequences.toList((Sequence)QueryPlus.wrap((Query)query3).run((QuerySegmentWalker)appenderator, (Map)ImmutableMap.of()), (List)results3);
            Assert.assertEquals((Object)ImmutableList.of((Object)new Result(DateTimes.of((String)"2000"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)3L, (Object)"met", (Object)7L))), (Object)new Result(DateTimes.of((String)"2001"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)1L, (Object)"met", (Object)8L)))), (Object)results3);
            TimeseriesQuery query4 = Druids.newTimeseriesQueryBuilder().dataSource("foo").intervals((List)ImmutableList.of((Object)Intervals.of((String)"2000/2001T01"), (Object)Intervals.of((String)"2001T03/2001T04"))).aggregators(Arrays.asList(new LongSumAggregatorFactory("count", "count"), new LongSumAggregatorFactory("met", "met"))).granularity(Granularities.DAY).build();
            ArrayList results4 = Lists.newArrayList();
            Sequences.toList((Sequence)QueryPlus.wrap((Query)query4).run((QuerySegmentWalker)appenderator, (Map)ImmutableMap.of()), (List)results4);
            Assert.assertEquals((Object)ImmutableList.of((Object)new Result(DateTimes.of((String)"2000"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)3L, (Object)"met", (Object)7L))), (Object)new Result(DateTimes.of((String)"2001"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)2L, (Object)"met", (Object)72L)))), (Object)results4);
        }
    }

    @Test
    public void testQueryBySegments() throws Exception {
        try (AppenderatorTester tester = new AppenderatorTester(2, true);){
            Appenderator appenderator = tester.getAppenderator();
            appenderator.startJob();
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "foo", 1L), Suppliers.ofInstance((Object)Committers.nil()));
            appenderator.add(IDENTIFIERS.get(0), AppenderatorTest.IR("2000", "foo", 2L), Suppliers.ofInstance((Object)Committers.nil()));
            appenderator.add(IDENTIFIERS.get(1), AppenderatorTest.IR("2000", "foo", 4L), Suppliers.ofInstance((Object)Committers.nil()));
            appenderator.add(IDENTIFIERS.get(2), AppenderatorTest.IR("2001", "foo", 8L), Suppliers.ofInstance((Object)Committers.nil()));
            appenderator.add(IDENTIFIERS.get(2), AppenderatorTest.IR("2001T01", "foo", 16L), Suppliers.ofInstance((Object)Committers.nil()));
            appenderator.add(IDENTIFIERS.get(2), AppenderatorTest.IR("2001T02", "foo", 32L), Suppliers.ofInstance((Object)Committers.nil()));
            appenderator.add(IDENTIFIERS.get(2), AppenderatorTest.IR("2001T03", "foo", 64L), Suppliers.ofInstance((Object)Committers.nil()));
            TimeseriesQuery query1 = Druids.newTimeseriesQueryBuilder().dataSource("foo").aggregators(Arrays.asList(new LongSumAggregatorFactory("count", "count"), new LongSumAggregatorFactory("met", "met"))).granularity(Granularities.DAY).intervals((QuerySegmentSpec)new MultipleSpecificSegmentSpec((List)ImmutableList.of((Object)new SegmentDescriptor(IDENTIFIERS.get(2).getInterval(), IDENTIFIERS.get(2).getVersion(), IDENTIFIERS.get(2).getShardSpec().getPartitionNum())))).build();
            ArrayList results1 = Lists.newArrayList();
            Sequences.toList((Sequence)QueryPlus.wrap((Query)query1).run((QuerySegmentWalker)appenderator, (Map)ImmutableMap.of()), (List)results1);
            Assert.assertEquals((String)"query1", (Object)ImmutableList.of((Object)new Result(DateTimes.of((String)"2001"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)4L, (Object)"met", (Object)120L)))), (Object)results1);
            TimeseriesQuery query2 = Druids.newTimeseriesQueryBuilder().dataSource("foo").aggregators(Arrays.asList(new LongSumAggregatorFactory("count", "count"), new LongSumAggregatorFactory("met", "met"))).granularity(Granularities.DAY).intervals((QuerySegmentSpec)new MultipleSpecificSegmentSpec((List)ImmutableList.of((Object)new SegmentDescriptor(Intervals.of((String)"2001/PT1H"), IDENTIFIERS.get(2).getVersion(), IDENTIFIERS.get(2).getShardSpec().getPartitionNum())))).build();
            ArrayList results2 = Lists.newArrayList();
            Sequences.toList((Sequence)QueryPlus.wrap((Query)query2).run((QuerySegmentWalker)appenderator, (Map)ImmutableMap.of()), (List)results2);
            Assert.assertEquals((String)"query2", (Object)ImmutableList.of((Object)new Result(DateTimes.of((String)"2001"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)1L, (Object)"met", (Object)8L)))), (Object)results2);
            TimeseriesQuery query3 = Druids.newTimeseriesQueryBuilder().dataSource("foo").aggregators(Arrays.asList(new LongSumAggregatorFactory("count", "count"), new LongSumAggregatorFactory("met", "met"))).granularity(Granularities.DAY).intervals((QuerySegmentSpec)new MultipleSpecificSegmentSpec((List)ImmutableList.of((Object)new SegmentDescriptor(Intervals.of((String)"2001/PT1H"), IDENTIFIERS.get(2).getVersion(), IDENTIFIERS.get(2).getShardSpec().getPartitionNum()), (Object)new SegmentDescriptor(Intervals.of((String)"2001T03/PT1H"), IDENTIFIERS.get(2).getVersion(), IDENTIFIERS.get(2).getShardSpec().getPartitionNum())))).build();
            ArrayList results3 = Lists.newArrayList();
            Sequences.toList((Sequence)QueryPlus.wrap((Query)query3).run((QuerySegmentWalker)appenderator, (Map)ImmutableMap.of()), (List)results3);
            Assert.assertEquals((String)"query2", (Object)ImmutableList.of((Object)new Result(DateTimes.of((String)"2001"), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"count", (Object)2L, (Object)"met", (Object)72L)))), (Object)results3);
        }
    }

    private static SegmentIdentifier SI(String interval, String version, int partitionNum) {
        return new SegmentIdentifier("foo", Intervals.of((String)interval), version, (ShardSpec)new LinearShardSpec(Integer.valueOf(partitionNum)));
    }

    static InputRow IR(String ts, String dim, long met) {
        return new MapBasedInputRow(DateTimes.of((String)ts).getMillis(), (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)dim, (Object)"met", (Object)met));
    }

    private static Supplier<Committer> committerSupplierFromConcurrentMap(final ConcurrentMap<String, String> map) {
        return new Supplier<Committer>(){

            public Committer get() {
                ImmutableMap mapCopy = ImmutableMap.copyOf((Map)map);
                return new Committer((Map)mapCopy){
                    final /* synthetic */ Map val$mapCopy;
                    {
                        this.val$mapCopy = map;
                    }

                    public Object getMetadata() {
                        return this.val$mapCopy;
                    }

                    public void run() {
                    }
                };
            }
        };
    }

    private static <T> List<T> sorted(List<T> xs) {
        ArrayList xsSorted = Lists.newArrayList(xs);
        Collections.sort(xsSorted, new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                if (a instanceof SegmentIdentifier && b instanceof SegmentIdentifier) {
                    return ((SegmentIdentifier)a).getIdentifierAsString().compareTo(((SegmentIdentifier)b).getIdentifierAsString());
                }
                if (a instanceof DataSegment && b instanceof DataSegment) {
                    return ((DataSegment)a).getIdentifier().compareTo(((DataSegment)b).getIdentifier());
                }
                throw new IllegalStateException("WTF??");
            }
        });
        return xsSorted;
    }
}

