/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.filter;

import org.apache.hive.druid.io.druid.segment.DimensionHandler;
import org.apache.hive.druid.io.druid.segment.Rowboat;
import org.apache.hive.druid.io.druid.segment.StringDimensionHandler;
import org.junit.Assert;
import org.junit.Test;

public class RowboatTest {
    private static DimensionHandler[] getDefaultHandlers(int size) {
        DimensionHandler[] handlers = new DimensionHandler[size];
        for (int i = 0; i < size; ++i) {
            handlers[i] = new StringDimensionHandler(String.valueOf(i), null);
        }
        return handlers;
    }

    @Test
    public void testRowboatCompare() {
        DimensionHandler[] handlers = RowboatTest.getDefaultHandlers(3);
        Rowboat rb1 = new Rowboat(12345L, (Object[])new int[][]{{1}, {2}}, new Object[]{new Integer(7)}, 5, handlers);
        Rowboat rb2 = new Rowboat(12345L, (Object[])new int[][]{{1}, {2}}, new Object[]{new Integer(7)}, 5, handlers);
        Assert.assertEquals((long)0L, (long)rb1.compareTo(rb2));
        Rowboat rb3 = new Rowboat(12345L, (Object[])new int[][]{{3}, {2}}, new Object[]{new Integer(7)}, 5, handlers);
        Assert.assertNotEquals((long)0L, (long)rb1.compareTo(rb3));
    }

    @Test
    public void testBiggerCompare() {
        DimensionHandler[] handlers = RowboatTest.getDefaultHandlers(14);
        Rowboat rb1 = new Rowboat(0L, (Object[])new int[][]{{0}, {138}, {44}, {374}, {0}, {0}, {552}, {338}, {910}, {25570}, {9}, {0}, {0}, {0}}, new Object[]{1.0, 47.0, "someMetric"}, 0, handlers);
        Rowboat rb2 = new Rowboat(0L, (Object[])new int[][]{{0}, {138}, {44}, {374}, {0}, {0}, {553}, {338}, {910}, {25580}, {9}, {0}, {0}, {0}}, new Object[]{1.0, 47.0, "someMetric"}, 0, handlers);
        Assert.assertNotEquals((long)0L, (long)rb1.compareTo(rb2));
    }

    @Test
    public void testToString() {
        DimensionHandler[] handlers = RowboatTest.getDefaultHandlers(2);
        Assert.assertEquals((Object)"Rowboat{timestamp=1970-01-01T00:00:00.000Z, dims=[[1], [2]], metrics=[someMetric], comprisedRows={}}", (Object)new Rowboat(0L, (Object[])new int[][]{{1}, {2}}, new Object[]{"someMetric"}, 5, handlers).toString());
    }

    @Test
    public void testLotsONullString() {
        DimensionHandler[] handlers = RowboatTest.getDefaultHandlers(0);
        Assert.assertEquals((Object)"Rowboat{timestamp=1970-01-01T00:00:00.000Z, dims=null, metrics=null, comprisedRows={}}", (Object)new Rowboat(0L, null, null, 5, handlers).toString());
    }
}

