/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.TestQueryRunners;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.post.ArithmeticPostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.ConstantPostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.hive.druid.io.druid.query.search.SearchHit;
import org.apache.hive.druid.io.druid.query.search.SearchQuery;
import org.apache.hive.druid.io.druid.query.search.SearchResultValue;
import org.apache.hive.druid.io.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.io.druid.query.topn.DimensionAndMetricValueExtractor;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryBuilder;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;
import org.apache.hive.druid.io.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.io.druid.segment.SchemalessIndexTest;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.TestIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SchemalessTestSimpleTest {
    final String dataSource = "testing";
    final Granularity allGran = Granularities.ALL;
    final String marketDimension = "market";
    final String qualityDimension = "quality";
    final String placementDimension = "placement";
    final String placementishDimension = "placementish";
    final String indexMetric = "index";
    final CountAggregatorFactory rowsCount = new CountAggregatorFactory("rows");
    final DoubleSumAggregatorFactory indexDoubleSum = new DoubleSumAggregatorFactory("index", "index");
    final HyperUniquesAggregatorFactory uniques = new HyperUniquesAggregatorFactory("uniques", "quality_uniques");
    final ConstantPostAggregator constant = new ConstantPostAggregator("const", (Number)1L);
    final FieldAccessPostAggregator rowsPostAgg = new FieldAccessPostAggregator("rows", "rows");
    final FieldAccessPostAggregator indexPostAgg = new FieldAccessPostAggregator("index", "index");
    final ArithmeticPostAggregator addRowsIndexConstant = new ArithmeticPostAggregator("addRowsIndexConstant", "+", (List)Lists.newArrayList((Object[])new PostAggregator[]{this.constant, this.rowsPostAgg, this.indexPostAgg}));
    final List<AggregatorFactory> commonAggregators = Arrays.asList(this.rowsCount, this.indexDoubleSum, this.uniques);
    final QuerySegmentSpec fullOnInterval = new MultipleIntervalSegmentSpec(Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.000Z/2020-01-01T00:00:00.000Z")));
    private Segment segment;

    @Parameterized.Parameters
    public static Collection<?> constructorFeeder() throws IOException {
        ArrayList<Object[]> argumentArrays = new ArrayList<Object[]>();
        for (SegmentWriteOutMediumFactory segmentWriteOutMediumFactory : SegmentWriteOutMediumFactory.builtInFactories()) {
            SchemalessIndexTest schemalessIndexTest = new SchemalessIndexTest(segmentWriteOutMediumFactory);
            IncrementalIndex incrementalIndex = SchemalessIndexTest.getIncrementalIndex();
            QueryableIndex persistedIncrementalIndex = TestIndex.persistRealtimeAndLoadMMapped(incrementalIndex);
            QueryableIndex mergedIncrementalIndex = schemalessIndexTest.getMergedIncrementalIndex();
            argumentArrays.add(new Object[]{new IncrementalIndexSegment(incrementalIndex, null)});
            argumentArrays.add(new Object[]{new QueryableIndexSegment(null, persistedIncrementalIndex)});
            argumentArrays.add(new Object[]{new QueryableIndexSegment(null, mergedIncrementalIndex)});
        }
        return argumentArrays;
    }

    public SchemalessTestSimpleTest(Segment segment) {
        this.segment = segment;
    }

    @Test
    public void testFullOnTimeseries() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(this.allGran).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(new PostAggregator[]{this.addRowsIndexConstant}).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeseriesResultValue((Map)ImmutableMap.builder().put((Object)"rows", (Object)11L).put((Object)"index", (Object)900.0).put((Object)"addRowsIndexConstant", (Object)912.0).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)0.0).build())));
        QueryRunner runner = TestQueryRunners.makeTimeSeriesQueryRunner(this.segment);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query), context));
    }

    public void testFullOnTopN() {
        TopNQuery query = new TopNQueryBuilder().dataSource("testing").granularity(this.allGran).dimension("market").metric("index").threshold(3).intervals(this.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(this.commonAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(this.addRowsIndexConstant)).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(new DimensionAndMetricValueExtractor((Map)ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)4L).put((Object)"index", (Object)400.0).put((Object)"addRowsIndexConstant", (Object)405.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()), new DimensionAndMetricValueExtractor((Map)ImmutableMap.builder().put((Object)"market", (Object)"").put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)0.0).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build()), new DimensionAndMetricValueExtractor((Map)ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)2L).put((Object)"index", (Object)200.0).put((Object)"addRowsIndexConstant", (Object)203.0).put((Object)"uniques", (Object)1.0002442201269182).put((Object)"maxIndex", (Object)100.0).put((Object)"minIndex", (Object)100.0).build())))));
        QueryRunner runner = TestQueryRunners.makeTopNQueryRunner(this.segment);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query), context));
    }

    @Test
    public void testFullOnSearch() {
        SearchQuery query = Druids.newSearchQueryBuilder().dataSource("testing").granularity(this.allGran).intervals(this.fullOnInterval).query("a").build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new SearchResultValue(Arrays.asList(new SearchHit("placementish", "a"), new SearchHit("quality", "automotive"), new SearchHit("placement", "mezzanine"), new SearchHit("market", "total_market")))));
        QueryRunner runner = TestQueryRunners.makeSearchQueryRunner(this.segment);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query), context));
    }

    @Test
    public void testTimeBoundary() {
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)"maxTime", (Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z")))));
        QueryRunner runner = TestQueryRunners.makeTimeBoundaryQueryRunner(this.segment);
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, runner.run(QueryPlus.wrap((Query)query), context));
    }
}

