/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.collections.NonBlockingPool;
import org.apache.hive.druid.io.druid.collections.StupidPool;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.TestQueryRunners;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMaxAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleMinAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.hive.druid.io.druid.query.topn.TopNQuery;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryBuilder;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryConfig;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.topn.TopNQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TopNUnionQueryTest {
    private final QueryRunner runner;

    public TopNUnionQueryTest(QueryRunner runner) {
        this.runner = runner;
    }

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return QueryRunnerTestHelper.cartesian(Iterables.concat(QueryRunnerTestHelper.makeUnionQueryRunners((QueryRunnerFactory)new TopNQueryRunnerFactory(TestQueryRunners.getPool(), new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER)), QueryRunnerTestHelper.makeUnionQueryRunners((QueryRunnerFactory)new TopNQueryRunnerFactory((NonBlockingPool)new StupidPool("TopNQueryRunnerFactory-bufferPool", () -> ByteBuffer.allocate(2000)), new TopNQueryQueryToolChest(new TopNQueryConfig(), QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator()), QueryRunnerTestHelper.NOOP_QUERYWATCHER))));
    }

    @Test
    public void testTopNUnionQuery() {
        TopNQuery query = new TopNQueryBuilder().dataSource((DataSource)QueryRunnerTestHelper.unionDataSource).granularity(QueryRunnerTestHelper.allGran).dimension("market").metric(QueryRunnerTestHelper.dependentPostAggMetric).threshold(4).intervals(QueryRunnerTestHelper.fullOnInterval).aggregators((List)Lists.newArrayList((Iterable)Iterables.concat(QueryRunnerTestHelper.commonDoubleAggregators, (Iterable)Lists.newArrayList((Object[])new SimpleDoubleAggregatorFactory[]{new DoubleMaxAggregatorFactory("maxIndex", "index"), new DoubleMinAggregatorFactory("minIndex", "index")})))).postAggregators(Arrays.asList(QueryRunnerTestHelper.addRowsIndexConstant, QueryRunnerTestHelper.dependentPostAgg, QueryRunnerTestHelper.hyperUniqueFinalizingPostAgg)).build();
        List expectedResults = Arrays.asList(new Result(DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.builder().put((Object)"market", (Object)"total_market").put((Object)"rows", (Object)744L).put((Object)"index", (Object)862719.3151855469).put((Object)"addRowsIndexConstant", (Object)863464.3151855469).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)864209.3151855469).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1743.9217529296875).put((Object)"minIndex", (Object)792.3260498046875).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3.000977198748901).build(), ImmutableMap.builder().put((Object)"market", (Object)"upfront").put((Object)"rows", (Object)744L).put((Object)"index", (Object)768184.4240722656).put((Object)"addRowsIndexConstant", (Object)768929.4240722656).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)769674.4240722656).put((Object)"uniques", (Object)2.000977198748901).put((Object)"maxIndex", (Object)1870.06103515625).put((Object)"minIndex", (Object)545.9906005859375).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)3.000977198748901).build(), ImmutableMap.builder().put((Object)"market", (Object)"spot").put((Object)"rows", (Object)3348L).put((Object)"index", (Object)382426.28929138184).put((Object)"addRowsIndexConstant", (Object)385775.28929138184).put((Object)QueryRunnerTestHelper.dependentPostAggMetric, (Object)389124.28929138184).put((Object)"uniques", (Object)9.019833517963864).put((Object)"hyperUniqueFinalizingPostAggMetric", (Object)10.019833517963864).put((Object)"maxIndex", (Object)277.2735290527344).put((Object)"minIndex", (Object)59.02102279663086).build()))));
        HashMap context = new HashMap();
        TestHelper.assertExpectedResults(expectedResults, this.runner.run(QueryPlus.wrap((Query)query), context));
    }
}

