/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.select;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.select.EventHolder;
import org.apache.hive.druid.io.druid.query.select.PagingSpec;
import org.apache.hive.druid.io.druid.query.select.SelectBinaryFn;
import org.apache.hive.druid.io.druid.query.select.SelectResultValue;
import org.junit.Assert;
import org.junit.Test;

public class SelectBinaryFnTest {
    private static final String segmentId1 = "testSegment";
    private static final String segmentId2 = "testSegment";

    @Test
    public void testApply() throws Exception {
        SelectBinaryFn binaryFn = new SelectBinaryFn(Granularities.ALL, new PagingSpec(null, 5), false);
        Result res1 = new Result(DateTimes.of((String)"2013-01-01"), (Object)new SelectResultValue((Map)ImmutableMap.of(), (Set)Sets.newHashSet((Object[])new String[]{"first", "fourth"}), (Set)Sets.newHashSet((Object[])new String[]{"sixth"}), Arrays.asList(new EventHolder("testSegment", 0, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01T00"), (Object)"dim", (Object)"first")), new EventHolder("testSegment", 1, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01T03"), (Object)"dim", (Object)"fourth")), new EventHolder("testSegment", 2, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01T05"), (Object)"dim", (Object)"sixth")))));
        Result res2 = new Result(DateTimes.of((String)"2013-01-01"), (Object)new SelectResultValue((Map)ImmutableMap.of(), (Set)Sets.newHashSet((Object[])new String[]{"second", "third"}), (Set)Sets.newHashSet((Object[])new String[]{"fifth"}), Arrays.asList(new EventHolder("testSegment", 0, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01T00"), (Object)"dim", (Object)"second")), new EventHolder("testSegment", 1, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01T02"), (Object)"dim", (Object)"third")), new EventHolder("testSegment", 2, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01T04"), (Object)"dim", (Object)"fifth")))));
        Result merged = binaryFn.apply(res1, res2);
        Assert.assertEquals((Object)res1.getTimestamp(), (Object)merged.getTimestamp());
        LinkedHashMap expectedPageIds = Maps.newLinkedHashMap();
        expectedPageIds.put("testSegment", 0);
        expectedPageIds.put("testSegment", 0);
        expectedPageIds.put("testSegment", 1);
        expectedPageIds.put("testSegment", 1);
        expectedPageIds.put("testSegment", 2);
        Iterator exSegmentIter = expectedPageIds.keySet().iterator();
        Iterator acSegmentIter = ((SelectResultValue)merged.getValue()).getPagingIdentifiers().keySet().iterator();
        this.verifyIters(exSegmentIter, acSegmentIter);
        Iterator exOffsetIter = expectedPageIds.values().iterator();
        Iterator acOffsetIter = ((SelectResultValue)merged.getValue()).getPagingIdentifiers().values().iterator();
        this.verifyIters(exOffsetIter, acOffsetIter);
        List<EventHolder> exEvents = Arrays.asList(new EventHolder("testSegment", 0, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01T00"), (Object)"dim", (Object)"first")), new EventHolder("testSegment", 0, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01T00"), (Object)"dim", (Object)"second")), new EventHolder("testSegment", 1, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01T02"), (Object)"dim", (Object)"third")), new EventHolder("testSegment", 1, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01T03"), (Object)"dim", (Object)"fourth")), new EventHolder("testSegment", 2, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01T04"), (Object)"dim", (Object)"fifth")));
        List acEvents = ((SelectResultValue)merged.getValue()).getEvents();
        this.verifyEvents(exEvents, acEvents);
    }

    @Test
    public void testColumnMerge() throws Exception {
        SelectBinaryFn binaryFn = new SelectBinaryFn(Granularities.ALL, new PagingSpec(null, 5), false);
        Result res1 = new Result(DateTimes.of((String)"2013-01-01"), (Object)new SelectResultValue((Map)ImmutableMap.of(), (Set)Sets.newHashSet((Object[])new String[]{"first", "second", "fourth"}), (Set)Sets.newHashSet((Object[])new String[]{"eight", "nineth"}), (List)Lists.newArrayList((Object[])new EventHolder[]{new EventHolder("testSegment", 0, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01T00"), (Object)"dim", (Object)"first"))})));
        Result res2 = new Result(DateTimes.of((String)"2013-01-01"), (Object)new SelectResultValue((Map)ImmutableMap.of(), (Set)Sets.newHashSet((Object[])new String[]{"third", "second", "fifth"}), (Set)Sets.newHashSet((Object[])new String[]{"seventh"}), (List)Lists.newArrayList((Object[])new EventHolder[]{new EventHolder("testSegment", 0, (Map)ImmutableMap.of((Object)"timestamp", (Object)DateTimes.of((String)"2013-01-01T00"), (Object)"dim", (Object)"second"))})));
        Result merged = binaryFn.apply(res1, res2);
        HashSet exDimensions = Sets.newHashSet((Object[])new String[]{"first", "second", "fourth", "third", "fifth"});
        HashSet exMetrics = Sets.newHashSet((Object[])new String[]{"eight", "nineth", "seventh"});
        Set acDimensions = ((SelectResultValue)merged.getValue()).getDimensions();
        Set acMetrics = ((SelectResultValue)merged.getValue()).getMetrics();
        Assert.assertEquals((Object)exDimensions, (Object)acDimensions);
        Assert.assertEquals((Object)exMetrics, (Object)acMetrics);
    }

    private void verifyIters(Iterator iter1, Iterator iter2) {
        while (iter1.hasNext()) {
            Assert.assertEquals(iter1.next(), iter2.next());
        }
        if (iter2.hasNext()) {
            throw new ISE("This should be empty!", new Object[0]);
        }
    }

    private void verifyEvents(List<EventHolder> events1, List<EventHolder> events2) {
        Iterator<EventHolder> ex = events1.iterator();
        Iterator<EventHolder> ac = events2.iterator();
        this.verifyIters(ex, ac);
    }
}

