/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import java.io.IOException;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactory;
import org.apache.hive.druid.io.druid.query.lookup.MapLookupExtractorFactory;
import org.junit.Assert;
import org.junit.Test;

public class MapLookupExtractorFactoryTest {
    private static final String KEY = "foo";
    private static final String VALUE = "bar";
    private static final MapLookupExtractorFactory factory = new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"foo", (Object)"bar"), true);

    @Test
    public void testSimpleExtraction() {
        Assert.assertEquals((Object)factory.get().apply(KEY), (Object)VALUE);
        Assert.assertTrue((boolean)factory.get().isOneToOne());
    }

    @Test
    public void testReplaces() {
        Assert.assertFalse((boolean)factory.replaces((LookupExtractorFactory)factory));
        Assert.assertFalse((boolean)factory.replaces((LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)KEY, (Object)VALUE), true)));
        Assert.assertTrue((boolean)factory.replaces((LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)KEY, (Object)VALUE), false)));
        Assert.assertTrue((boolean)factory.replaces((LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"foo1", (Object)VALUE), true)));
        Assert.assertTrue((boolean)factory.replaces((LookupExtractorFactory)new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)KEY, (Object)"bar1"), true)));
        Assert.assertTrue((boolean)factory.replaces(null));
    }

    @Test
    public void testSerDeserMapLookupExtractorFactory() throws IOException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.registerSubtypes(new Class[]{MapLookupExtractorFactory.class});
        MapLookupExtractorFactory lookupExtractorFactory = new MapLookupExtractorFactory((Map)ImmutableMap.of((Object)"key", (Object)"value"), true);
        Assert.assertEquals((Object)lookupExtractorFactory, (Object)mapper.reader(LookupExtractorFactory.class).readValue(mapper.writeValueAsString((Object)lookupExtractorFactory)));
    }
}

