/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.initialization;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.guice.DruidGuiceExtensions;
import org.apache.hive.druid.io.druid.guice.LifecycleModule;
import org.apache.hive.druid.io.druid.java.util.emitter.core.Emitter;
import org.apache.hive.druid.io.druid.server.emitter.ComposingEmitterConfig;
import org.apache.hive.druid.io.druid.server.emitter.ComposingEmitterModule;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class ComposingEmitterModuleTest {
    private final String testEmitterType = "http";
    private Emitter emitter;

    @Before
    public void setup() {
        this.emitter = (Emitter)EasyMock.createMock(Emitter.class);
        this.emitter.start();
        EasyMock.replay((Object[])new Object[]{this.emitter});
    }

    @Test
    public void testGetEmitter() {
        ComposingEmitterConfig config = (ComposingEmitterConfig)EasyMock.createMock(ComposingEmitterConfig.class);
        EasyMock.expect((Object)config.getEmitters()).andReturn((Object)Lists.newArrayList((Object[])new String[]{"http"})).anyTimes();
        Injector injector = (Injector)EasyMock.createMock(Injector.class);
        EasyMock.expect((Object)injector.getInstance(Key.get(Emitter.class, (Annotation)Names.named((String)"http")))).andReturn((Object)this.emitter);
        EasyMock.replay((Object[])new Object[]{config, injector});
        Emitter composingEmitter = new ComposingEmitterModule().getEmitter(config, injector);
        composingEmitter.start();
        EasyMock.verify((Object[])new Object[]{config, this.emitter, injector});
    }

    @Test
    public void testGetEmitterViaRealGuice() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new DruidGuiceExtensions(), new LifecycleModule(), new Module(){

            public void configure(Binder binder) {
                Properties props = new Properties();
                props.put("druid.emitter.composing.emitters", "[\"http\"]");
                binder.bind(Properties.class).toInstance((Object)props);
                binder.bind(Validator.class).toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
                binder.bind(Emitter.class).annotatedWith((Annotation)Names.named((String)"http")).toInstance((Object)ComposingEmitterModuleTest.this.emitter);
            }
        }, new ComposingEmitterModule()});
        ((Emitter)injector.getInstance(Key.get(Emitter.class, (Annotation)Names.named((String)"composing")))).start();
        EasyMock.verify((Object[])new Object[]{this.emitter});
    }
}

