/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.curator.inventory;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.io.druid.curator.CuratorTestBase;
import org.apache.hive.druid.io.druid.curator.inventory.CuratorInventoryManager;
import org.apache.hive.druid.io.druid.curator.inventory.CuratorInventoryManagerStrategy;
import org.apache.hive.druid.io.druid.curator.inventory.InventoryManagerConfig;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CuratorInventoryManagerTest
extends CuratorTestBase {
    private ExecutorService exec;

    @Before
    public void setUp() throws Exception {
        this.setupServerAndCurator();
        this.exec = Execs.singleThreaded((String)"curator-inventory-manager-test-%s");
    }

    @After
    public void tearDown() throws Exception {
        this.tearDownServerAndCurator();
    }

    @Test
    public void testSanity() throws Exception {
        MapStrategy strategy = new MapStrategy();
        CuratorInventoryManager manager = new CuratorInventoryManager(this.curator, (InventoryManagerConfig)new StringInventoryManagerConfig("/container", "/inventory"), this.exec, (CuratorInventoryManagerStrategy)strategy);
        this.curator.start();
        this.curator.blockUntilConnected();
        manager.start();
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)manager.getInventory()));
        CountDownLatch containerLatch = new CountDownLatch(1);
        strategy.setNewContainerLatch(containerLatch);
        ((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath("/container/billy", new byte[0]);
        Assert.assertTrue((boolean)this.timing.awaitLatch(containerLatch));
        strategy.setNewContainerLatch(null);
        Collection inventory = manager.getInventory();
        Assert.assertTrue((boolean)((Map)Iterables.getOnlyElement((Iterable)inventory)).isEmpty());
        CountDownLatch inventoryLatch = new CountDownLatch(2);
        strategy.setNewInventoryLatch(inventoryLatch);
        ((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath("/inventory/billy/1", Ints.toByteArray((int)100));
        ((ACLBackgroundPathAndBytesable)this.curator.create().withMode(CreateMode.EPHEMERAL)).forPath("/inventory/billy/bob", Ints.toByteArray((int)2287));
        Assert.assertTrue((boolean)this.timing.awaitLatch(inventoryLatch));
        strategy.setNewInventoryLatch(null);
        this.verifyInventory((CuratorInventoryManager<Map<String, Integer>, Integer>)manager);
        CountDownLatch deleteLatch = new CountDownLatch(1);
        strategy.setDeadInventoryLatch(deleteLatch);
        this.curator.delete().forPath("/inventory/billy/1");
        Assert.assertTrue((boolean)this.timing.awaitLatch(deleteLatch));
        strategy.setDeadInventoryLatch(null);
        Assert.assertEquals((long)1L, (long)((Map)manager.getInventoryValue("billy")).size());
        Assert.assertEquals((long)2287L, (long)((Integer)((Map)manager.getInventoryValue("billy")).get("bob")).intValue());
        inventoryLatch = new CountDownLatch(1);
        strategy.setNewInventoryLatch(inventoryLatch);
        ((ACLBackgroundPathAndBytesable)this.curator.create().withMode(CreateMode.EPHEMERAL)).forPath("/inventory/billy/1", Ints.toByteArray((int)100));
        Assert.assertTrue((boolean)this.timing.awaitLatch(inventoryLatch));
        strategy.setNewInventoryLatch(null);
        this.verifyInventory((CuratorInventoryManager<Map<String, Integer>, Integer>)manager);
        final CountDownLatch latch = new CountDownLatch(1);
        this.curator.getCuratorListenable().addListener((Object)new CuratorListener(){

            public void eventReceived(CuratorFramework client, CuratorEvent event) throws Exception {
                if (event.getType() == CuratorEventType.WATCHED && event.getWatchedEvent().getState() == Watcher.Event.KeeperState.Disconnected) {
                    latch.countDown();
                }
            }
        });
        this.server.stop();
        Assert.assertTrue((boolean)this.timing.awaitLatch(latch));
        this.verifyInventory((CuratorInventoryManager<Map<String, Integer>, Integer>)manager);
        Thread.sleep(50L);
        this.verifyInventory((CuratorInventoryManager<Map<String, Integer>, Integer>)manager);
    }

    private void verifyInventory(CuratorInventoryManager<Map<String, Integer>, Integer> manager) {
        Map vals = (Map)manager.getInventoryValue("billy");
        Assert.assertEquals((long)2L, (long)vals.size());
        Assert.assertEquals((long)100L, (long)((Integer)vals.get("1")).intValue());
        Assert.assertEquals((long)2287L, (long)((Integer)vals.get("bob")).intValue());
    }

    private static class MapStrategy
    implements CuratorInventoryManagerStrategy<Map<String, Integer>, Integer> {
        private volatile CountDownLatch newContainerLatch = null;
        private volatile CountDownLatch deadContainerLatch = null;
        private volatile CountDownLatch newInventoryLatch = null;
        private volatile CountDownLatch deadInventoryLatch = null;
        private volatile boolean initialized = false;

        private MapStrategy() {
        }

        public Map<String, Integer> deserializeContainer(byte[] bytes) {
            return Maps.newTreeMap();
        }

        public Integer deserializeInventory(byte[] bytes) {
            return Ints.fromByteArray((byte[])bytes);
        }

        public void newContainer(Map<String, Integer> newContainer) {
            if (this.newContainerLatch != null) {
                this.newContainerLatch.countDown();
            }
        }

        public void deadContainer(Map<String, Integer> deadContainer) {
            if (this.deadContainerLatch != null) {
                this.deadContainerLatch.countDown();
            }
        }

        public Map<String, Integer> updateContainer(Map<String, Integer> oldContainer, Map<String, Integer> newContainer) {
            newContainer.putAll(oldContainer);
            return newContainer;
        }

        public Map<String, Integer> addInventory(Map<String, Integer> container, String inventoryKey, Integer inventory) {
            container.put(inventoryKey, inventory);
            if (this.newInventoryLatch != null) {
                this.newInventoryLatch.countDown();
            }
            return container;
        }

        public Map<String, Integer> updateInventory(Map<String, Integer> container, String inventoryKey, Integer inventory) {
            return this.addInventory(container, inventoryKey, inventory);
        }

        public Map<String, Integer> removeInventory(Map<String, Integer> container, String inventoryKey) {
            container.remove(inventoryKey);
            if (this.deadInventoryLatch != null) {
                this.deadInventoryLatch.countDown();
            }
            return container;
        }

        private void setNewContainerLatch(CountDownLatch newContainerLatch) {
            this.newContainerLatch = newContainerLatch;
        }

        private void setDeadContainerLatch(CountDownLatch deadContainerLatch) {
            this.deadContainerLatch = deadContainerLatch;
        }

        private void setNewInventoryLatch(CountDownLatch newInventoryLatch) {
            this.newInventoryLatch = newInventoryLatch;
        }

        private void setDeadInventoryLatch(CountDownLatch deadInventoryLatch) {
            this.deadInventoryLatch = deadInventoryLatch;
        }

        public void inventoryInitialized() {
            this.initialized = true;
        }
    }

    private static class StringInventoryManagerConfig
    implements InventoryManagerConfig {
        private final String containerPath;
        private final String inventoryPath;

        private StringInventoryManagerConfig(String containerPath, String inventoryPath) {
            this.containerPath = containerPath;
            this.inventoryPath = inventoryPath;
        }

        public String getContainerPath() {
            return this.containerPath;
        }

        public String getInventoryPath() {
            return this.inventoryPath;
        }
    }
}

