/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Strings;
import org.apache.hive.druid.com.google.common.collect.Collections2;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.common.utils.UUIDUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UUIDUtilsTest {
    private final String[] args;
    private final String expectedBase;

    @Parameterized.Parameters
    public static Collection<Object[]> constructorFeeder() {
        ArrayList<String[]> args = new ArrayList<String[]>();
        ArrayList possibleArgs = Lists.newArrayList((Object[])new String[]{"one", "two", null, ""});
        for (String possibleArg1 : possibleArgs) {
            args.add(new String[]{possibleArg1});
            for (String possibleArg2 : possibleArgs) {
                for (String possibleArg3 : possibleArgs) {
                    args.add(new String[]{possibleArg1, possibleArg2, possibleArg3});
                }
            }
        }
        for (String possibleArg : possibleArgs) {
            args.add(new String[]{possibleArg});
        }
        return Collections2.transform(args, (Function)new Function<String[], Object[]>(){

            public Object[] apply(String[] input) {
                ArrayList<String> strings = new ArrayList<String>(input.length);
                for (String str : input) {
                    if (Strings.isNullOrEmpty((String)str)) continue;
                    strings.add(str);
                }
                String expected = !strings.isEmpty() ? Joiner.on((String)"_").join(strings) + "_" : "";
                return new Object[]{input, expected};
            }
        });
    }

    public UUIDUtilsTest(String[] args, String expectedBase) {
        this.args = args;
        this.expectedBase = expectedBase;
    }

    public static void validateIsStandardUUID(String uuidString) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(uuidString.substring(0, 8));
        strings.add(uuidString.substring(8, 12));
        strings.add(uuidString.substring(12, 16));
        strings.add(uuidString.substring(16, 20));
        strings.add(uuidString.substring(20, 32));
        UUID uuid = UUID.fromString(Joiner.on((char)'-').join(strings));
        Assert.assertEquals((Object)uuid.toString().replace("-", ""), (Object)uuidString);
    }

    @Test
    public void testUuid() {
        String uuid = UUIDUtils.generateUuid((String[])this.args);
        UUIDUtilsTest.validateIsStandardUUID(uuid.substring(this.expectedBase.length()));
    }
}

