/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections;

import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.hive.druid.com.google.common.collect.PeekingIterator;
import org.apache.hive.druid.io.druid.collections.CombiningIterator;
import org.apache.hive.druid.io.druid.java.util.common.guava.nary.BinaryFn;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CombiningIteratorTest {
    private CombiningIterator<String> testingIterator;
    private Comparator<String> comparator;
    private BinaryFn binaryFn;
    private PeekingIterator<String> peekIterator;

    @Before
    public void setUp() {
        this.peekIterator = (PeekingIterator)EasyMock.createMock(PeekingIterator.class);
        this.comparator = (Comparator)EasyMock.createMock(Comparator.class);
        this.binaryFn = (BinaryFn)EasyMock.createMock(BinaryFn.class);
        this.testingIterator = CombiningIterator.create(this.peekIterator, this.comparator, (BinaryFn)this.binaryFn);
    }

    @After
    public void tearDown() {
        this.testingIterator = null;
    }

    @Test
    public void testHasNext() {
        boolean expected = true;
        EasyMock.expect((Object)this.peekIterator.hasNext()).andReturn((Object)expected);
        EasyMock.replay((Object[])new Object[]{this.peekIterator});
        boolean actual = this.testingIterator.hasNext();
        EasyMock.verify((Object[])new Object[]{this.peekIterator});
        Assert.assertEquals((String)"The hasNext function is broken", (Object)expected, (Object)actual);
    }

    @Test
    public void testFalseBranchNext() {
        boolean expected = true;
        EasyMock.expect((Object)this.peekIterator.hasNext()).andReturn((Object)expected);
        expected = false;
        EasyMock.expect((Object)this.peekIterator.hasNext()).andReturn((Object)expected);
        EasyMock.replay((Object[])new Object[]{this.peekIterator});
        Object res = this.testingIterator.next();
        EasyMock.verify((Object[])new Object[]{this.peekIterator});
        Assert.assertNull((String)"Should be null", (Object)res);
    }

    @Test
    public void testNext() {
        boolean expected = true;
        EasyMock.expect((Object)this.peekIterator.hasNext()).andReturn((Object)expected).times(4);
        String defaultString = "S1";
        String resString = "S2";
        EasyMock.expect((Object)this.peekIterator.next()).andReturn((Object)defaultString);
        EasyMock.expect((Object)this.binaryFn.apply(EasyMock.eq((Object)defaultString), EasyMock.isNull())).andReturn((Object)resString);
        EasyMock.expect((Object)this.peekIterator.next()).andReturn((Object)defaultString);
        EasyMock.expect((Object)this.comparator.compare((String)EasyMock.eq((Object)resString), (String)EasyMock.eq((Object)defaultString))).andReturn((Object)0);
        EasyMock.expect((Object)this.peekIterator.next()).andReturn((Object)defaultString);
        EasyMock.expect((Object)this.binaryFn.apply(EasyMock.eq((Object)resString), EasyMock.eq((Object)defaultString))).andReturn((Object)resString);
        EasyMock.expect((Object)this.comparator.compare((String)EasyMock.eq((Object)resString), (String)EasyMock.eq((Object)defaultString))).andReturn((Object)1);
        EasyMock.replay((Object[])new Object[]{this.peekIterator});
        EasyMock.replay((Object[])new Object[]{this.binaryFn});
        EasyMock.replay((Object[])new Object[]{this.comparator});
        String actual = (String)this.testingIterator.next();
        Assert.assertEquals((Object)resString, (Object)actual);
        EasyMock.verify((Object[])new Object[]{this.peekIterator});
        EasyMock.verify((Object[])new Object[]{this.comparator});
        EasyMock.verify((Object[])new Object[]{this.binaryFn});
    }

    @Test(expected=NoSuchElementException.class)
    public void testExceptionInNext() throws Exception {
        boolean expected = false;
        EasyMock.expect((Object)this.peekIterator.hasNext()).andReturn((Object)expected);
        EasyMock.replay((Object[])new Object[]{this.peekIterator});
        this.testingIterator.next();
        EasyMock.verify((Object[])new Object[]{this.peekIterator});
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemove() throws Exception {
        this.testingIterator.remove();
    }
}

