/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.guava;

import java.util.Arrays;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Splitter;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.metamx.common.guava.FunctionalIterable;
import org.junit.Assert;
import org.junit.Test;

public class FunctionalIterableTest {
    @Test
    public void testTransform() throws Exception {
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)FunctionalIterable.create(Arrays.asList("1", "2", "3")).transform((Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                return Integer.parseInt(input);
            }
        })), Arrays.asList(1, 2, 3));
    }

    @Test
    public void testTransformCat() throws Exception {
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)FunctionalIterable.create(Arrays.asList("1,2", "3,4", "5,6")).transformCat((Function)new Function<String, Iterable<String>>(){

            public Iterable<String> apply(String input) {
                return Splitter.on((String)",").split((CharSequence)input);
            }
        })), Arrays.asList("1", "2", "3", "4", "5", "6"));
    }

    @Test
    public void testKeep() throws Exception {
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)FunctionalIterable.create(Arrays.asList("1", "2", "3")).keep((Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                if ("2".equals(input)) {
                    return null;
                }
                return Integer.parseInt(input);
            }
        })), Arrays.asList(1, 3));
    }

    @Test
    public void testFilter() throws Exception {
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)FunctionalIterable.create(Arrays.asList("1", "2", "3")).filter((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !"2".equals(input);
            }
        })), Arrays.asList("1", "3"));
    }

    @Test
    public void testDrop() throws Exception {
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)FunctionalIterable.create(Arrays.asList("1", "2", "3")).drop(2)), Arrays.asList("3"));
    }
}

