/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.QTestDruidSerDe;
import org.apache.hadoop.hive.druid.io.DruidQueryBasedInputFormat;
import org.apache.hadoop.hive.druid.io.HiveDruidSplit;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidSerDe;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParseException;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.util.concurrent.SettableFuture;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.com.metamx.http.client.Request;
import org.apache.hive.druid.com.metamx.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.select.SelectResultValue;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.io.druid.query.topn.TopNResultValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Ignore
public class TestDruidSerDe {
    private static final String TIMESERIES_QUERY = "{  \"queryType\": \"timeseries\",  \"dataSource\": \"sample_datasource\",  \"granularity\": \"day\",  \"descending\": \"true\",  \"filter\": {    \"type\": \"and\",    \"fields\": [      { \"type\": \"selector\", \"dimension\": \"sample_dimension1\", \"value\": \"sample_value1\" },      { \"type\": \"or\",        \"fields\": [          { \"type\": \"selector\", \"dimension\": \"sample_dimension2\", \"value\": \"sample_value2\" },          { \"type\": \"selector\", \"dimension\": \"sample_dimension3\", \"value\": \"sample_value3\" }        ]      }    ]  },  \"aggregations\": [    { \"type\": \"longSum\", \"name\": \"sample_name1\", \"fieldName\": \"sample_fieldName1\" },    { \"type\": \"doubleSum\", \"name\": \"sample_name2\", \"fieldName\": \"sample_fieldName2\" }  ],  \"postAggregations\": [    { \"type\": \"arithmetic\",      \"name\": \"sample_divide\",      \"fn\": \"/\",      \"fields\": [        { \"type\": \"fieldAccess\", \"name\": \"postAgg__sample_name1\", \"fieldName\": \"sample_name1\" },        { \"type\": \"fieldAccess\", \"name\": \"postAgg__sample_name2\", \"fieldName\": \"sample_name2\" }      ]    }  ],  \"intervals\": [ \"2012-01-01T00:00:00.000/2012-01-03T00:00:00.000\" ]}";
    private static final String TIMESERIES_QUERY_RESULTS = "[  {    \"timestamp\": \"2012-01-01T00:00:00.000Z\",    \"result\": { \"sample_name1\": 0, \"sample_name2\": 1.0, \"sample_divide\": 2.2222 }   },  {    \"timestamp\": \"2012-01-02T00:00:00.000Z\",    \"result\": { \"sample_name1\": 2, \"sample_name2\": 3.32, \"sample_divide\": 4 }  }]";
    private byte[] tsQueryResults;
    private byte[] topNQueryResults;
    private byte[] groupByQueryResults;
    private byte[] groupByTimeExtractQueryResults;
    private byte[] selectQueryResults;
    private byte[] groupByMonthExtractQueryResults;
    private static final Object[][] TIMESERIES_QUERY_RESULTS_RECORDS = new Object[][]{{new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1325376000000L).atZone(ZoneOffset.UTC))), new LongWritable(0L), new FloatWritable(1.0f), new FloatWritable(2.2222f)}, {new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1325462400000L).atZone(ZoneOffset.UTC))), new LongWritable(2L), new FloatWritable(3.32f), new FloatWritable(4.0f)}};
    private static final String TIMESERIES_COLUMN_NAMES = "timestamp,sample_name1,sample_name2,sample_divide";
    private static final String TIMESERIES_COLUMN_TYPES = "timestamp with local time zone,bigint,float,float";
    private static final String TOPN_QUERY = "{  \"queryType\": \"topN\",  \"dataSource\": \"sample_data\",  \"dimension\": \"sample_dim\",  \"threshold\": 5,  \"metric\": \"count\",  \"granularity\": \"all\",  \"filter\": {    \"type\": \"and\",    \"fields\": [      {        \"type\": \"selector\",        \"dimension\": \"dim1\",        \"value\": \"some_value\"      },      {        \"type\": \"selector\",        \"dimension\": \"dim2\",        \"value\": \"some_other_val\"      }    ]  },  \"aggregations\": [    {      \"type\": \"longSum\",      \"name\": \"count\",      \"fieldName\": \"count\"    },    {      \"type\": \"doubleSum\",      \"name\": \"some_metric\",      \"fieldName\": \"some_metric\"    }  ],  \"postAggregations\": [    {      \"type\": \"arithmetic\",      \"name\": \"sample_divide\",      \"fn\": \"/\",      \"fields\": [        {          \"type\": \"fieldAccess\",          \"name\": \"some_metric\",          \"fieldName\": \"some_metric\"        },        {          \"type\": \"fieldAccess\",          \"name\": \"count\",          \"fieldName\": \"count\"        }      ]    }  ],  \"intervals\": [    \"2013-08-31T00:00:00.000/2013-09-03T00:00:00.000\"  ]}";
    private static final String TOPN_QUERY_RESULTS = "[  {    \"timestamp\": \"2013-08-31T00:00:00.000Z\",    \"result\": [      {        \"sample_dim\": \"dim1_val\",        \"count\": 111,        \"some_metric\": 10669,        \"sample_divide\": 96.11711711711712      },      {        \"sample_dim\": \"another_dim1_val\",        \"count\": 88,        \"some_metric\": 28344,        \"sample_divide\": 322.09090909090907      },      {        \"sample_dim\": \"dim1_val3\",        \"count\": 70,        \"some_metric\": 871,        \"sample_divide\": 12.442857142857143      },      {        \"sample_dim\": \"dim1_val4\",        \"count\": 62,        \"some_metric\": 815,        \"sample_divide\": 13.14516129032258      },      {        \"sample_dim\": \"dim1_val5\",        \"count\": 60,        \"some_metric\": 2787,        \"sample_divide\": 46.45      }    ]  }]";
    private static final Object[][] TOPN_QUERY_RESULTS_RECORDS = new Object[][]{{new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1377907200000L).atZone(ZoneOffset.UTC))), new Text("dim1_val"), new LongWritable(111L), new FloatWritable(10669.0f), new FloatWritable(96.11712f)}, {new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1377907200000L).atZone(ZoneOffset.UTC))), new Text("another_dim1_val"), new LongWritable(88L), new FloatWritable(28344.0f), new FloatWritable(322.0909f)}, {new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1377907200000L).atZone(ZoneOffset.UTC))), new Text("dim1_val3"), new LongWritable(70L), new FloatWritable(871.0f), new FloatWritable(12.442857f)}, {new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1377907200000L).atZone(ZoneOffset.UTC))), new Text("dim1_val4"), new LongWritable(62L), new FloatWritable(815.0f), new FloatWritable(13.145162f)}, {new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1377907200000L).atZone(ZoneOffset.UTC))), new Text("dim1_val5"), new LongWritable(60L), new FloatWritable(2787.0f), new FloatWritable(46.45f)}};
    private static final String TOPN_COLUMN_NAMES = "timestamp,sample_dim,count,some_metric,sample_divide";
    private static final String TOPN_COLUMN_TYPES = "timestamp with local time zone,string,bigint,float,float";
    private static final String GROUP_BY_QUERY = "{  \"queryType\": \"groupBy\",  \"dataSource\": \"sample_datasource\",  \"granularity\": \"day\",  \"dimensions\": [\"country\", \"device\"],  \"limitSpec\": { \"type\": \"default\", \"limit\": 5000, \"columns\": [\"country\", \"data_transfer\"] },  \"filter\": {    \"type\": \"and\",    \"fields\": [      { \"type\": \"selector\", \"dimension\": \"carrier\", \"value\": \"AT&T\" },      { \"type\": \"or\",         \"fields\": [          { \"type\": \"selector\", \"dimension\": \"make\", \"value\": \"Apple\" },          { \"type\": \"selector\", \"dimension\": \"make\", \"value\": \"Samsung\" }        ]      }    ]  },  \"aggregations\": [    { \"type\": \"longSum\", \"name\": \"total_usage\", \"fieldName\": \"user_count\" },    { \"type\": \"doubleSum\", \"name\": \"data_transfer\", \"fieldName\": \"data_transfer\" }  ],  \"postAggregations\": [    { \"type\": \"arithmetic\",      \"name\": \"avg_usage\",      \"fn\": \"/\",      \"fields\": [        { \"type\": \"fieldAccess\", \"fieldName\": \"data_transfer\" },        { \"type\": \"fieldAccess\", \"fieldName\": \"total_usage\" }      ]    }  ],  \"intervals\": [ \"2012-01-01T00:00:00.000/2012-01-03T00:00:00.000\" ],  \"having\": {    \"type\": \"greaterThan\",    \"aggregation\": \"total_usage\",    \"value\": 100  }}";
    private static final String GROUP_BY_QUERY_RESULTS = "[   {    \"version\" : \"v1\",    \"timestamp\" : \"2012-01-01T00:00:00.000Z\",    \"event\" : {      \"country\" : \"India\",      \"device\" : \"phone\",      \"total_usage\" : 88,      \"data_transfer\" : 29.91233453,      \"avg_usage\" : 60.32    }  },   {    \"version\" : \"v1\",    \"timestamp\" : \"2012-01-01T00:00:12.000Z\",    \"event\" : {      \"country\" : \"Spain\",      \"device\" : \"pc\",      \"total_usage\" : 16,      \"data_transfer\" : 172.93494959,      \"avg_usage\" : 6.333333    }  }]";
    private static final String GB_TIME_EXTRACTIONS = "{\"queryType\":\"groupBy\",\"dataSource\":\"sample_datasource\",\"granularity\":\"all\",\"dimensions\":[{\"type\":\"extraction\",\"dimension\":\"__time\",\"outputName\":\"extract\",\"extractionFn\":{\"type\":\"timeFormat\",\"format\":\"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'\",\"timeZone\":\"UTC\"}}],\"limitSpec\":{\"type\":\"default\"},\"aggregations\":[{\"type\":\"count\",\"name\":\"$f1\"}],\"intervals\":[\"1900-01-01T00:00:00.000/3000-01-01T00:00:00.000\"]}";
    private static final String GB_TIME_EXTRACTIONS_RESULTS = "[   {    \"version\" : \"v1\",    \"timestamp\" : \"2012-01-01T00:00:00.000Z\",    \"event\" : {      \"extract\" : \"2012-01-01T00:00:00.000Z\",      \"$f1\" : 200  }  },   {    \"version\" : \"v1\",    \"timestamp\" : \"2012-01-01T00:00:12.000Z\",    \"event\" : {      \"extract\" : \"2012-01-01T00:00:12.000Z\",      \"$f1\" : 400  }   }]";
    private static final String GB_MONTH_EXTRACTIONS_RESULTS = "[   {    \"version\" : \"v1\",    \"timestamp\" : \"2012-01-01T00:00:00.000Z\",    \"event\" : {      \"extract_month\" : \"01\",      \"$f1\" : 200  }  },   {    \"version\" : \"v1\",    \"timestamp\" : \"2012-01-01T00:00:12.000Z\",    \"event\" : {      \"extract_month\" : \"01\",      \"$f1\" : 400  }   }]";
    private static final String GB_MONTH_EXTRACTIONS = "{\"queryType\":\"groupBy\",\"dataSource\":\"sample_datasource\",\"granularity\":\"all\",\"dimensions\":[{\"type\":\"extraction\",\"dimension\":\"__time\",\"outputName\":\"extract_month\",\"extractionFn\":{\"type\":\"timeFormat\",\"format\":\"M\",\"timeZone\":\"UTC\",\"locale\":\"en-US\"}}],\"limitSpec\":{\"type\":\"default\"},\"aggregations\":[{\"type\":\"count\",\"name\":\"$f1\"}],\"intervals\":[\"1900-01-01T00:00:00.000/3000-01-01T00:00:00.000\"]}";
    private static final Object[][] GROUP_BY_QUERY_EXTRACTION_RESULTS_RECORDS = new Object[][]{{new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1325376000000L).atZone(ZoneOffset.UTC))), new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1325376000000L).atZone(ZoneOffset.UTC))), new LongWritable(200L)}, {new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1325376012000L).atZone(ZoneOffset.UTC))), new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1325376012000L).atZone(ZoneOffset.UTC))), new LongWritable(400L)}};
    private static final Object[][] GROUP_BY_QUERY_RESULTS_RECORDS = new Object[][]{{new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1325376000000L).atZone(ZoneOffset.UTC))), new Text("India"), new Text("phone"), new LongWritable(88L), new DoubleWritable(29.91233453), new FloatWritable(60.32f)}, {new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1325376012000L).atZone(ZoneOffset.UTC))), new Text("Spain"), new Text("pc"), new LongWritable(16L), new DoubleWritable(172.93494959), new FloatWritable(6.333333f)}};
    private static final Object[][] GB_MONTH_EXTRACTION_RESULTS_RECORDS = new Object[][]{{new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1325376000000L).atZone(ZoneOffset.UTC))), new IntWritable(1), new LongWritable(200L)}, {new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1325376012000L).atZone(ZoneOffset.UTC))), new IntWritable(1), new LongWritable(400L)}};
    private static final String GROUP_BY_COLUMN_NAMES = "timestamp,country,device,total_usage,data_transfer,avg_usage";
    private static final String GROUP_BY_COLUMN_TYPES = "timestamp with local time zone,string,string,bigint,double,float";
    private static final String GB_TIME_EXTRACTIONS_COLUMN_NAMES = "timestamp,extract,$f1";
    private static final String GB_TIME_EXTRACTIONS_COLUMN_TYPES = "timestamp with local time zone,timestamp with local time zone,bigint";
    private static final String GB_MONTH_EXTRACTIONS_COLUMN_NAMES = "timestamp,extract_month,$f1";
    private static final String GB_MONTH_EXTRACTIONS_COLUMN_TYPES = "timestamp with local time zone,int,bigint";
    private static final String SELECT_QUERY = "{   \"queryType\": \"select\",   \"dataSource\": \"wikipedia\",   \"descending\": \"false\",   \"dimensions\":[\"robot\",\"namespace\",\"anonymous\",\"unpatrolled\",\"page\",\"language\",\"newpage\",\"user\"],   \"metrics\":[\"count\",\"added\",\"delta\",\"variation\",\"deleted\"],   \"granularity\": \"all\",   \"intervals\": [     \"2013-01-01/2013-01-02\"   ],   \"pagingSpec\":{\"pagingIdentifiers\": {}, \"threshold\":5} }";
    private static final String SELECT_QUERY_RESULTS = "[{  \"timestamp\" : \"2013-01-01T00:00:00.000Z\",  \"result\" : {    \"pagingIdentifiers\" : {      \"wikipedia_2012-12-29T00:00:00.000Z_2013-01-10T08:00:00.000Z_2013-01-10T08:13:47.830Z_v9\" : 4    },    \"events\" : [ {      \"segmentId\" : \"wikipedia_editstream_2012-12-29T00:00:00.000Z_2013-01-10T08:00:00.000Z_2013-01-10T08:13:47.830Z_v9\",      \"offset\" : 0,      \"event\" : {        \"timestamp\" : \"2013-01-01T00:00:00.000Z\",        \"robot\" : 1,        \"namespace\" : \"article\",        \"anonymous\" : \"0\",        \"unpatrolled\" : \"0\",        \"page\" : \"11._korpus_(NOVJ)\",        \"language\" : \"sl\",        \"newpage\" : \"0\",        \"user\" : \"EmausBot\",        \"count\" : 1.0,        \"added\" : 39.0,        \"delta\" : 39.0,        \"variation\" : 39.0,        \"deleted\" : 0.0      }    }, {      \"segmentId\" : \"wikipedia_2012-12-29T00:00:00.000Z_2013-01-10T08:00:00.000Z_2013-01-10T08:13:47.830Z_v9\",      \"offset\" : 1,      \"event\" : {        \"timestamp\" : \"2013-01-01T00:00:00.000Z\",        \"robot\" : 0,        \"namespace\" : \"article\",        \"anonymous\" : \"0\",        \"unpatrolled\" : \"0\",        \"page\" : \"112_U.S._580\",        \"language\" : \"en\",        \"newpage\" : \"1\",        \"user\" : \"MZMcBride\",        \"count\" : 1.0,        \"added\" : 70.0,        \"delta\" : 70.0,        \"variation\" : 70.0,        \"deleted\" : 0.0      }    }, {      \"segmentId\" : \"wikipedia_2012-12-29T00:00:00.000Z_2013-01-10T08:00:00.000Z_2013-01-10T08:13:47.830Z_v9\",      \"offset\" : 2,      \"event\" : {        \"timestamp\" : \"2013-01-01T00:00:12.000Z\",        \"robot\" : 0,        \"namespace\" : \"article\",        \"anonymous\" : \"0\",        \"unpatrolled\" : \"0\",        \"page\" : \"113_U.S._243\",        \"language\" : \"en\",        \"newpage\" : \"1\",        \"user\" : \"MZMcBride\",        \"count\" : 1.0,        \"added\" : 77.0,        \"delta\" : 77.0,        \"variation\" : 77.0,        \"deleted\" : 0.0      }    }, {      \"segmentId\" : \"wikipedia_2012-12-29T00:00:00.000Z_2013-01-10T08:00:00.000Z_2013-01-10T08:13:47.830Z_v9\",      \"offset\" : 3,      \"event\" : {        \"timestamp\" : \"2013-01-01T00:00:12.000Z\",        \"robot\" : 0,        \"namespace\" : \"article\",        \"anonymous\" : \"0\",        \"unpatrolled\" : \"0\",        \"page\" : \"113_U.S._73\",        \"language\" : \"en\",        \"newpage\" : \"1\",        \"user\" : \"MZMcBride\",        \"count\" : 1.0,        \"added\" : 70.0,        \"delta\" : 70.0,        \"variation\" : 70.0,        \"deleted\" : 0.0      }    }, {      \"segmentId\" : \"wikipedia_2012-12-29T00:00:00.000Z_2013-01-10T08:00:00.000Z_2013-01-10T08:13:47.830Z_v9\",      \"offset\" : 4,      \"event\" : {        \"timestamp\" : \"2013-01-01T00:00:12.000Z\",        \"robot\" : 0,        \"namespace\" : \"article\",        \"anonymous\" : \"0\",        \"unpatrolled\" : \"0\",        \"page\" : \"113_U.S._756\",        \"language\" : \"en\",        \"newpage\" : \"1\",        \"user\" : \"MZMcBride\",        \"count\" : 1.0,        \"added\" : 68.0,        \"delta\" : 68.0,        \"variation\" : 68.0,        \"deleted\" : 0.0      }    } ]  }} ]";
    private static final String SELECT_COLUMN_NAMES = "__time,robot,namespace,anonymous,unpatrolled,page,language,newpage,user,count,added,delta,variation,deleted";
    private static final String SELECT_COLUMN_TYPES = "timestamp with local time zone,boolean,string,string,string,string,string,string,string,double,double,float,float,float";
    private static final Object[][] SELECT_QUERY_RESULTS_RECORDS = new Object[][]{{new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1356998400000L).atZone(ZoneOffset.UTC))), new BooleanWritable(true), new Text("article"), new Text("0"), new Text("0"), new Text("11._korpus_(NOVJ)"), new Text("sl"), new Text("0"), new Text("EmausBot"), new DoubleWritable(1.0), new DoubleWritable(39.0), new FloatWritable(39.0f), new FloatWritable(39.0f), new FloatWritable(0.0f)}, {new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1356998400000L).atZone(ZoneOffset.UTC))), new BooleanWritable(false), new Text("article"), new Text("0"), new Text("0"), new Text("112_U.S._580"), new Text("en"), new Text("1"), new Text("MZMcBride"), new DoubleWritable(1.0), new DoubleWritable(70.0), new FloatWritable(70.0f), new FloatWritable(70.0f), new FloatWritable(0.0f)}, {new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1356998412000L).atZone(ZoneOffset.UTC))), new BooleanWritable(false), new Text("article"), new Text("0"), new Text("0"), new Text("113_U.S._243"), new Text("en"), new Text("1"), new Text("MZMcBride"), new DoubleWritable(1.0), new DoubleWritable(77.0), new FloatWritable(77.0f), new FloatWritable(77.0f), new FloatWritable(0.0f)}, {new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1356998412000L).atZone(ZoneOffset.UTC))), new BooleanWritable(false), new Text("article"), new Text("0"), new Text("0"), new Text("113_U.S._73"), new Text("en"), new Text("1"), new Text("MZMcBride"), new DoubleWritable(1.0), new DoubleWritable(70.0), new FloatWritable(70.0f), new FloatWritable(70.0f), new FloatWritable(0.0f)}, {new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1356998412000L).atZone(ZoneOffset.UTC))), new BooleanWritable(false), new Text("article"), new Text("0"), new Text("0"), new Text("113_U.S._756"), new Text("en"), new Text("1"), new Text("MZMcBride"), new DoubleWritable(1.0), new DoubleWritable(68.0), new FloatWritable(68.0f), new FloatWritable(68.0f), new FloatWritable(0.0f)}};
    private static final String COLUMN_NAMES = "__time,c0,c1,c2,c3,c4,c5,c6,c7,c8";
    private static final String COLUMN_TYPES = "timestamp with local time zone,string,char(6),varchar(8),double,float,bigint,int,smallint,tinyint";
    private static final Object[] ROW_OBJECT = new Object[]{new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1377907200000L).atZone(ZoneOffset.UTC))), new Text("dim1_val"), new HiveCharWritable(new HiveChar("dim2_v", 6)), new HiveVarcharWritable(new HiveVarchar("dim3_val", 8)), new DoubleWritable(10669.3), new FloatWritable(10669.45f), new LongWritable(1113939L), new IntWritable(1112123), new ShortWritable(12), new ByteWritable(0), new TimestampWritableV2(Timestamp.ofEpochSecond((long)1377907200L))};
    private static final DruidWritable DRUID_WRITABLE = new DruidWritable((Map)ImmutableMap.builder().put((Object)"__time", (Object)1377907200000L).put((Object)"c0", (Object)"dim1_val").put((Object)"c1", (Object)"dim2_v").put((Object)"c2", (Object)"dim3_val").put((Object)"c3", (Object)10669.3).put((Object)"c4", (Object)Float.valueOf(10669.45f)).put((Object)"c5", (Object)1113939L).put((Object)"c6", (Object)1112123).put((Object)"c7", (Object)12).put((Object)"c8", (Object)0).put((Object)"__time_granularity", (Object)1377907200000L).build());
    private static final Object[] ROW_OBJECT_2 = new Object[]{new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1377907200000L).atZone(ZoneOffset.UTC))), new Text("dim1_val"), new HiveCharWritable(new HiveChar("dim2_v", 6)), new HiveVarcharWritable(new HiveVarchar("dim3_val", 8)), new DoubleWritable(10669.3), new FloatWritable(10669.45f), new LongWritable(1113939L), new IntWritable(1112123), new ShortWritable(12), new ByteWritable(0)};
    private static final DruidWritable DRUID_WRITABLE_2 = new DruidWritable((Map)ImmutableMap.builder().put((Object)"__time", (Object)1377907200000L).put((Object)"c0", (Object)"dim1_val").put((Object)"c1", (Object)"dim2_v").put((Object)"c2", (Object)"dim3_val").put((Object)"c3", (Object)10669.3).put((Object)"c4", (Object)Float.valueOf(10669.45f)).put((Object)"c5", (Object)1113939L).put((Object)"c6", (Object)1112123).put((Object)"c7", (Object)12).put((Object)"c8", (Object)0).build());

    @Before
    public void setup() throws IOException {
        this.tsQueryResults = DruidStorageHandlerUtils.SMILE_MAPPER.writeValueAsBytes(DruidStorageHandlerUtils.JSON_MAPPER.readValue(TIMESERIES_QUERY_RESULTS, (TypeReference)new TypeReference<List<Result<TimeseriesResultValue>>>(){}));
        this.topNQueryResults = DruidStorageHandlerUtils.SMILE_MAPPER.writeValueAsBytes(DruidStorageHandlerUtils.JSON_MAPPER.readValue(TOPN_QUERY_RESULTS, (TypeReference)new TypeReference<List<Result<TopNResultValue>>>(){}));
        this.groupByQueryResults = DruidStorageHandlerUtils.SMILE_MAPPER.writeValueAsBytes(DruidStorageHandlerUtils.JSON_MAPPER.readValue(GROUP_BY_QUERY_RESULTS, (TypeReference)new TypeReference<List<Row>>(){}));
        this.groupByTimeExtractQueryResults = DruidStorageHandlerUtils.SMILE_MAPPER.writeValueAsBytes(DruidStorageHandlerUtils.JSON_MAPPER.readValue(GB_TIME_EXTRACTIONS_RESULTS, (TypeReference)new TypeReference<List<Row>>(){}));
        this.groupByMonthExtractQueryResults = DruidStorageHandlerUtils.SMILE_MAPPER.writeValueAsBytes(DruidStorageHandlerUtils.JSON_MAPPER.readValue(GB_MONTH_EXTRACTIONS_RESULTS, (TypeReference)new TypeReference<List<Row>>(){}));
        this.selectQueryResults = DruidStorageHandlerUtils.SMILE_MAPPER.writeValueAsBytes(DruidStorageHandlerUtils.JSON_MAPPER.readValue(SELECT_QUERY_RESULTS, (TypeReference)new TypeReference<List<Result<SelectResultValue>>>(){}));
    }

    @Test
    public void testDruidDeserializer() throws SerDeException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, IOException, InterruptedException, NoSuchMethodException, InvocationTargetException {
        QTestDruidSerDe serDe = new QTestDruidSerDe();
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        Properties tbl = TestDruidSerDe.createPropertiesQuery("sample_datasource", "timeseries", TIMESERIES_QUERY, TIMESERIES_COLUMN_NAMES, TIMESERIES_COLUMN_TYPES);
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeQueryResults(serDe, "timeseries", TIMESERIES_QUERY, this.tsQueryResults, TIMESERIES_QUERY_RESULTS_RECORDS);
        tbl = TestDruidSerDe.createPropertiesQuery("sample_data", "topN", TOPN_QUERY, TOPN_COLUMN_NAMES, TOPN_COLUMN_TYPES);
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeQueryResults(serDe, "topN", TOPN_QUERY, this.topNQueryResults, TOPN_QUERY_RESULTS_RECORDS);
        tbl = TestDruidSerDe.createPropertiesQuery("sample_datasource", "groupBy", GROUP_BY_QUERY, GROUP_BY_COLUMN_NAMES, GROUP_BY_COLUMN_TYPES);
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeQueryResults(serDe, "groupBy", GROUP_BY_QUERY, this.groupByQueryResults, GROUP_BY_QUERY_RESULTS_RECORDS);
        tbl = TestDruidSerDe.createPropertiesQuery("sample_datasource", "groupBy", GB_TIME_EXTRACTIONS, GB_TIME_EXTRACTIONS_COLUMN_NAMES, GB_TIME_EXTRACTIONS_COLUMN_TYPES);
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeQueryResults(serDe, "groupBy", GB_TIME_EXTRACTIONS, this.groupByTimeExtractQueryResults, GROUP_BY_QUERY_EXTRACTION_RESULTS_RECORDS);
        tbl = TestDruidSerDe.createPropertiesQuery("sample_datasource", "groupBy", GB_MONTH_EXTRACTIONS, GB_MONTH_EXTRACTIONS_COLUMN_NAMES, GB_MONTH_EXTRACTIONS_COLUMN_TYPES);
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeQueryResults(serDe, "groupBy", GB_MONTH_EXTRACTIONS, this.groupByMonthExtractQueryResults, GB_MONTH_EXTRACTION_RESULTS_RECORDS);
        tbl = TestDruidSerDe.createPropertiesQuery("wikipedia", "select", SELECT_QUERY, SELECT_COLUMN_NAMES, SELECT_COLUMN_TYPES);
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        this.deserializeQueryResults(serDe, "select", SELECT_QUERY, this.selectQueryResults, SELECT_QUERY_RESULTS_RECORDS);
    }

    private static Properties createPropertiesQuery(String dataSource, String queryType, String jsonQuery, String columnNames, String columnTypes) {
        Properties tbl = new Properties();
        tbl.setProperty("druid.datasource", dataSource);
        tbl.setProperty("druid.query.json", jsonQuery);
        tbl.setProperty("druid.query.type", queryType);
        tbl.setProperty("druid.fieldNames", columnNames);
        tbl.setProperty("druid.fieldTypes", columnTypes);
        return tbl;
    }

    private void deserializeQueryResults(DruidSerDe serDe, String queryType, String jsonQuery, byte[] resultString, Object[][] records) throws SerDeException, IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, InterruptedException, NoSuchMethodException, InvocationTargetException {
        Object fieldData;
        int i;
        Object[] expectedFieldsData;
        List row;
        HttpClient httpClient = (HttpClient)Mockito.mock(HttpClient.class);
        SettableFuture futureResult = SettableFuture.create();
        futureResult.set((Object)new ByteArrayInputStream(resultString));
        Mockito.when((Object)httpClient.go((Request)Matchers.anyObject(), (HttpResponseHandler)Matchers.any(HttpResponseHandler.class))).thenReturn((Object)futureResult);
        DruidQueryRecordReader reader = DruidQueryBasedInputFormat.getDruidQueryReader((String)queryType);
        HiveDruidSplit split = new HiveDruidSplit(jsonQuery, new Path("empty"), new String[]{"testing_host"});
        reader.initialize((InputSplit)split, new Configuration(), DruidStorageHandlerUtils.JSON_MAPPER, DruidStorageHandlerUtils.SMILE_MAPPER, httpClient);
        StructObjectInspector oi = (StructObjectInspector)serDe.getObjectInspector();
        List fieldRefs = oi.getAllStructFieldRefs();
        DruidWritable writable = new DruidWritable();
        int pos = 0;
        while (reader.next(NullWritable.get(), writable)) {
            row = (List)serDe.deserialize((Writable)writable);
            expectedFieldsData = records[pos];
            Assert.assertEquals((long)expectedFieldsData.length, (long)fieldRefs.size());
            for (i = 0; i < fieldRefs.size(); ++i) {
                Assert.assertEquals((String)("Field " + i + " type"), expectedFieldsData[i].getClass(), row.get(i).getClass());
                fieldData = oi.getStructFieldData((Object)row, (StructField)fieldRefs.get(i));
                Assert.assertEquals((String)("Field " + i), (Object)expectedFieldsData[i], (Object)fieldData);
            }
            ++pos;
        }
        Assert.assertEquals((long)pos, (long)records.length);
        futureResult = SettableFuture.create();
        futureResult.set((Object)new ByteArrayInputStream(resultString));
        Mockito.when((Object)httpClient.go((Request)Matchers.anyObject(), (HttpResponseHandler)Matchers.any(HttpResponseHandler.class))).thenReturn((Object)futureResult);
        reader = DruidQueryBasedInputFormat.getDruidQueryReader((String)queryType);
        reader.initialize((InputSplit)split, new Configuration(), DruidStorageHandlerUtils.JSON_MAPPER, DruidStorageHandlerUtils.SMILE_MAPPER, httpClient);
        pos = 0;
        while (reader.nextKeyValue()) {
            row = (List)serDe.deserialize((Writable)reader.getCurrentValue());
            expectedFieldsData = records[pos];
            Assert.assertEquals((long)expectedFieldsData.length, (long)fieldRefs.size());
            for (i = 0; i < fieldRefs.size(); ++i) {
                Assert.assertEquals((String)("Field " + i + " type"), expectedFieldsData[i].getClass(), row.get(i).getClass());
                fieldData = oi.getStructFieldData((Object)row, (StructField)fieldRefs.get(i));
                Assert.assertEquals((String)("Field " + i), (Object)expectedFieldsData[i], (Object)fieldData);
            }
            ++pos;
        }
        Assert.assertEquals((long)pos, (long)records.length);
    }

    @Test
    public void testDruidObjectSerializer() throws SerDeException, JsonParseException, JsonMappingException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, IOException, InterruptedException, NoSuchMethodException, InvocationTargetException {
        DruidSerDe serDe = new DruidSerDe();
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        Properties tbl = TestDruidSerDe.createPropertiesSource(COLUMN_NAMES, COLUMN_TYPES);
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        TestDruidSerDe.serializeObject(tbl, serDe, ROW_OBJECT, DRUID_WRITABLE);
    }

    private static Properties createPropertiesSource(String columnNames, String columnTypes) {
        Properties tbl = new Properties();
        tbl.setProperty("columns", columnNames);
        tbl.setProperty("columns.types", columnTypes);
        return tbl;
    }

    private static void serializeObject(Properties properties, DruidSerDe serDe, Object[] rowObject, DruidWritable druidWritable) throws SerDeException {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<PrimitiveTypeInfo> columnTypes = new ArrayList<PrimitiveTypeInfo>();
        ArrayList inspectors = new ArrayList();
        columnNames.addAll(Utilities.getColumnNames((Properties)properties));
        columnNames.add("__time_granularity");
        columnTypes.addAll(Lists.transform((List)Utilities.getColumnTypes((Properties)properties), (Function)new Function<String, PrimitiveTypeInfo>(){

            public PrimitiveTypeInfo apply(String type) {
                return TypeInfoFactory.getPrimitiveTypeInfo((String)type);
            }
        }));
        columnTypes.add(TypeInfoFactory.getPrimitiveTypeInfo((String)"timestamp"));
        inspectors.addAll(Lists.transform(columnTypes, (Function)new Function<PrimitiveTypeInfo, ObjectInspector>(){

            public ObjectInspector apply(PrimitiveTypeInfo type) {
                return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)type);
            }
        }));
        StandardStructObjectInspector inspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
        DruidWritable writable = (DruidWritable)serDe.serialize((Object)rowObject, (ObjectInspector)inspector);
        Assert.assertEquals((long)druidWritable.getValue().size(), (long)writable.getValue().size());
        for (Map.Entry e : druidWritable.getValue().entrySet()) {
            Assert.assertEquals(e.getValue(), writable.getValue().get(e.getKey()));
        }
    }

    @Test
    public void testDruidObjectDeserializer() throws SerDeException, JsonParseException, JsonMappingException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, IOException, InterruptedException, NoSuchMethodException, InvocationTargetException {
        DruidSerDe serDe = new DruidSerDe();
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        Properties tbl = TestDruidSerDe.createPropertiesSource(COLUMN_NAMES, COLUMN_TYPES);
        SerDeUtils.initializeSerDe((Deserializer)serDe, (Configuration)conf, (Properties)tbl, null);
        TestDruidSerDe.deserializeObject(tbl, serDe, ROW_OBJECT_2, DRUID_WRITABLE_2);
    }

    private static void deserializeObject(Properties properties, DruidSerDe serDe, Object[] rowObject, DruidWritable druidWritable) throws SerDeException {
        List object = (List)serDe.deserialize((Writable)druidWritable);
        Assert.assertEquals((long)rowObject.length, (long)object.size());
        for (int i = 0; i < rowObject.length; ++i) {
            Assert.assertEquals(rowObject[i].getClass(), object.get(i).getClass());
            Assert.assertEquals((Object)rowObject[i], object.get(i));
        }
    }
}

