/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.vector.jacobian;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointVectorValuePair;
import org.apache.commons.math3.optim.nonlinear.vector.Target;
import org.apache.commons.math3.optim.nonlinear.vector.Weight;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.AbstractLeastSquaresOptimizer;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.DummyOptimizer;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.RandomStraightLinePointGenerator;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.StraightLineProblem;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class AbstractLeastSquaresOptimizerTestValidation {
    private static final int MONTE_CARLO_RUNS = Integer.parseInt(System.getProperty("mcRuns", "100"));

    @Test
    public void testParametersErrorMonteCarloObservations() {
        int i;
        double yError = 15.0;
        double slope = 123.456;
        double offset = -98.765;
        RandomStraightLinePointGenerator lineGenerator = new RandomStraightLinePointGenerator(123.456, -98.765, 15.0, -1000.0, 10000.0, 138577L);
        int numObs = 100;
        int numParams = 2;
        SummaryStatistics[] paramsFoundByDirectSolution = new SummaryStatistics[2];
        SummaryStatistics[] sigmaEstimate = new SummaryStatistics[2];
        for (int i2 = 0; i2 < 2; ++i2) {
            paramsFoundByDirectSolution[i2] = new SummaryStatistics();
            sigmaEstimate[i2] = new SummaryStatistics();
        }
        DummyOptimizer optim = new DummyOptimizer();
        double[] init = new double[]{123.456, -98.765};
        int mcRepeat = MONTE_CARLO_RUNS;
        for (int mcCount = 0; mcCount < mcRepeat; ++mcCount) {
            Point2D.Double[] obs = lineGenerator.generate(100);
            StraightLineProblem problem = new StraightLineProblem(15.0);
            for (int i3 = 0; i3 < 100; ++i3) {
                Point2D.Double p = obs[i3];
                problem.addPoint(p.x, p.y);
            }
            double[] regress = problem.solve();
            PointVectorValuePair optimum = optim.optimize(new OptimizationData[]{new MaxEval(Integer.MAX_VALUE), problem.getModelFunction(), problem.getModelFunctionJacobian(), new Target(problem.target()), new Weight(problem.weight()), new InitialGuess(init)});
            double[] sigma = optim.computeSigma(optimum.getPoint(), 1.0E-14);
            for (int i4 = 0; i4 < 2; ++i4) {
                paramsFoundByDirectSolution[i4].addValue(regress[i4]);
                sigmaEstimate[i4].addValue(sigma[i4]);
            }
        }
        String line = "--------------------------------------------------------------";
        System.out.println("                 True value       Mean        Std deviation");
        for (i = 0; i < 2; ++i) {
            System.out.println("--------------------------------------------------------------");
            System.out.println("Parameter #" + i);
            StatisticalSummary s = paramsFoundByDirectSolution[i].getSummary();
            System.out.printf("              %+.6e   %+.6e   %+.6e\n", init[i], s.getMean(), s.getStandardDeviation());
            s = sigmaEstimate[i].getSummary();
            System.out.printf("sigma: %+.6e (%+.6e)\n", s.getMean(), s.getStandardDeviation());
        }
        System.out.println("--------------------------------------------------------------");
        for (i = 0; i < 2; ++i) {
            Assert.assertEquals((double)paramsFoundByDirectSolution[i].getSummary().getStandardDeviation(), (double)sigmaEstimate[i].getSummary().getMean(), (double)0.08);
        }
    }

    @Test
    public void testParametersErrorMonteCarloParameters() {
        double yError = 15.0;
        double slope = 123.456;
        double offset = -98.765;
        RandomStraightLinePointGenerator lineGenerator = new RandomStraightLinePointGenerator(123.456, -98.765, 15.0, -1000.0, 10000.0, 13839013L);
        int numObs = 10;
        Point2D.Double[] obs = lineGenerator.generate(10);
        StraightLineProblem problem = new StraightLineProblem(15.0);
        for (int i = 0; i < 10; ++i) {
            Point2D.Double p = obs[i];
            problem.addPoint(p.x, p.y);
        }
        double[] regress = problem.solve();
        DummyOptimizer optim = new DummyOptimizer();
        double bestChi2N = this.getChi2N(optim, problem, regress);
        double[] sigma = optim.computeSigma(regress, 1.0E-14);
        int mcRepeat = MONTE_CARLO_RUNS;
        int gridSize = (int)FastMath.sqrt((double)mcRepeat);
        ArrayList<double[]> paramsAndChi2 = new ArrayList<double[]>(gridSize * gridSize);
        double slopeRange = 10.0 * sigma[0];
        double offsetRange = 10.0 * sigma[1];
        double minSlope = 123.456 - 0.5 * slopeRange;
        double minOffset = -98.765 - 0.5 * offsetRange;
        double deltaSlope = slopeRange / (double)gridSize;
        double deltaOffset = offsetRange / (double)gridSize;
        for (int i = 0; i < gridSize; ++i) {
            double s = minSlope + (double)i * deltaSlope;
            for (int j = 0; j < gridSize; ++j) {
                double o = minOffset + (double)j * deltaOffset;
                double chi2N = this.getChi2N(optim, problem, new double[]{s, o});
                paramsAndChi2.add(new double[]{s, o, chi2N});
            }
        }
        double chi2NPlusOne = bestChi2N + 1.0;
        int numLarger = 0;
        String lineFmt = "%+.10e %+.10e   %.8e\n";
        System.out.printf("%+.10e %+.10e   %.8e\n", regress[0], regress[1], bestChi2N);
        System.out.println();
        for (double[] d : paramsAndChi2) {
            if (!(d[2] <= chi2NPlusOne)) continue;
            System.out.printf("%+.10e %+.10e   %.8e\n", d[0], d[1], d[2]);
        }
        System.out.println();
        for (double[] d : paramsAndChi2) {
            if (!(d[2] > chi2NPlusOne)) continue;
            ++numLarger;
            System.out.printf("%+.10e %+.10e   %.8e\n", d[0], d[1], d[2]);
        }
        System.out.println();
        System.out.println("# sigma=" + Arrays.toString(sigma));
        System.out.println("# " + numLarger + " sets filtered out");
    }

    private double getChi2N(AbstractLeastSquaresOptimizer optim, StraightLineProblem problem, double[] params) {
        double[] t = problem.target();
        double[] w = problem.weight();
        optim.optimize(new OptimizationData[]{new MaxEval(Integer.MAX_VALUE), problem.getModelFunction(), problem.getModelFunctionJacobian(), new Target(t), new Weight(w), new InitialGuess(params)});
        return optim.getChiSquare() / (double)(t.length - params.length);
    }
}

