/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StopWatchTest {
    @Test
    public void testStopWatchSimple() {
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        watch.stop();
        long time = watch.getTime();
        Assertions.assertEquals((long)time, (long)watch.getTime());
        Assertions.assertTrue((time >= 500L ? 1 : 0) != 0);
        Assertions.assertTrue((time < 700L ? 1 : 0) != 0);
        watch.reset();
        Assertions.assertEquals((long)0L, (long)watch.getTime());
    }

    @Test
    public void testStopWatchStatic() {
        StopWatch watch = StopWatch.createStarted();
        Assertions.assertTrue((boolean)watch.isStarted());
    }

    @Test
    public void testStopWatchSimpleGet() {
        StopWatch watch = new StopWatch();
        Assertions.assertEquals((long)0L, (long)watch.getTime());
        Assertions.assertEquals((Object)"00:00:00.000", (Object)watch.toString());
        watch.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertTrue((watch.getTime() < 2000L ? 1 : 0) != 0);
    }

    @Test
    public void testStopWatchGetWithTimeUnit() {
        StopWatch watch = this.createMockStopWatch(TimeUnit.HOURS.toNanos(2L) + TimeUnit.MINUTES.toNanos(59L) + TimeUnit.SECONDS.toNanos(1L) + TimeUnit.MILLISECONDS.toNanos(999L));
        Assertions.assertEquals((long)2L, (long)watch.getTime(TimeUnit.HOURS));
        Assertions.assertEquals((long)179L, (long)watch.getTime(TimeUnit.MINUTES));
        Assertions.assertEquals((long)10741L, (long)watch.getTime(TimeUnit.SECONDS));
        Assertions.assertEquals((long)10741999L, (long)watch.getTime(TimeUnit.MILLISECONDS));
    }

    @Test
    public void testStopWatchSplit() {
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        watch.split();
        long splitTime = watch.getSplitTime();
        String splitStr = watch.toSplitString();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        watch.unsplit();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        watch.stop();
        long totalTime = watch.getTime();
        Assertions.assertEquals((int)splitStr.length(), (int)12, (String)"Formatted split string not the correct length");
        Assertions.assertTrue((splitTime >= 500L ? 1 : 0) != 0);
        Assertions.assertTrue((splitTime < 700L ? 1 : 0) != 0);
        Assertions.assertTrue((totalTime >= 1500L ? 1 : 0) != 0);
        Assertions.assertTrue((totalTime < 1900L ? 1 : 0) != 0);
    }

    @Test
    public void testStopWatchSuspend() {
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        watch.suspend();
        long suspendTime = watch.getTime();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        watch.resume();
        try {
            Thread.sleep(550L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        watch.stop();
        long totalTime = watch.getTime();
        Assertions.assertTrue((suspendTime >= 500L ? 1 : 0) != 0);
        Assertions.assertTrue((suspendTime < 700L ? 1 : 0) != 0);
        Assertions.assertTrue((totalTime >= 1000L ? 1 : 0) != 0);
        Assertions.assertTrue((totalTime < 1300L ? 1 : 0) != 0);
    }

    @Test
    public void testLang315() {
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        watch.suspend();
        long suspendTime = watch.getTime();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        watch.stop();
        long totalTime = watch.getTime();
        Assertions.assertEquals((long)suspendTime, (long)totalTime);
    }

    @Test
    public void testBadStates() {
        StopWatch watch = new StopWatch();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).stop(), (String)"Calling stop on an unstarted StopWatch should throw an exception. ");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).suspend(), (String)"Calling suspend on an unstarted StopWatch should throw an exception. ");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).split(), (String)"Calling split on a non-running StopWatch should throw an exception. ");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).unsplit(), (String)"Calling unsplit on an unsplit StopWatch should throw an exception. ");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).resume(), (String)"Calling resume on an unsuspended StopWatch should throw an exception. ");
        watch.start();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).start(), (String)"Calling start on a started StopWatch should throw an exception. ");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).unsplit(), (String)"Calling unsplit on an unsplit StopWatch should throw an exception. ");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).getSplitTime(), (String)"Calling getSplitTime on an unsplit StopWatch should throw an exception. ");
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).resume(), (String)"Calling resume on an unsuspended StopWatch should throw an exception. ");
        watch.stop();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).start(), (String)"Calling start on a stopped StopWatch should throw an exception as it needs to be reset. ");
    }

    @Test
    public void testGetStartTime() {
        long beforeStopWatch = System.currentTimeMillis();
        StopWatch watch = new StopWatch();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).getStartTime(), (String)"Calling getStartTime on an unstarted StopWatch should throw an exception");
        watch.start();
        watch.getStartTime();
        Assertions.assertTrue((watch.getStartTime() >= beforeStopWatch ? 1 : 0) != 0);
        watch.reset();
        Assertions.assertThrows(IllegalStateException.class, () -> ((StopWatch)watch).getStartTime(), (String)"Calling getStartTime on a reset, but unstarted StopWatch should throw an exception");
    }

    @Test
    public void testBooleanStates() {
        StopWatch watch = new StopWatch();
        Assertions.assertFalse((boolean)watch.isStarted());
        Assertions.assertFalse((boolean)watch.isSuspended());
        Assertions.assertTrue((boolean)watch.isStopped());
        watch.start();
        Assertions.assertTrue((boolean)watch.isStarted());
        Assertions.assertFalse((boolean)watch.isSuspended());
        Assertions.assertFalse((boolean)watch.isStopped());
        watch.suspend();
        Assertions.assertTrue((boolean)watch.isStarted());
        Assertions.assertTrue((boolean)watch.isSuspended());
        Assertions.assertFalse((boolean)watch.isStopped());
        watch.stop();
        Assertions.assertFalse((boolean)watch.isStarted());
        Assertions.assertFalse((boolean)watch.isSuspended());
        Assertions.assertTrue((boolean)watch.isStopped());
    }

    private StopWatch createMockStopWatch(long nanos) {
        StopWatch watch = StopWatch.createStarted();
        watch.suspend();
        try {
            long currentNanos = System.nanoTime();
            FieldUtils.writeField((Object)watch, (String)"startTime", (Object)(currentNanos - nanos), (boolean)true);
            FieldUtils.writeField((Object)watch, (String)"stopTime", (Object)currentNanos, (boolean)true);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        return watch;
    }
}

