/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringUtilsSubstringTest {
    private static final String FOO = "foo";
    private static final String BAR = "bar";
    private static final String BAZ = "baz";
    private static final String FOOBAR = "foobar";
    private static final String SENTENCE = "foo bar baz";

    @Test
    public void testSubstring_StringInt() {
        Assertions.assertNull((Object)StringUtils.substring(null, (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substring((String)"", (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substring((String)"", (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substring((String)SENTENCE, (int)80));
        Assertions.assertEquals((Object)BAZ, (Object)StringUtils.substring((String)SENTENCE, (int)8));
        Assertions.assertEquals((Object)BAZ, (Object)StringUtils.substring((String)SENTENCE, (int)-3));
        Assertions.assertEquals((Object)SENTENCE, (Object)StringUtils.substring((String)SENTENCE, (int)0));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.substring((String)"abc", (int)-4));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.substring((String)"abc", (int)-3));
        Assertions.assertEquals((Object)"bc", (Object)StringUtils.substring((String)"abc", (int)-2));
        Assertions.assertEquals((Object)"c", (Object)StringUtils.substring((String)"abc", (int)-1));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.substring((String)"abc", (int)0));
        Assertions.assertEquals((Object)"bc", (Object)StringUtils.substring((String)"abc", (int)1));
        Assertions.assertEquals((Object)"c", (Object)StringUtils.substring((String)"abc", (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substring((String)"abc", (int)3));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substring((String)"abc", (int)4));
    }

    @Test
    public void testSubstring_StringIntInt() {
        Assertions.assertNull((Object)StringUtils.substring(null, (int)0, (int)0));
        Assertions.assertNull((Object)StringUtils.substring(null, (int)1, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substring((String)"", (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substring((String)"", (int)1, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substring((String)"", (int)-2, (int)-1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substring((String)SENTENCE, (int)8, (int)6));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.substring((String)SENTENCE, (int)0, (int)3));
        Assertions.assertEquals((Object)"o", (Object)StringUtils.substring((String)SENTENCE, (int)-9, (int)3));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.substring((String)SENTENCE, (int)0, (int)-8));
        Assertions.assertEquals((Object)"o", (Object)StringUtils.substring((String)SENTENCE, (int)-9, (int)-8));
        Assertions.assertEquals((Object)SENTENCE, (Object)StringUtils.substring((String)SENTENCE, (int)0, (int)80));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substring((String)SENTENCE, (int)2, (int)2));
        Assertions.assertEquals((Object)"b", (Object)StringUtils.substring((String)"abc", (int)-2, (int)-1));
    }

    @Test
    public void testLeft_String() {
        Assertions.assertSame(null, (Object)StringUtils.left(null, (int)-1));
        Assertions.assertSame(null, (Object)StringUtils.left(null, (int)0));
        Assertions.assertSame(null, (Object)StringUtils.left(null, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.left((String)"", (int)-1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.left((String)"", (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.left((String)"", (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.left((String)FOOBAR, (int)-1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.left((String)FOOBAR, (int)0));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.left((String)FOOBAR, (int)3));
        Assertions.assertSame((Object)FOOBAR, (Object)StringUtils.left((String)FOOBAR, (int)80));
    }

    @Test
    public void testRight_String() {
        Assertions.assertSame(null, (Object)StringUtils.right(null, (int)-1));
        Assertions.assertSame(null, (Object)StringUtils.right(null, (int)0));
        Assertions.assertSame(null, (Object)StringUtils.right(null, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.right((String)"", (int)-1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.right((String)"", (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.right((String)"", (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.right((String)FOOBAR, (int)-1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.right((String)FOOBAR, (int)0));
        Assertions.assertEquals((Object)BAR, (Object)StringUtils.right((String)FOOBAR, (int)3));
        Assertions.assertSame((Object)FOOBAR, (Object)StringUtils.right((String)FOOBAR, (int)80));
    }

    @Test
    public void testMid_String() {
        Assertions.assertSame(null, (Object)StringUtils.mid(null, (int)-1, (int)0));
        Assertions.assertSame(null, (Object)StringUtils.mid(null, (int)0, (int)-1));
        Assertions.assertSame(null, (Object)StringUtils.mid(null, (int)3, (int)0));
        Assertions.assertSame(null, (Object)StringUtils.mid(null, (int)3, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.mid((String)"", (int)0, (int)-1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.mid((String)"", (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)StringUtils.mid((String)"", (int)0, (int)2));
        Assertions.assertEquals((Object)"", (Object)StringUtils.mid((String)FOOBAR, (int)3, (int)-1));
        Assertions.assertEquals((Object)"", (Object)StringUtils.mid((String)FOOBAR, (int)3, (int)0));
        Assertions.assertEquals((Object)"b", (Object)StringUtils.mid((String)FOOBAR, (int)3, (int)1));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.mid((String)FOOBAR, (int)0, (int)3));
        Assertions.assertEquals((Object)BAR, (Object)StringUtils.mid((String)FOOBAR, (int)3, (int)3));
        Assertions.assertEquals((Object)FOOBAR, (Object)StringUtils.mid((String)FOOBAR, (int)0, (int)80));
        Assertions.assertEquals((Object)BAR, (Object)StringUtils.mid((String)FOOBAR, (int)3, (int)80));
        Assertions.assertEquals((Object)"", (Object)StringUtils.mid((String)FOOBAR, (int)9, (int)3));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.mid((String)FOOBAR, (int)-1, (int)3));
    }

    @Test
    public void testSubstringBefore_StringString() {
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.substringBefore((String)"fooXXbarXXbaz", (String)"XX"));
        Assertions.assertNull((Object)StringUtils.substringBefore(null, null));
        Assertions.assertNull((Object)StringUtils.substringBefore(null, (String)""));
        Assertions.assertNull((Object)StringUtils.substringBefore(null, (String)"XX"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringBefore((String)"", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringBefore((String)"", (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringBefore((String)"", (String)"XX"));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.substringBefore((String)FOO, null));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.substringBefore((String)FOO, (String)"b"));
        Assertions.assertEquals((Object)"f", (Object)StringUtils.substringBefore((String)"foot", (String)"o"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringBefore((String)"abc", (String)"a"));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.substringBefore((String)"abcba", (String)"b"));
        Assertions.assertEquals((Object)"ab", (Object)StringUtils.substringBefore((String)"abc", (String)"c"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringBefore((String)"abc", (String)""));
    }

    @Test
    public void testSubstringAfter_StringString() {
        Assertions.assertEquals((Object)"barXXbaz", (Object)StringUtils.substringAfter((String)"fooXXbarXXbaz", (String)"XX"));
        Assertions.assertNull((Object)StringUtils.substringAfter(null, null));
        Assertions.assertNull((Object)StringUtils.substringAfter(null, (String)""));
        Assertions.assertNull((Object)StringUtils.substringAfter(null, (String)"XX"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringAfter((String)"", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringAfter((String)"", (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringAfter((String)"", (String)"XX"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringAfter((String)FOO, null));
        Assertions.assertEquals((Object)"ot", (Object)StringUtils.substringAfter((String)"foot", (String)"o"));
        Assertions.assertEquals((Object)"bc", (Object)StringUtils.substringAfter((String)"abc", (String)"a"));
        Assertions.assertEquals((Object)"cba", (Object)StringUtils.substringAfter((String)"abcba", (String)"b"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringAfter((String)"abc", (String)"c"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.substringAfter((String)"abc", (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringAfter((String)"abc", (String)"d"));
    }

    @Test
    public void testSubstringBeforeLast_StringString() {
        Assertions.assertEquals((Object)"fooXXbar", (Object)StringUtils.substringBeforeLast((String)"fooXXbarXXbaz", (String)"XX"));
        Assertions.assertNull((Object)StringUtils.substringBeforeLast(null, null));
        Assertions.assertNull((Object)StringUtils.substringBeforeLast(null, (String)""));
        Assertions.assertNull((Object)StringUtils.substringBeforeLast(null, (String)"XX"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringBeforeLast((String)"", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringBeforeLast((String)"", (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringBeforeLast((String)"", (String)"XX"));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.substringBeforeLast((String)FOO, null));
        Assertions.assertEquals((Object)FOO, (Object)StringUtils.substringBeforeLast((String)FOO, (String)"b"));
        Assertions.assertEquals((Object)"fo", (Object)StringUtils.substringBeforeLast((String)FOO, (String)"o"));
        Assertions.assertEquals((Object)"abc\r\n", (Object)StringUtils.substringBeforeLast((String)"abc\r\n", (String)"d"));
        Assertions.assertEquals((Object)"abc", (Object)StringUtils.substringBeforeLast((String)"abcdabc", (String)"d"));
        Assertions.assertEquals((Object)"abcdabc", (Object)StringUtils.substringBeforeLast((String)"abcdabcd", (String)"d"));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.substringBeforeLast((String)"abc", (String)"b"));
        Assertions.assertEquals((Object)"abc ", (Object)StringUtils.substringBeforeLast((String)"abc \n", (String)"\n"));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.substringBeforeLast((String)"a", null));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.substringBeforeLast((String)"a", (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringBeforeLast((String)"a", (String)"a"));
    }

    @Test
    public void testSubstringAfterLast_StringString() {
        Assertions.assertEquals((Object)BAZ, (Object)StringUtils.substringAfterLast((String)"fooXXbarXXbaz", (String)"XX"));
        Assertions.assertNull((Object)StringUtils.substringAfterLast(null, null));
        Assertions.assertNull((Object)StringUtils.substringAfterLast(null, (String)""));
        Assertions.assertNull((Object)StringUtils.substringAfterLast(null, (String)"XX"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)"", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)"", (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)"", (String)"a"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)FOO, null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)FOO, (String)"b"));
        Assertions.assertEquals((Object)"t", (Object)StringUtils.substringAfterLast((String)"foot", (String)"o"));
        Assertions.assertEquals((Object)"bc", (Object)StringUtils.substringAfterLast((String)"abc", (String)"a"));
        Assertions.assertEquals((Object)"a", (Object)StringUtils.substringAfterLast((String)"abcba", (String)"b"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)"abc", (String)"c"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)"", (String)"d"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringAfterLast((String)"abc", (String)""));
    }

    @Test
    public void testSubstringBetween_StringString() {
        Assertions.assertNull((Object)StringUtils.substringBetween(null, (String)"tag"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringBetween((String)"", (String)""));
        Assertions.assertNull((Object)StringUtils.substringBetween((String)"", (String)"abc"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringBetween((String)"    ", (String)" "));
        Assertions.assertNull((Object)StringUtils.substringBetween((String)"abc", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringBetween((String)"abc", (String)""));
        Assertions.assertNull((Object)StringUtils.substringBetween((String)"abc", (String)"a"));
        Assertions.assertEquals((Object)"bc", (Object)StringUtils.substringBetween((String)"abca", (String)"a"));
        Assertions.assertEquals((Object)"bc", (Object)StringUtils.substringBetween((String)"abcabca", (String)"a"));
        Assertions.assertEquals((Object)BAR, (Object)StringUtils.substringBetween((String)"\nbar\n", (String)"\n"));
    }

    @Test
    public void testSubstringBetween_StringStringString() {
        Assertions.assertNull((Object)StringUtils.substringBetween(null, (String)"", (String)""));
        Assertions.assertNull((Object)StringUtils.substringBetween((String)"", null, (String)""));
        Assertions.assertNull((Object)StringUtils.substringBetween((String)"", (String)"", null));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringBetween((String)"", (String)"", (String)""));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringBetween((String)FOO, (String)"", (String)""));
        Assertions.assertNull((Object)StringUtils.substringBetween((String)FOO, (String)"", (String)"]"));
        Assertions.assertNull((Object)StringUtils.substringBetween((String)FOO, (String)"[", (String)"]"));
        Assertions.assertEquals((Object)"", (Object)StringUtils.substringBetween((String)"    ", (String)" ", (String)"  "));
        Assertions.assertEquals((Object)BAR, (Object)StringUtils.substringBetween((String)"<foo>bar</foo>", (String)"<foo>", (String)"</foo>"));
    }

    @Test
    public void testSubstringsBetween_StringStringString() {
        String[] results = StringUtils.substringsBetween((String)"[one], [two], [three]", (String)"[", (String)"]");
        Assertions.assertEquals((int)3, (int)results.length);
        Assertions.assertEquals((Object)"one", (Object)results[0]);
        Assertions.assertEquals((Object)"two", (Object)results[1]);
        Assertions.assertEquals((Object)"three", (Object)results[2]);
        results = StringUtils.substringsBetween((String)"[one], [two], three", (String)"[", (String)"]");
        Assertions.assertEquals((int)2, (int)results.length);
        Assertions.assertEquals((Object)"one", (Object)results[0]);
        Assertions.assertEquals((Object)"two", (Object)results[1]);
        results = StringUtils.substringsBetween((String)"[one], [two], three]", (String)"[", (String)"]");
        Assertions.assertEquals((int)2, (int)results.length);
        Assertions.assertEquals((Object)"one", (Object)results[0]);
        Assertions.assertEquals((Object)"two", (Object)results[1]);
        results = StringUtils.substringsBetween((String)"[one], two], three]", (String)"[", (String)"]");
        Assertions.assertEquals((int)1, (int)results.length);
        Assertions.assertEquals((Object)"one", (Object)results[0]);
        results = StringUtils.substringsBetween((String)"one], two], [three]", (String)"[", (String)"]");
        Assertions.assertEquals((int)1, (int)results.length);
        Assertions.assertEquals((Object)"three", (Object)results[0]);
        results = StringUtils.substringsBetween((String)"aabhellobabnonba", (String)"ab", (String)"ba");
        Assertions.assertEquals((int)1, (int)results.length);
        Assertions.assertEquals((Object)"hello", (Object)results[0]);
        results = StringUtils.substringsBetween((String)"one, two, three", (String)"[", (String)"]");
        Assertions.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"[one, two, three", (String)"[", (String)"]");
        Assertions.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"one, two, three]", (String)"[", (String)"]");
        Assertions.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"[one], [two], [three]", (String)"[", null);
        Assertions.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"[one], [two], [three]", null, (String)"]");
        Assertions.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"[one], [two], [three]", (String)"", (String)"");
        Assertions.assertNull((Object)results);
        results = StringUtils.substringsBetween(null, (String)"[", (String)"]");
        Assertions.assertNull((Object)results);
        results = StringUtils.substringsBetween((String)"", (String)"[", (String)"]");
        Assertions.assertEquals((int)0, (int)results.length);
    }

    @Test
    public void testCountMatches_String() {
        Assertions.assertEquals((int)0, (int)StringUtils.countMatches(null, null));
        Assertions.assertEquals((int)0, (int)StringUtils.countMatches((CharSequence)"blah", null));
        Assertions.assertEquals((int)0, (int)StringUtils.countMatches(null, (CharSequence)"DD"));
        Assertions.assertEquals((int)0, (int)StringUtils.countMatches((CharSequence)"x", (CharSequence)""));
        Assertions.assertEquals((int)0, (int)StringUtils.countMatches((CharSequence)"", (CharSequence)""));
        Assertions.assertEquals((int)3, (int)StringUtils.countMatches((CharSequence)"one long someone sentence of one", (CharSequence)"one"));
        Assertions.assertEquals((int)0, (int)StringUtils.countMatches((CharSequence)"one long someone sentence of one", (CharSequence)"two"));
        Assertions.assertEquals((int)4, (int)StringUtils.countMatches((CharSequence)"oooooooooooo", (CharSequence)"ooo"));
    }

    @Test
    public void testCountMatches_char() {
        Assertions.assertEquals((int)0, (int)StringUtils.countMatches(null, (char)'D'));
        Assertions.assertEquals((int)5, (int)StringUtils.countMatches((CharSequence)"one long someone sentence of one", (char)' '));
        Assertions.assertEquals((int)6, (int)StringUtils.countMatches((CharSequence)"one long someone sentence of one", (char)'o'));
        Assertions.assertEquals((int)4, (int)StringUtils.countMatches((CharSequence)"oooooooooooo", (CharSequence)"ooo"));
    }
}

