/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.managed;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.Transaction;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.managed.TestManagedDataSource;
import org.junit.Assert;

public class TestManagedDataSourceInTx
extends TestManagedDataSource {
    public TestManagedDataSourceInTx(String testName) {
        super(testName);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.transactionManager.begin();
    }

    @Override
    public void tearDown() throws Exception {
        if (this.transactionManager.getTransaction() != null) {
            this.transactionManager.commit();
        }
        super.tearDown();
    }

    @Override
    public void testManagedConnectionEqualsFail() throws Exception {
    }

    @Override
    public void testConnectionsAreDistinct() throws Exception {
        Connection[] conn = new Connection[this.getMaxTotal()];
        for (int i = 0; i < conn.length; ++i) {
            conn[i] = this.newConnection();
            for (int j = 0; j < i; ++j) {
                Assert.assertNotSame((Object)conn[j], (Object)conn[i]);
                Assert.assertNotEquals((Object)conn[j], (Object)conn[i]);
                Assert.assertEquals((Object)((DelegatingConnection)conn[j]).getInnermostDelegateInternal(), (Object)((DelegatingConnection)conn[i]).getInnermostDelegateInternal());
            }
        }
        for (Connection element : conn) {
            element.close();
        }
    }

    @Override
    public void testHashCode() throws Exception {
        Connection conn1 = this.newConnection();
        TestManagedDataSourceInTx.assertNotNull((Object)conn1);
        Connection conn2 = this.newConnection();
        TestManagedDataSourceInTx.assertNotNull((Object)conn2);
        Assert.assertNotEquals((long)conn1.hashCode(), (long)conn2.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testMaxTotal() throws Exception {
        int i;
        Transaction[] transactions = new Transaction[this.getMaxTotal()];
        Connection[] c = new Connection[this.getMaxTotal()];
        for (i = 0; i < c.length; ++i) {
            c[i] = this.newConnection();
            TestManagedDataSourceInTx.assertNotNull((Object)c[i]);
            transactions[i] = this.transactionManager.suspend();
            TestManagedDataSourceInTx.assertNotNull((Object)transactions[i]);
            this.transactionManager.begin();
        }
        try {
            this.newConnection();
            TestManagedDataSourceInTx.fail((String)"Allowed to open more than DefaultMaxTotal connections.");
        }
        catch (SQLException e) {
            this.transactionManager.commit();
            for (int i2 = 0; i2 < c.length; ++i2) {
                this.transactionManager.resume(transactions[i2]);
                c[i2].close();
                this.transactionManager.commit();
            }
        }
        finally {
            this.transactionManager.commit();
            for (i = 0; i < c.length; ++i) {
                this.transactionManager.resume(transactions[i]);
                c[i].close();
                this.transactionManager.commit();
            }
        }
    }

    @Override
    public void testClearWarnings() throws Exception {
        Connection connection = this.newConnection();
        TestManagedDataSourceInTx.assertNotNull((Object)connection);
        CallableStatement statement = connection.prepareCall("warning");
        TestManagedDataSourceInTx.assertNotNull((Object)connection.getWarnings());
        Connection sharedConnection = this.newConnection();
        TestManagedDataSourceInTx.assertNotNull((Object)sharedConnection.getWarnings());
        connection.close();
        connection = this.newConnection();
        TestManagedDataSourceInTx.assertNotNull((Object)connection.getWarnings());
        TestManagedDataSourceInTx.assertNotNull((Object)sharedConnection.getWarnings());
        statement.close();
        connection.close();
        sharedConnection.close();
    }

    @Override
    public void testSharedConnection() throws Exception {
        DelegatingConnection connectionA = (DelegatingConnection)this.newConnection();
        DelegatingConnection connectionB = (DelegatingConnection)this.newConnection();
        TestManagedDataSourceInTx.assertFalse((boolean)connectionA.equals(connectionB));
        TestManagedDataSourceInTx.assertFalse((boolean)connectionB.equals(connectionA));
        TestManagedDataSourceInTx.assertTrue((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
        TestManagedDataSourceInTx.assertTrue((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        connectionA.close();
        connectionB.close();
    }

    public void testSharedTransactionConversion() throws Exception {
        DelegatingConnection connectionA = (DelegatingConnection)this.newConnection();
        DelegatingConnection connectionB = (DelegatingConnection)this.newConnection();
        TestManagedDataSourceInTx.assertFalse((boolean)connectionA.equals(connectionB));
        TestManagedDataSourceInTx.assertFalse((boolean)connectionB.equals(connectionA));
        TestManagedDataSourceInTx.assertTrue((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
        TestManagedDataSourceInTx.assertTrue((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        this.transactionManager.commit();
        connectionA.getAutoCommit();
        connectionB.getAutoCommit();
        TestManagedDataSourceInTx.assertFalse((boolean)connectionA.equals(connectionB));
        TestManagedDataSourceInTx.assertFalse((boolean)connectionB.equals(connectionA));
        TestManagedDataSourceInTx.assertFalse((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
        TestManagedDataSourceInTx.assertFalse((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        this.transactionManager.begin();
        connectionA.getAutoCommit();
        connectionB.getAutoCommit();
        TestManagedDataSourceInTx.assertFalse((boolean)connectionA.equals(connectionB));
        TestManagedDataSourceInTx.assertFalse((boolean)connectionB.equals(connectionA));
        TestManagedDataSourceInTx.assertTrue((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
        TestManagedDataSourceInTx.assertTrue((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        connectionA.close();
        connectionB.close();
    }

    public void testCloseInTransaction() throws Exception {
        DelegatingConnection connectionA = (DelegatingConnection)this.newConnection();
        DelegatingConnection connectionB = (DelegatingConnection)this.newConnection();
        TestManagedDataSourceInTx.assertFalse((boolean)connectionA.equals(connectionB));
        TestManagedDataSourceInTx.assertFalse((boolean)connectionB.equals(connectionA));
        TestManagedDataSourceInTx.assertTrue((boolean)connectionA.innermostDelegateEquals(connectionB.getInnermostDelegate()));
        TestManagedDataSourceInTx.assertTrue((boolean)connectionB.innermostDelegateEquals(connectionA.getInnermostDelegate()));
        connectionA.close();
        connectionB.close();
        Connection connection = this.newConnection();
        TestManagedDataSourceInTx.assertFalse((String)"Connection should be open", (boolean)connection.isClosed());
        connection.close();
        TestManagedDataSourceInTx.assertTrue((String)"Connection should be closed", (boolean)connection.isClosed());
    }

    @Override
    public void testAutoCommitBehavior() throws Exception {
        Connection connection = this.newConnection();
        TestManagedDataSourceInTx.assertFalse((String)"Auto-commit should be disabled", (boolean)connection.getAutoCommit());
        try {
            connection.setAutoCommit(true);
            TestManagedDataSourceInTx.fail((String)"setAutoCommit method should be disabled while enlisted in a transaction");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        TestManagedDataSourceInTx.assertFalse((String)"Auto-commit should be disabled", (boolean)connection.getAutoCommit());
        connection.close();
    }

    public void testCommit() throws Exception {
        Connection connection = this.newConnection();
        TestManagedDataSourceInTx.assertFalse((String)"Connection should be open", (boolean)connection.isClosed());
        try {
            connection.commit();
            TestManagedDataSourceInTx.fail((String)"commit method should be disabled while enlisted in a transaction");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        TestManagedDataSourceInTx.assertFalse((String)"Connection should be open", (boolean)connection.isClosed());
        connection.close();
    }

    public void testReadOnly() throws Exception {
        Connection connection = this.newConnection();
        TestManagedDataSourceInTx.assertTrue((String)"Connection be read-only", (boolean)connection.isReadOnly());
        try {
            connection.setReadOnly(true);
            TestManagedDataSourceInTx.fail((String)"setReadOnly method should be disabled while enlisted in a transaction");
        }
        catch (SQLException e) {
            // empty catch block
        }
        TestManagedDataSourceInTx.assertTrue((String)"Connection be read-only", (boolean)connection.isReadOnly());
        try {
            connection.setReadOnly(false);
            TestManagedDataSourceInTx.fail((String)"setReadOnly method should be disabled while enlisted in a transaction");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        TestManagedDataSourceInTx.assertTrue((String)"Connection be read-only", (boolean)connection.isReadOnly());
        connection.close();
    }

    @Override
    protected void assertBackPointers(Connection conn, Statement statement) throws SQLException {
        TestManagedDataSourceInTx.assertFalse((boolean)conn.isClosed());
        TestManagedDataSourceInTx.assertFalse((boolean)this.isClosed(statement));
        TestManagedDataSourceInTx.assertSame((String)"statement.getConnection() should return the exact same connection instance that was used to create the statement", (Object)conn, (Object)statement.getConnection());
        ResultSet resultSet = statement.getResultSet();
        TestManagedDataSourceInTx.assertFalse((boolean)this.isClosed(resultSet));
        TestManagedDataSourceInTx.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)resultSet.getStatement());
        ResultSet executeResultSet = statement.executeQuery("select * from dual");
        TestManagedDataSourceInTx.assertFalse((boolean)this.isClosed(executeResultSet));
        TestManagedDataSourceInTx.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)executeResultSet.getStatement());
        ResultSet keysResultSet = statement.getGeneratedKeys();
        TestManagedDataSourceInTx.assertFalse((boolean)this.isClosed(keysResultSet));
        TestManagedDataSourceInTx.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)keysResultSet.getStatement());
        ResultSet preparedResultSet = null;
        if (statement instanceof PreparedStatement) {
            PreparedStatement preparedStatement = (PreparedStatement)statement;
            preparedResultSet = preparedStatement.executeQuery();
            TestManagedDataSourceInTx.assertFalse((boolean)this.isClosed(preparedResultSet));
            TestManagedDataSourceInTx.assertSame((String)"resultSet.getStatement() should return the exact same statement instance that was used to create the result set", (Object)statement, (Object)preparedResultSet.getStatement());
        }
        resultSet.getStatement().getConnection().close();
    }

    @Override
    public void testConnectionReturnOnCommit() throws Exception {
    }
}

