/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.tests;

import java.io.IOException;
import java.util.List;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.unpack200.AttributeLayout;
import org.apache.commons.compress.harmony.unpack200.NewAttributeBands;
import org.apache.commons.compress.harmony.unpack200.Segment;
import org.apache.commons.compress.harmony.unpack200.tests.AbstractBandsTestCase;

public class NewAttributeBandsTest
extends AbstractBandsTestCase {
    public void testEmptyLayout() throws IOException, Pack200Exception {
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 0, "", 25));
        List layoutElements = newAttributeBands.getLayoutElements();
        NewAttributeBandsTest.assertEquals((int)0, (int)layoutElements.size());
    }

    public void testIntegralLayout() throws IOException, Pack200Exception {
        this.tryIntegral("B");
        this.tryIntegral("FB");
        this.tryIntegral("SB");
        this.tryIntegral("H");
        this.tryIntegral("FH");
        this.tryIntegral("SH");
        this.tryIntegral("I");
        this.tryIntegral("FI");
        this.tryIntegral("SI");
        this.tryIntegral("PB");
        this.tryIntegral("OB");
        this.tryIntegral("OSB");
        this.tryIntegral("POB");
        this.tryIntegral("PH");
        this.tryIntegral("OH");
        this.tryIntegral("OSH");
        this.tryIntegral("POH");
        this.tryIntegral("PI");
        this.tryIntegral("OI");
        this.tryIntegral("OSI");
        this.tryIntegral("POI");
    }

    public void tryIntegral(String layout) throws IOException, Pack200Exception {
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 0, layout, 25));
        List layoutElements = newAttributeBands.getLayoutElements();
        NewAttributeBandsTest.assertEquals((int)1, (int)layoutElements.size());
        NewAttributeBands.Integral element = (NewAttributeBands.Integral)layoutElements.get(0);
        NewAttributeBandsTest.assertEquals((String)layout, (String)element.getTag());
    }

    public void testReplicationLayout() throws IOException, Pack200Exception {
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 0, "NH[PHOHRUHRSHH]", 25));
        List layoutElements = newAttributeBands.getLayoutElements();
        NewAttributeBandsTest.assertEquals((int)1, (int)layoutElements.size());
        NewAttributeBands.Replication element = (NewAttributeBands.Replication)layoutElements.get(0);
        NewAttributeBands.Integral countElement = element.getCountElement();
        NewAttributeBandsTest.assertEquals((String)"H", (String)countElement.getTag());
        List replicatedElements = element.getLayoutElements();
        NewAttributeBandsTest.assertEquals((int)5, (int)replicatedElements.size());
        NewAttributeBands.Integral firstElement = (NewAttributeBands.Integral)replicatedElements.get(0);
        NewAttributeBandsTest.assertEquals((String)"PH", (String)firstElement.getTag());
        NewAttributeBands.Integral secondElement = (NewAttributeBands.Integral)replicatedElements.get(1);
        NewAttributeBandsTest.assertEquals((String)"OH", (String)secondElement.getTag());
        NewAttributeBands.Reference thirdElement = (NewAttributeBands.Reference)replicatedElements.get(2);
        NewAttributeBandsTest.assertEquals((String)"RUH", (String)thirdElement.getTag());
        NewAttributeBands.Reference fourthElement = (NewAttributeBands.Reference)replicatedElements.get(3);
        NewAttributeBandsTest.assertEquals((String)"RSH", (String)fourthElement.getTag());
        NewAttributeBands.Integral fifthElement = (NewAttributeBands.Integral)replicatedElements.get(4);
        NewAttributeBandsTest.assertEquals((String)"H", (String)fifthElement.getTag());
    }

    public void testReferenceLayouts() throws IOException, Pack200Exception {
        this.tryReference("KIB");
        this.tryReference("KIH");
        this.tryReference("KII");
        this.tryReference("KINH");
        this.tryReference("KJH");
        this.tryReference("KDH");
        this.tryReference("KSH");
        this.tryReference("KQH");
        this.tryReference("RCH");
        this.tryReference("RSH");
        this.tryReference("RDH");
        this.tryReference("RFH");
        this.tryReference("RMH");
        this.tryReference("RIH");
        this.tryReference("RUH");
        this.tryReference("RQH");
        this.tryReference("RQNH");
        this.tryReference("RQNI");
    }

    private void tryReference(String layout) throws IOException, Pack200Exception {
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 3, layout, 26));
        List layoutElements = newAttributeBands.getLayoutElements();
        NewAttributeBandsTest.assertEquals((int)1, (int)layoutElements.size());
        NewAttributeBands.Reference element = (NewAttributeBands.Reference)layoutElements.get(0);
        NewAttributeBandsTest.assertEquals((String)layout, (String)element.getTag());
    }

    public void testUnionLayout() throws IOException, Pack200Exception {
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 3, "TB(55)[FH](23)[]()[RSH]", 26));
        List layoutElements = newAttributeBands.getLayoutElements();
        NewAttributeBandsTest.assertEquals((int)1, (int)layoutElements.size());
        NewAttributeBands.Union element = (NewAttributeBands.Union)layoutElements.get(0);
        NewAttributeBands.Integral tag = element.getUnionTag();
        NewAttributeBandsTest.assertEquals((String)"B", (String)tag.getTag());
        List unionCases = element.getUnionCases();
        NewAttributeBandsTest.assertEquals((int)2, (int)unionCases.size());
        NewAttributeBands.UnionCase firstCase = (NewAttributeBands.UnionCase)unionCases.get(0);
        NewAttributeBandsTest.assertTrue((boolean)firstCase.hasTag(55L));
        NewAttributeBandsTest.assertFalse((boolean)firstCase.hasTag(23L));
        List body = firstCase.getBody();
        NewAttributeBandsTest.assertEquals((int)1, (int)body.size());
        NewAttributeBands.Integral bodyElement = (NewAttributeBands.Integral)body.get(0);
        NewAttributeBandsTest.assertEquals((String)"FH", (String)bodyElement.getTag());
        NewAttributeBands.UnionCase secondCase = (NewAttributeBands.UnionCase)unionCases.get(1);
        NewAttributeBandsTest.assertTrue((boolean)secondCase.hasTag(23L));
        NewAttributeBandsTest.assertFalse((boolean)secondCase.hasTag(55L));
        body = secondCase.getBody();
        NewAttributeBandsTest.assertEquals((int)0, (int)body.size());
        List defaultBody = element.getDefaultCaseBody();
        NewAttributeBandsTest.assertEquals((int)1, (int)defaultBody.size());
        NewAttributeBands.Reference ref = (NewAttributeBands.Reference)defaultBody.get(0);
        NewAttributeBandsTest.assertEquals((String)"RSH", (String)ref.getTag());
    }

    public void testLayoutWithCalls() throws IOException, Pack200Exception {
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 1, "[NH[(1)]][RSH NH[RUH(1)]][TB(66,67,73,83,90)[KIH](68)[KDH](70)[KFH](74)[KJH](99)[RSH](101)[RSH RUH](115)[RUH](91)[NH[(0)]](64)[RSH[RUH(0)]]()[]]", 26));
        List layoutElements = newAttributeBands.getLayoutElements();
        NewAttributeBandsTest.assertEquals((int)3, (int)layoutElements.size());
        NewAttributeBands.Callable firstCallable = (NewAttributeBands.Callable)layoutElements.get(0);
        NewAttributeBands.Callable secondCallable = (NewAttributeBands.Callable)layoutElements.get(1);
        NewAttributeBands.Callable thirdCallable = (NewAttributeBands.Callable)layoutElements.get(2);
        List firstBody = firstCallable.getBody();
        NewAttributeBandsTest.assertEquals((int)1, (int)firstBody.size());
        NewAttributeBands.Replication rep = (NewAttributeBands.Replication)firstBody.get(0);
        List repBody = rep.getLayoutElements();
        NewAttributeBandsTest.assertEquals((int)1, (int)repBody.size());
        NewAttributeBands.Call call = (NewAttributeBands.Call)repBody.get(0);
        NewAttributeBandsTest.assertEquals((int)1, (int)call.getCallableIndex());
        NewAttributeBandsTest.assertEquals((Object)secondCallable, (Object)call.getCallable());
        NewAttributeBandsTest.assertFalse((boolean)firstCallable.isBackwardsCallable());
        NewAttributeBandsTest.assertFalse((boolean)secondCallable.isBackwardsCallable());
        NewAttributeBandsTest.assertFalse((boolean)thirdCallable.isBackwardsCallable());
    }

    public void testLayoutWithBackwardsCall() throws IOException, Pack200Exception {
        MockNewAttributeBands newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 2, "[NH[(1)]][KIH][(-1)]", 20));
        List layoutElements = newAttributeBands.getLayoutElements();
        NewAttributeBandsTest.assertEquals((int)3, (int)layoutElements.size());
        NewAttributeBands.Callable firstCallable = (NewAttributeBands.Callable)layoutElements.get(0);
        NewAttributeBands.Callable secondCallable = (NewAttributeBands.Callable)layoutElements.get(1);
        NewAttributeBands.Callable thirdCallable = (NewAttributeBands.Callable)layoutElements.get(2);
        List thirdBody = thirdCallable.getBody();
        NewAttributeBandsTest.assertEquals((int)1, (int)thirdBody.size());
        NewAttributeBands.Call call = (NewAttributeBands.Call)thirdBody.get(0);
        NewAttributeBandsTest.assertEquals((Object)secondCallable, (Object)call.getCallable());
        NewAttributeBandsTest.assertTrue((boolean)secondCallable.isBackwardsCallable());
        NewAttributeBandsTest.assertFalse((boolean)firstCallable.isBackwardsCallable());
        NewAttributeBandsTest.assertFalse((boolean)thirdCallable.isBackwardsCallable());
        newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 2, "[NH[(1)]][KIH][(-2)]", 20));
        layoutElements = newAttributeBands.getLayoutElements();
        NewAttributeBandsTest.assertEquals((int)3, (int)layoutElements.size());
        firstCallable = (NewAttributeBands.Callable)layoutElements.get(0);
        secondCallable = (NewAttributeBands.Callable)layoutElements.get(1);
        thirdCallable = (NewAttributeBands.Callable)layoutElements.get(2);
        thirdBody = thirdCallable.getBody();
        NewAttributeBandsTest.assertEquals((int)1, (int)thirdBody.size());
        call = (NewAttributeBands.Call)thirdBody.get(0);
        NewAttributeBandsTest.assertEquals((Object)firstCallable, (Object)call.getCallable());
        NewAttributeBandsTest.assertTrue((boolean)firstCallable.isBackwardsCallable());
        NewAttributeBandsTest.assertFalse((boolean)secondCallable.isBackwardsCallable());
        NewAttributeBandsTest.assertFalse((boolean)thirdCallable.isBackwardsCallable());
        newAttributeBands = new MockNewAttributeBands(new AbstractBandsTestCase.MockSegment(), new AttributeLayout("test", 2, "[NH[(1)]][KIH][(0)]", 20));
        layoutElements = newAttributeBands.getLayoutElements();
        NewAttributeBandsTest.assertEquals((int)3, (int)layoutElements.size());
        firstCallable = (NewAttributeBands.Callable)layoutElements.get(0);
        secondCallable = (NewAttributeBands.Callable)layoutElements.get(1);
        thirdCallable = (NewAttributeBands.Callable)layoutElements.get(2);
        thirdBody = thirdCallable.getBody();
        NewAttributeBandsTest.assertEquals((int)1, (int)thirdBody.size());
        call = (NewAttributeBands.Call)thirdBody.get(0);
        NewAttributeBandsTest.assertEquals((Object)thirdCallable, (Object)call.getCallable());
        NewAttributeBandsTest.assertTrue((boolean)thirdCallable.isBackwardsCallable());
        NewAttributeBandsTest.assertFalse((boolean)firstCallable.isBackwardsCallable());
        NewAttributeBandsTest.assertFalse((boolean)secondCallable.isBackwardsCallable());
        NewAttributeBandsTest.assertFalse((boolean)firstCallable.isBackwardsCallable());
    }

    private class MockNewAttributeBands
    extends NewAttributeBands {
        public MockNewAttributeBands(Segment segment, AttributeLayout layout) throws IOException {
            super(segment, layout);
        }

        public List getLayoutElements() {
            return this.attributeLayoutElements;
        }
    }
}

