/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarFile;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TarFileTest
extends AbstractTestCase {
    @Test
    public void workaroundForBrokenTimeHeader() throws IOException {
        try (TarFile tarFile = new TarFile(TarFileTest.getPath("simple-aix-native-tar.tar"));){
            List entries = tarFile.getEntries();
            Assert.assertEquals((long)3L, (long)entries.size());
            TarArchiveEntry entry = (TarArchiveEntry)entries.get(1);
            Assert.assertEquals((Object)"sample/link-to-txt-file.lnk", (Object)entry.getName());
            Assert.assertEquals((Object)new Date(0L), (Object)entry.getLastModifiedDate());
            Assert.assertTrue((boolean)entry.isSymbolicLink());
            Assert.assertTrue((boolean)entry.isCheckSumOK());
        }
    }

    @Test
    public void datePriorToEpochInGNUFormat() throws Exception {
        this.datePriorToEpoch("preepoch-star.tar");
    }

    @Test
    public void datePriorToEpochInPAXFormat() throws Exception {
        this.datePriorToEpoch("preepoch-posix.tar");
    }

    private void datePriorToEpoch(String archive) throws Exception {
        try (TarFile tarFile = new TarFile(TarFileTest.getPath(archive));){
            TarArchiveEntry entry = (TarArchiveEntry)tarFile.getEntries().get(0);
            Assert.assertEquals((Object)"foo", (Object)entry.getName());
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.set(1969, 11, 31, 23, 59, 59);
            cal.set(14, 0);
            Assert.assertEquals((Object)cal.getTime(), (Object)entry.getLastModifiedDate());
            Assert.assertTrue((boolean)entry.isCheckSumOK());
        }
    }

    @Test
    public void testCompress197() throws Exception {
        try {
            TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-197.tar"));
            Throwable throwable = null;
            if (tarFile != null) {
                if (throwable != null) {
                    try {
                        tarFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    tarFile.close();
                }
            }
        }
        catch (IOException e) {
            Assert.fail((String)("COMPRESS-197: " + e.getMessage()));
        }
    }

    @Test
    public void shouldUseSpecifiedEncodingWhenReadingGNULongNames() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String encoding = "UTF-16";
        String name = "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\u00e4";
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos, "UTF-16");){
            tos.setLongFileMode(2);
            TarArchiveEntry t = new TarArchiveEntry("12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\u00e4");
            t.setSize(1L);
            tos.putArchiveEntry((ArchiveEntry)t);
            tos.write(30);
            tos.closeArchiveEntry();
        }
        byte[] data = bos.toByteArray();
        try (TarFile tarFile = new TarFile(data, "UTF-16");){
            List entries = tarFile.getEntries();
            Assert.assertEquals((long)1L, (long)entries.size());
            Assert.assertEquals((Object)"12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\u00e4", (Object)((TarArchiveEntry)entries.get(0)).getName());
        }
    }

    @Test
    public void archiveWithTrailer() throws IOException {
        try (SeekableByteChannel channel = Files.newByteChannel(TarFileTest.getPath("archive_with_trailer.tar"), new OpenOption[0]);
             TarFile tarfile = new TarFile(channel, 10240, 512, null, false);){
            String tarAppendix = "Hello, world!\n";
            ByteBuffer buffer = ByteBuffer.allocate("Hello, world!\n".length());
            channel.read(buffer);
            Assert.assertEquals((Object)"Hello, world!\n", (Object)new String(buffer.array()));
        }
    }

    @Test
    public void readsArchiveCompletely_COMPRESS245() throws Exception {
        try {
            Path tempTar = this.resultDir.toPath().resolve("COMPRESS-245.tar");
            try (GZIPInputStream gin = new GZIPInputStream(Files.newInputStream(TarFileTest.getPath("COMPRESS-245.tar.gz"), new OpenOption[0]));){
                Files.copy(gin, tempTar, new CopyOption[0]);
            }
            var3_4 = null;
            try (TarFile tarFile = new TarFile(tempTar);){
                Assert.assertEquals((long)31L, (long)tarFile.getEntries().size());
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
        }
        catch (IOException e) {
            Assert.fail((String)("COMPRESS-245: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void shouldThrowAnExceptionOnTruncatedEntries() throws Exception {
        File dir = TarFileTest.mkdir("COMPRESS-279");
        try (TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-279.tar"));){
            int count = 0;
            for (TarArchiveEntry entry : tarFile.getEntries()) {
                Files.copy(tarFile.getInputStream(entry), dir.toPath().resolve(String.valueOf(count)), new CopyOption[0]);
                ++count;
            }
        }
        finally {
            TarFileTest.rmdir(dir);
        }
    }

    @Test
    public void shouldReadBigGid() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);){
            tos.setBigNumberMode(2);
            TarArchiveEntry t = new TarArchiveEntry("name");
            t.setGroupId(0xFFFFFFFEL);
            t.setSize(1L);
            tos.putArchiveEntry((ArchiveEntry)t);
            tos.write(30);
            tos.closeArchiveEntry();
        }
        byte[] data = bos.toByteArray();
        try (TarFile tarFile = new TarFile(data);){
            List entries = tarFile.getEntries();
            Assert.assertEquals((long)0xFFFFFFFEL, (long)((TarArchiveEntry)entries.get(0)).getLongGroupId());
        }
    }

    @Test
    public void shouldReadGNULongNameEntryWithWrongName() throws Exception {
        try (TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-324.tar"));){
            List entries = tarFile.getEntries();
            Assert.assertEquals((Object)"1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890.txt", (Object)((TarArchiveEntry)entries.get(0)).getName());
        }
    }

    @Test
    public void survivesBlankLinesInPaxHeader() throws Exception {
        try (TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-355.tar"));){
            List entries = tarFile.getEntries();
            Assert.assertEquals((long)1L, (long)entries.size());
            Assert.assertEquals((Object)"package/package.json", (Object)((TarArchiveEntry)entries.get(0)).getName());
        }
    }

    @Test
    public void survivesPaxHeaderWithNameEndingInSlash() throws Exception {
        try (TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-356.tar"));){
            List entries = tarFile.getEntries();
            Assert.assertEquals((long)1L, (long)entries.size());
            Assert.assertEquals((Object)"package/package.json", (Object)((TarArchiveEntry)entries.get(0)).getName());
        }
    }

    @Test
    public void skipsDevNumbersWhenEntryIsNoDevice() throws Exception {
        try (TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-417.tar"));){
            List entries = tarFile.getEntries();
            Assert.assertEquals((long)2L, (long)entries.size());
            Assert.assertEquals((Object)"test1.xml", (Object)((TarArchiveEntry)entries.get(0)).getName());
            Assert.assertEquals((Object)"test2.xml", (Object)((TarArchiveEntry)entries.get(1)).getName());
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (TarFile tarFile = new TarFile(TarFileTest.getPath("bla.tar"));
             InputStream input = tarFile.getInputStream((TarArchiveEntry)tarFile.getEntries().get(0));){
            IOUtils.toByteArray((InputStream)input);
            Assert.assertEquals((long)-1L, (long)input.read());
            Assert.assertEquals((long)-1L, (long)input.read());
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (TarFile tarFile = new TarFile(TarFileTest.getPath("bla.tar"));
             InputStream input = tarFile.getInputStream((TarArchiveEntry)tarFile.getEntries().get(0));){
            IOUtils.toByteArray((InputStream)input);
            Assert.assertEquals((long)-1L, (long)input.read(buf));
            Assert.assertEquals((long)-1L, (long)input.read(buf));
        }
    }

    @Test
    public void testDirectoryWithLongNameEndsWithSlash() throws IOException, ArchiveException {
        String rootPath = this.dir.getAbsolutePath();
        String dirDirectory = "COMPRESS-509";
        int count = 100;
        File root = new File(rootPath + "/" + "COMPRESS-509");
        root.mkdirs();
        for (int i = 1; i < 100; ++i) {
            StringBuilder subDirBuilder = new StringBuilder();
            for (int j = 0; j < i; ++j) {
                subDirBuilder.append("a");
            }
            String subDir = subDirBuilder.toString();
            File dir = new File(rootPath + "/" + "COMPRESS-509", "/" + subDir);
            dir.mkdir();
            String fileName = "/COMPRESS-509/" + subDir;
            File tarF = new File(rootPath + "/tar" + i + ".tar");
            try (OutputStream dest = Files.newOutputStream(tarF.toPath(), new OpenOption[0]);
                 TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new BufferedOutputStream(dest));){
                out.setBigNumberMode(1);
                out.setLongFileMode(2);
                File file = new File(rootPath, fileName);
                TarArchiveEntry entry = new TarArchiveEntry(file);
                entry.setName(fileName);
                out.putArchiveEntry((ArchiveEntry)entry);
                out.closeArchiveEntry();
                out.flush();
            }
            var12_13 = null;
            try (TarFile tarFile = new TarFile(tarF);){
                for (TarArchiveEntry entry : tarFile.getEntries()) {
                    Assert.assertTrue((String)("Entry name: " + entry.getName()), (boolean)entry.getName().endsWith("/"));
                }
                continue;
            }
            catch (Throwable throwable) {
                var12_13 = throwable;
                throw throwable;
            }
        }
    }

    @Test(expected=IOException.class)
    public void testParseTarWithSpecialPaxHeaders() throws IOException {
        TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-530.tar"));
        Throwable throwable = null;
        if (tarFile != null) {
            if (throwable != null) {
                try {
                    tarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                tarFile.close();
            }
        }
    }

    @Test(expected=IOException.class)
    public void testParseTarWithNonNumberPaxHeaders() throws IOException {
        TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-529.tar"));
        Throwable throwable = null;
        if (tarFile != null) {
            if (throwable != null) {
                try {
                    tarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                tarFile.close();
            }
        }
    }

    @Test(expected=IOException.class)
    public void testParseTarTruncatedInPadding() throws IOException {
        TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-544_truncated_in_padding.tar"));
        Throwable throwable = null;
        if (tarFile != null) {
            if (throwable != null) {
                try {
                    tarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                tarFile.close();
            }
        }
    }

    @Test(expected=IOException.class)
    public void testParseTarTruncatedInContent() throws IOException {
        TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-544_truncated_in_content.tar"));
        Throwable throwable = null;
        if (tarFile != null) {
            if (throwable != null) {
                try {
                    tarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                tarFile.close();
            }
        }
    }

    @Test(expected=IOException.class)
    public void testThrowExceptionWithNullEntry() throws IOException {
        TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-554.tar"));
        Throwable throwable = null;
        if (tarFile != null) {
            if (throwable != null) {
                try {
                    tarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                tarFile.close();
            }
        }
    }

    @Test(expected=IOException.class)
    public void testThrowException() throws IOException {
        TarFile tarFile = new TarFile(TarFileTest.getPath("COMPRESS-553.tar"));
        Throwable throwable = null;
        if (tarFile != null) {
            if (throwable != null) {
                try {
                    tarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                tarFile.close();
            }
        }
    }

    @Test
    public void testCompress558() throws IOException {
        String folderName = "apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/";
        String consumerJavaName = "apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Consumer.java";
        String producerJavaName = "apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Producer.java";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)bos);){
            tos.setLongFileMode(2);
            TarArchiveEntry rootfolder = new TarArchiveEntry("apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/");
            tos.putArchiveEntry((ArchiveEntry)rootfolder);
            TarArchiveEntry consumerJava = new TarArchiveEntry("apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Consumer.java");
            tos.putArchiveEntry((ArchiveEntry)consumerJava);
            TarArchiveEntry producerJava = new TarArchiveEntry("apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Producer.java");
            tos.putArchiveEntry((ArchiveEntry)producerJava);
            tos.closeArchiveEntry();
        }
        byte[] data = bos.toByteArray();
        try (TarFile tarFile = new TarFile(data);){
            List entries = tarFile.getEntries();
            Assert.assertEquals((Object)"apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/", (Object)((TarArchiveEntry)entries.get(0)).getName());
            Assert.assertEquals((Object)"apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Consumer.java", (Object)((TarArchiveEntry)entries.get(1)).getName());
            Assert.assertEquals((Object)"apache-activemq-5.16.0/examples/openwire/advanced-scenarios/jms-example-exclusive-consumer/src/main/java/example/queue/exclusive/Producer.java", (Object)((TarArchiveEntry)entries.get(2)).getName());
        }
    }

    @Test(expected=IOException.class)
    public void rejectsArchivesWithNegativeSizes() throws Exception {
        TarFile tf = new TarFile(TarFileTest.getFile("COMPRESS-569.tar"));
        Throwable throwable = null;
        if (tf != null) {
            if (throwable != null) {
                try {
                    tf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                tf.close();
            }
        }
    }
}

