/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.topn;

import java.nio.ByteBuffer;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.topn.Generic2AggPooledTopNScanner;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.DimensionSelector;
import org.apache.hive.druid.io.druid.segment.data.IndexedInts;

public final class Generic2AggPooledTopNScannerPrototype
implements Generic2AggPooledTopNScanner {
    @Override
    public long scanAndAggregate(DimensionSelector dimensionSelector, BufferAggregator aggregator1, int aggregator1Size, BufferAggregator aggregator2, int aggregator2Size, Cursor cursor, int[] positions, ByteBuffer resultsBuffer) {
        int totalAggregatorsSize = aggregator1Size + aggregator2Size;
        long processedRows = 0L;
        int positionToAllocate = 0;
        while (!cursor.isDoneOrInterrupted()) {
            IndexedInts dimValues = dimensionSelector.getRow();
            int dimSize = dimValues.size();
            for (int i = 0; i < dimSize; ++i) {
                int dimIndex = dimValues.get(i);
                int position = positions[dimIndex];
                if (position >= 0) {
                    aggregator1.aggregate(resultsBuffer, position);
                    aggregator2.aggregate(resultsBuffer, position + aggregator1Size);
                    continue;
                }
                if (position != -1) continue;
                positions[dimIndex] = positionToAllocate;
                position = positionToAllocate;
                aggregator1.init(resultsBuffer, position);
                aggregator1.aggregate(resultsBuffer, position);
                aggregator2.init(resultsBuffer, position += aggregator1Size);
                aggregator2.aggregate(resultsBuffer, position);
                positionToAllocate += totalAggregatorsSize;
            }
            ++processedRows;
            cursor.advanceUninterruptibly();
        }
        return processedRows;
    }
}

