/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableCollection;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.io.druid.discovery.DiscoveryDruidNode;
import org.apache.hive.druid.io.druid.discovery.DruidNodeDiscovery;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;

public abstract class DruidNodeDiscoveryProvider {
    private static final Logger log = new Logger(DruidNodeDiscoveryProvider.class);
    public static final String NODE_TYPE_COORDINATOR = "coordinator";
    public static final String NODE_TYPE_HISTORICAL = "historical";
    public static final String NODE_TYPE_BROKER = "broker";
    public static final String NODE_TYPE_OVERLORD = "overlord";
    public static final String NODE_TYPE_PEON = "peon";
    public static final String NODE_TYPE_ROUTER = "router";
    public static final String NODE_TYPE_MM = "middleManager";
    public static final Set<String> ALL_NODE_TYPES = ImmutableSet.of("coordinator", "historical", "broker", "overlord", "peon", "router", new String[]{"middleManager"});
    private static final Map<String, Set<String>> SERVICE_TO_NODE_TYPES = ImmutableMap.of("lookupNodeService", ImmutableSet.of("broker", "historical", "peon"), "dataNodeService", ImmutableSet.of("historical", "peon"), "workerNodeService", ImmutableSet.of("middleManager"));
    private final ConcurrentHashMap<String, ServiceDruidNodeDiscovery> serviceDiscoveryMap = new ConcurrentHashMap(SERVICE_TO_NODE_TYPES.size());

    public abstract DruidNodeDiscovery getForNodeType(String var1);

    public DruidNodeDiscovery getForService(String serviceName) {
        return this.serviceDiscoveryMap.compute(serviceName, (k, v) -> {
            if (v != null) {
                return v;
            }
            Set<String> nodeTypesToWatch = SERVICE_TO_NODE_TYPES.get(serviceName);
            if (nodeTypesToWatch == null) {
                throw new IAE("Unknown service [%s].", serviceName);
            }
            ServiceDruidNodeDiscovery serviceDiscovery = new ServiceDruidNodeDiscovery(serviceName);
            for (String nodeType : nodeTypesToWatch) {
                this.getForNodeType(nodeType).registerListener(serviceDiscovery.nodeTypeListener());
            }
            return serviceDiscovery;
        });
    }

    private static class ServiceDruidNodeDiscovery
    implements DruidNodeDiscovery {
        private static final Logger log = new Logger(ServiceDruidNodeDiscovery.class);
        private final String service;
        private final Map<String, DiscoveryDruidNode> nodes = new ConcurrentHashMap<String, DiscoveryDruidNode>();
        private final List<DruidNodeDiscovery.Listener> listeners = new ArrayList<DruidNodeDiscovery.Listener>();
        private final Object lock = new Object();
        private Set<NodeTypeListener> uninitializedNodeTypeListeners = new HashSet<NodeTypeListener>();

        ServiceDruidNodeDiscovery(String service) {
            this.service = service;
        }

        @Override
        public Collection<DiscoveryDruidNode> getAllNodes() {
            return Collections.unmodifiableCollection(this.nodes.values());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerListener(DruidNodeDiscovery.Listener listener) {
            Object object = this.lock;
            synchronized (object) {
                if (this.uninitializedNodeTypeListeners.isEmpty()) {
                    listener.nodesAdded(ImmutableList.copyOf(this.nodes.values()));
                }
                this.listeners.add(listener);
            }
        }

        NodeTypeListener nodeTypeListener() {
            NodeTypeListener nodeListener = new NodeTypeListener();
            this.uninitializedNodeTypeListeners.add(nodeListener);
            return nodeListener;
        }

        class NodeTypeListener
        implements DruidNodeDiscovery.Listener {
            NodeTypeListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void nodesAdded(List<DiscoveryDruidNode> nodesDiscovered) {
                Object object = ServiceDruidNodeDiscovery.this.lock;
                synchronized (object) {
                    ImmutableList.Builder builder = ImmutableList.builder();
                    for (DiscoveryDruidNode node : nodesDiscovered) {
                        if (node.getServices().containsKey(ServiceDruidNodeDiscovery.this.service)) {
                            DiscoveryDruidNode prev = ServiceDruidNodeDiscovery.this.nodes.putIfAbsent(node.getDruidNode().getHostAndPortToUse(), node);
                            if (prev == null) {
                                builder.add(node);
                                continue;
                            }
                            log.warn("Node[%s] discovered but already exists [%s].", node, prev);
                            continue;
                        }
                        log.warn("Node[%s] discovered but doesn't have service[%s]. Ignored.", node, ServiceDruidNodeDiscovery.this.service);
                    }
                    ImmutableList<DiscoveryDruidNode> newNodesAdded = null;
                    if (ServiceDruidNodeDiscovery.this.uninitializedNodeTypeListeners.isEmpty()) {
                        newNodesAdded = builder.build();
                    } else if (ServiceDruidNodeDiscovery.this.uninitializedNodeTypeListeners.remove(this) && ServiceDruidNodeDiscovery.this.uninitializedNodeTypeListeners.isEmpty()) {
                        newNodesAdded = ImmutableList.copyOf(ServiceDruidNodeDiscovery.this.nodes.values());
                    }
                    if (newNodesAdded != null) {
                        for (DruidNodeDiscovery.Listener listener : ServiceDruidNodeDiscovery.this.listeners) {
                            try {
                                listener.nodesAdded(newNodesAdded);
                            }
                            catch (Exception ex) {
                                log.error(ex, "Listener[%s].nodesAdded(%s) threw exception. Ignored.", listener, newNodesAdded);
                            }
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void nodesRemoved(List<DiscoveryDruidNode> nodesDisappeared) {
                Object object = ServiceDruidNodeDiscovery.this.lock;
                synchronized (object) {
                    ImmutableList.Builder builder = ImmutableList.builder();
                    for (DiscoveryDruidNode node : nodesDisappeared) {
                        DiscoveryDruidNode prev = (DiscoveryDruidNode)ServiceDruidNodeDiscovery.this.nodes.remove(node.getDruidNode().getHostAndPortToUse());
                        if (prev != null) {
                            builder.add(node);
                            continue;
                        }
                        log.warn("Node[%s] disappeared but was unknown for service listener [%s].", node, ServiceDruidNodeDiscovery.this.service);
                    }
                    if (ServiceDruidNodeDiscovery.this.uninitializedNodeTypeListeners.isEmpty()) {
                        ImmutableCollection nodesRemoved = builder.build();
                        for (DruidNodeDiscovery.Listener listener : ServiceDruidNodeDiscovery.this.listeners) {
                            try {
                                listener.nodesRemoved((List<DiscoveryDruidNode>)((Object)nodesRemoved));
                            }
                            catch (Exception ex) {
                                log.error(ex, "Listener[%s].nodesRemoved(%s) threw exception. Ignored.", listener, nodesRemoved);
                            }
                        }
                    }
                }
            }
        }
    }
}

