/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.stringtemplate;

import java.util.List;
import java.util.UUID;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.stringtemplate.UseStringTemplate3StatementLocator;
import org.skife.jdbi.v2.unstable.BindIn;

public class TestStringTemplate3StatementLocatorWithCustomErrorHandler {
    private DBI dbi;
    private Handle handle;
    private MyDAO dao;

    @Before
    public void setUp() {
        this.dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        this.handle = this.dbi.open();
        this.handle.createStatement("create table foo (id int, bar varchar(100) default null);").execute();
        this.dao = (MyDAO)this.dbi.onDemand(MyDAO.class);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table foo", new Object[0]);
        this.handle.close();
    }

    @Test(expected=UnableToCreateStatementException.class)
    public void testBrokenSyntax() {
        this.dao.broken();
    }

    @Test
    public void testWorks() {
        this.dao.works(Lists.newArrayList((Object[])new Long[]{1L, 2L}));
    }

    @Test
    public void testIds() {
        this.dao.ids(Lists.newArrayList((Object[])new Integer[]{1, 2}));
    }

    public static class MyTestCustomErrorHandler
    implements StringTemplateErrorListener {
        public void error(String msg, Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }

        public void warning(String msg) {
            throw new RuntimeException("warning:" + msg);
        }
    }

    @UseStringTemplate3StatementLocator(errorListener=MyTestCustomErrorHandler.class)
    public static interface MyDAO {
        @SqlQuery(value="select * from foo where bar < 12 and id in (<ids>)")
        public Object broken();

        @SqlQuery(value="select * from foo where bar \\< 12 and id in (<ids>)")
        public Object works(@BindIn(value="ids") List<Long> var1);

        @SqlQuery(value="select * from foo where id in (<ids>)")
        public Object ids(@BindIn(value="ids") List<Integer> var1);
    }
}

