/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlBatch;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Define;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.sqlobject.stringtemplate.ExternalizedSqlViaStringTemplate3;
import org.skife.jdbi.v2.sqlobject.stringtemplate.UseStringTemplate3StatementLocator;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class TestStringTemplate3Locator {
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        DBI dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        this.handle = dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testBaz() throws Exception {
        Wombat wombat = (Wombat)this.handle.attach(Wombat.class);
        wombat.insert(new Something(7, "Henning"));
        String name = (String)this.handle.createQuery("select name from something where id = 7").map((ResultSetMapper)StringMapper.FIRST).first();
        Assert.assertThat((Object)name, (Matcher)CoreMatchers.equalTo((Object)"Henning"));
    }

    @Test
    public void testBam() throws Exception {
        this.handle.execute("insert into something (id, name) values (6, 'Martin')", new Object[0]);
        Something s = ((Wombat)this.handle.attach(Wombat.class)).findById(6L);
        Assert.assertThat((Object)s.getName(), (Matcher)CoreMatchers.equalTo((Object)"Martin"));
    }

    @Test
    public void testBap() throws Exception {
        this.handle.execute("insert into something (id, name) values (2, 'Bean')", new Object[0]);
        Wombat w = (Wombat)this.handle.attach(Wombat.class);
        Assert.assertThat((Object)w.findNameFor(2), (Matcher)CoreMatchers.equalTo((Object)"Bean"));
    }

    @Test
    public void testDefines() throws Exception {
        ((Wombat)this.handle.attach(Wombat.class)).weirdInsert("something", "id", "name", 5, "Bouncer");
        ((Wombat)this.handle.attach(Wombat.class)).weirdInsert("something", "id", "name", 6, "Bean");
        String name = (String)this.handle.createQuery("select name from something where id = 5").map((ResultSetMapper)StringMapper.FIRST).first();
        Assert.assertThat((Object)name, (Matcher)CoreMatchers.equalTo((Object)"Bouncer"));
    }

    @Test
    public void testBatching() throws Exception {
        Wombat roo = (Wombat)this.handle.attach(Wombat.class);
        roo.insertBunches(new Something(1, "Jeff"), new Something(2, "Brian"));
        Assert.assertThat((Object)roo.findById(1L), (Matcher)CoreMatchers.equalTo((Object)new Something(1, "Jeff")));
        Assert.assertThat((Object)roo.findById(2L), (Matcher)CoreMatchers.equalTo((Object)new Something(2, "Brian")));
    }

    @Test
    public void testNoTemplateDefined() throws Exception {
        HoneyBadger badass = (HoneyBadger)this.handle.attach(HoneyBadger.class);
        badass.insert("something", new Something(1, "Ted"));
        badass.insert("something", new Something(2, "Fred"));
    }

    @ExternalizedSqlViaStringTemplate3
    @RegisterMapper(value={SomethingMapper.class})
    static interface Wombat {
        @SqlUpdate
        public void insert(@BindBean Something var1);

        @SqlQuery
        public Something findById(@Bind(value="id") Long var1);

        @SqlQuery(value="select name from something where id = :it")
        public String findNameFor(@Bind int var1);

        @SqlUpdate
        public void weirdInsert(@Define(value="table") String var1, @Define(value="id_column") String var2, @Define(value="value_column") String var3, @Bind(value="id") int var4, @Bind(value="value") String var5);

        @SqlBatch
        public void insertBunches(Something ... var1);
    }

    @UseStringTemplate3StatementLocator
    @RegisterMapper(value={SomethingMapper.class})
    static interface HoneyBadger {
        @SqlUpdate(value="insert into <table> (id, name) values (:id, :name)")
        public void insert(@Define(value="table") String var1, @BindBean Something var2);

        @SqlQuery(value="select id, name from <table> where id = :id")
        public Something findById(@Define(value="table") String var1, @Bind(value="id") Long var2);
    }
}

