/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlBatch;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.customizers.BatchChunkSize;
import org.skife.jdbi.v2.sqlobject.stringtemplate.UseStringTemplate3StatementLocator;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class TestBatching {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi = new DBI((DataSource)ds);
        this.dbi.registerMapper((ResultSetMapper)new SomethingMapper());
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testInsertSingleIterable() throws Exception {
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        List<Something> to_insert = Arrays.asList(new Something(1, "Tom"), new Something(2, "Tatu"));
        int[] counts = b.insertBeans(to_insert);
        Assert.assertThat((Object)counts.length, (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)counts[0], (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)counts[1], (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)b.size(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testInsertSingleIteratorNoTx() throws Exception {
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        List<Something> to_insert = Arrays.asList(new Something(1, "Tom"), new Something(2, "Tatu"));
        int[] counts = b.insertBeansNoTx(to_insert.iterator());
        Assert.assertThat((Object)counts.length, (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)counts[0], (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)counts[1], (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((Object)b.size(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testBindConstantValue() throws Exception {
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        List<Integer> ids = Arrays.asList(1, 2, 3, 4, 5);
        b.withConstantValue(ids, "Johan");
        Assert.assertThat((Object)b.size(), (Matcher)CoreMatchers.equalTo((Object)5));
        List names = this.handle.createQuery("select distinct name from something").map((ResultSetMapper)StringMapper.FIRST).list();
        Assert.assertThat((Object)names, (Matcher)CoreMatchers.equalTo(Arrays.asList("Johan")));
    }

    @Test
    public void testZipping() throws Exception {
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        List<Integer> ids = Arrays.asList(1, 2, 3, 4, 5);
        List<String> names = Arrays.asList("David", "Tim", "Mike");
        b.zipArgumentsTogether(ids, names);
        Assert.assertThat((Object)b.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        List ins_names = this.handle.createQuery("select distinct name from something order by name").map((ResultSetMapper)StringMapper.FIRST).list();
        Assert.assertThat((Object)ins_names, (Matcher)CoreMatchers.equalTo(Arrays.asList("David", "Mike", "Tim")));
    }

    @Test
    public void testChunkedBatching() throws Exception {
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        List<Something> things = Arrays.asList(new Something(1, "Brian"), new Something(2, "Henri"), new Something(3, "Patrick"), new Something(4, "Robert"), new Something(5, "Maniax"));
        int[] counts = b.insertChunked(things);
        Assert.assertThat((Object)counts.length, (Matcher)CoreMatchers.equalTo((Object)5));
        for (int count : counts) {
            Assert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }

    @Test
    public void testChunkedBatchingOnParam() throws Exception {
        UsesBatching b = (UsesBatching)this.handle.attach(UsesBatching.class);
        List<Something> things = Arrays.asList(new Something(1, "Brian"), new Something(2, "Henri"), new Something(3, "Patrick"), new Something(4, "Robert"), new Something(5, "Maniax"));
        int[] counts = b.insertChunked(3, things);
        Assert.assertThat((Object)counts.length, (Matcher)CoreMatchers.equalTo((Object)5));
        for (int count : counts) {
            Assert.assertThat((Object)count, (Matcher)CoreMatchers.equalTo((Object)1));
        }
    }

    @BatchChunkSize(value=4)
    @UseStringTemplate3StatementLocator
    public static interface UsesBatching {
        @SqlBatch(value="insert into something (id, name) values (:id, :name)")
        public int[] insertBeans(@BindBean Iterable<Something> var1);

        @SqlBatch(value="insert into something (id, name) values (:id, :name)", transactional=false)
        public int[] insertBeansNoTx(@BindBean Iterator<Something> var1);

        @SqlBatch(value="insert into something (id, name) values (:id, :name)")
        public int[] withConstantValue(@Bind(value="id") Iterable<Integer> var1, @Bind(value="name") String var2);

        @SqlBatch(value="insert into something (id, name) values (:id, :name)")
        public int[] zipArgumentsTogether(@Bind(value="id") Iterable<Integer> var1, @Bind(value="name") List<String> var2);

        @SqlBatch(value="insert into something (id, name) values (:it.id, :it.name)")
        @BatchChunkSize(value=2)
        public int[] insertChunked(@BindBean(value="it") Iterable<Something> var1);

        @SqlBatch
        public int[] insertChunked(@BatchChunkSize int var1, @BindBean(value="it") Iterable<Something> var2);

        @SqlQuery(value="select count(*) from something")
        public int size();
    }
}

