/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.InputStreamBodyGenerator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BodyChunkTest
extends AbstractBasicTest {
    private static final String MY_MESSAGE = "my message";

    @Test(groups={"standalone"})
    public void negativeContentTypeTest() throws Exception {
        DefaultAsyncHttpClientConfig config = Dsl.config().setConnectTimeout(100).setMaxConnections(50).setRequestTimeout(300000).build();
        try (AsyncHttpClient client = Dsl.asyncHttpClient((AsyncHttpClientConfig)config);){
            RequestBuilder requestBuilder = (RequestBuilder)((RequestBuilder)Dsl.post((String)this.getTargetUrl()).setHeader((CharSequence)"Content-Type", "message/rfc822")).setBody((BodyGenerator)new InputStreamBodyGenerator((InputStream)new ByteArrayInputStream(MY_MESSAGE.getBytes())));
            ListenableFuture future = client.executeRequest(requestBuilder.build());
            System.out.println("waiting for response");
            Response response = (Response)future.get();
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
            Assert.assertEquals((String)response.getResponseBody(), (String)MY_MESSAGE);
        }
    }
}

