/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpMethod;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Param;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.cookie.Cookie;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RequestBuilderTest {
    private static final String SAFE_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890-_*.";
    private static final String HEX_CHARS = "0123456789ABCDEF";

    @Test(groups={"standalone"})
    public void testEncodesQueryParameters() throws UnsupportedEncodingException {
        String[] values;
        for (String value : values = new String[]{"abcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKQLMNOPQRSTUVWXYZ", "1234567890", "1234567890", "`~!@#$%^&*()", "`~!@#$%^&*()", "_+-=,.<>/?", "_+-=,.<>/?", ";:'\"[]{}\\| ", ";:'\"[]{}\\| "}) {
            RequestBuilder builder = (RequestBuilder)Dsl.get((String)"http://example.com/").addQueryParam("name", value);
            StringBuilder sb = new StringBuilder();
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (SAFE_CHARS.indexOf(c) >= 0) {
                    sb.append(c);
                    continue;
                }
                int hi = c >> 4;
                int lo = c & 0xF;
                sb.append('%').append(HEX_CHARS.charAt(hi)).append(HEX_CHARS.charAt(lo));
            }
            String expValue = sb.toString();
            Request request = builder.build();
            Assert.assertEquals((String)request.getUrl(), (String)("http://example.com/?name=" + expValue));
        }
    }

    @Test(groups={"standalone"})
    public void testChaining() throws IOException, ExecutionException, InterruptedException {
        Request request = ((RequestBuilder)Dsl.get((String)"http://foo.com").addQueryParam("x", "value")).build();
        Request request2 = new RequestBuilder(request).build();
        Assert.assertEquals((Object)request2.getUri(), (Object)request.getUri());
    }

    @Test(groups={"standalone"})
    public void testParsesQueryParams() throws IOException, ExecutionException, InterruptedException {
        Request request = ((RequestBuilder)Dsl.get((String)"http://foo.com/?param1=value1").addQueryParam("param2", "value2")).build();
        Assert.assertEquals((String)request.getUrl(), (String)"http://foo.com/?param1=value1&param2=value2");
        List params = request.getQueryParams();
        Assert.assertEquals((int)params.size(), (int)2);
        Assert.assertEquals(params.get(0), (Object)new Param("param1", "value1"));
        Assert.assertEquals(params.get(1), (Object)new Param("param2", "value2"));
    }

    @Test(groups={"standalone"})
    public void testUserProvidedRequestMethod() {
        Request req = ((RequestBuilder)new RequestBuilder("ABC").setUrl("http://foo.com")).build();
        Assert.assertEquals((String)req.getMethod(), (String)"ABC");
        Assert.assertEquals((String)req.getUrl(), (String)"http://foo.com");
    }

    @Test(groups={"standalone"})
    public void testPercentageEncodedUserInfo() {
        Request req = Dsl.get((String)"http://hello:wor%20ld@foo.com").build();
        Assert.assertEquals((String)req.getMethod(), (String)"GET");
        Assert.assertEquals((String)req.getUrl(), (String)"http://hello:wor%20ld@foo.com");
    }

    @Test(groups={"standalone"})
    public void testContentTypeCharsetToBodyEncoding() {
        Request req = ((RequestBuilder)Dsl.get((String)"http://localhost").setHeader((CharSequence)"Content-Type", "application/json; charset=utf-8")).build();
        Assert.assertEquals((Object)req.getCharset(), (Object)StandardCharsets.UTF_8);
        Request req2 = ((RequestBuilder)Dsl.get((String)"http://localhost").setHeader((CharSequence)"Content-Type", "application/json; charset=\"utf-8\"")).build();
        Assert.assertEquals((Object)req2.getCharset(), (Object)StandardCharsets.UTF_8);
    }

    @Test
    public void testDefaultMethod() {
        RequestBuilder requestBuilder = new RequestBuilder();
        String defaultMethodName = HttpMethod.GET.name();
        Assert.assertEquals((String)requestBuilder.method, (String)defaultMethodName, (String)("Default HTTP method should be " + defaultMethodName));
    }

    @Test
    public void testSetHeaders() {
        RequestBuilder requestBuilder = new RequestBuilder();
        Assert.assertTrue((boolean)requestBuilder.headers.isEmpty(), (String)"Headers should be empty by default.");
        HashMap<String, Set<String>> headers = new HashMap<String, Set<String>>();
        headers.put("Content-Type", Collections.singleton("application/json"));
        requestBuilder.setHeaders(headers);
        Assert.assertTrue((boolean)requestBuilder.headers.contains("Content-Type"), (String)"headers set by setHeaders have not been set");
        Assert.assertEquals((String)requestBuilder.headers.get("Content-Type"), (String)"application/json", (String)"header value incorrect");
    }

    public void testAddOrReplaceCookies() {
        RequestBuilder requestBuilder = new RequestBuilder();
        Cookie cookie = new Cookie("name", "value", false, "google.com", "/", 1000L, true, true);
        requestBuilder.addOrReplaceCookie(cookie);
        Assert.assertEquals((int)requestBuilder.cookies.size(), (int)1, (String)"cookies size should be 1 after adding one cookie");
        Assert.assertEquals(requestBuilder.cookies.get(0), (Object)cookie, (String)"cookie does not match");
        Cookie cookie2 = new Cookie("name", "value2", true, "google2.com", "/path", 1001L, false, false);
        requestBuilder.addOrReplaceCookie(cookie2);
        Assert.assertEquals((int)requestBuilder.cookies.size(), (int)1, (String)"cookies size should remain 1 as we just replaced a cookie with same name");
        Assert.assertEquals(requestBuilder.cookies.get(0), (Object)cookie2, (String)"cookie does not match");
        Cookie cookie3 = new Cookie("name", "value", false, "google.com", "/", 1000L, true, true);
        requestBuilder.addOrReplaceCookie(cookie3);
        Assert.assertEquals((int)requestBuilder.cookies.size(), (int)2, (String)"cookie size must be 2 after adding 1 more cookie i.e. cookie3");
    }

    @Test
    public void testSettingQueryParamsBeforeUrlShouldNotProduceNPE() {
        RequestBuilder requestBuilder = new RequestBuilder();
        requestBuilder.setQueryParams(Collections.singletonList(new Param("key", "value")));
        requestBuilder.setUrl("http://localhost");
        Request request = requestBuilder.build();
        Assert.assertEquals((String)request.getUrl(), (String)"http://localhost?key=value");
    }
}

