/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.asynchttpclient.AbstractBasicTest;
import org.asynchttpclient.AsyncCompletionHandlerBase;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.asynchttpclient.util.MiscUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PostWithQSTest
extends AbstractBasicTest {
    @Test(groups={"standalone"})
    public void postWithQS() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)client.preparePost("http://localhost:" + this.port1 + "/?a=b").setBody("abc".getBytes())).execute();
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone"})
    public void postWithNulParamQS() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)client.preparePost("http://localhost:" + this.port1 + "/?a=").setBody("abc".getBytes())).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                public AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
                    if (!status.getUri().toUrl().equals("http://localhost:" + PostWithQSTest.this.port1 + "/?a=")) {
                        throw new IOException(status.getUri().toUrl());
                    }
                    return super.onStatusReceived(status);
                }
            });
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone"})
    public void postWithNulParamsQS() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)client.preparePost("http://localhost:" + this.port1 + "/?a=b&c&d=e").setBody("abc".getBytes())).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                public AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
                    if (!status.getUri().toUrl().equals("http://localhost:" + PostWithQSTest.this.port1 + "/?a=b&c&d=e")) {
                        throw new IOException("failed to parse the query properly");
                    }
                    return super.onStatusReceived(status);
                }
            });
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone"})
    public void postWithEmptyParamsQS() throws IOException, ExecutionException, TimeoutException, InterruptedException {
        try (AsyncHttpClient client = Dsl.asyncHttpClient();){
            ListenableFuture f = ((BoundRequestBuilder)client.preparePost("http://localhost:" + this.port1 + "/?a=b&c=&d=e").setBody("abc".getBytes())).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                public AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
                    if (!status.getUri().toUrl().equals("http://localhost:" + PostWithQSTest.this.port1 + "/?a=b&c=&d=e")) {
                        throw new IOException("failed to parse the query properly");
                    }
                    return super.onStatusReceived(status);
                }
            });
            Response resp = (Response)f.get(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)resp);
            Assert.assertEquals((int)resp.getStatusCode(), (int)200);
        }
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new PostWithQSHandler();
    }

    private class PostWithQSHandler
    extends AbstractHandler {
        private PostWithQSHandler() {
        }

        public void handle(String s, Request r, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if ("POST".equalsIgnoreCase(request.getMethod())) {
                String qs = request.getQueryString();
                if (MiscUtils.isNonEmpty((String)qs) && request.getContentLength() == 3) {
                    ServletInputStream is = request.getInputStream();
                    response.setStatus(200);
                    byte[] buf = new byte[is.available()];
                    is.readLine(buf, 0, is.available());
                    ServletOutputStream os = response.getOutputStream();
                    os.println(new String(buf));
                    os.flush();
                    os.close();
                } else {
                    response.sendError(406);
                }
            } else {
                response.sendError(403);
            }
        }
    }
}

